/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.format;

import _3650.builders_inventory.api.minimessage.MiniMessageUtil;
import _3650.builders_inventory.api.minimessage.color.UnsetColorStyle;
import _3650.builders_inventory.api.minimessage.format.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class GradientFormat
extends Format {
    public final List<class_5251> colors;
    public final float phase;
    public final int size;
    public final int realsize;
    private float increment;
    private float ind;
    private boolean overflow;
    private int indMin;
    private int indMax;
    private int colMin;
    private int colMax;

    public GradientFormat(String argString, String tag, List<class_5251> colors, double phase) {
        super(argString, tag);
        if (colors.isEmpty()) {
            colors = List.of(class_5251.method_27717((int)0xFFFFFF), class_5251.method_27717((int)0));
        }
        if (phase < 0.0) {
            this.colors = new ArrayList<class_5251>(colors.size());
            this.phase = 1.0f + (float)phase;
            for (int i = colors.size() - 1; i >= 0; --i) {
                this.colors.add(colors.get(i));
            }
        } else {
            this.colors = colors;
            this.phase = (float)phase;
        }
        this.size = colors.size() - 1;
        this.realsize = colors.size();
    }

    @Override
    public class_5250 format(class_5250 component) {
        int length = component.getString().length() - 1;
        this.increment = 1.0f / (float)length * (float)this.size;
        this.ind = 0.0f;
        this.overflow = false;
        this.indMin = -1;
        this.indMax = -1;
        this.colMin = 0;
        this.colMax = 0;
        this.updateAndColor(this.phase * (float)this.size);
        return component.method_10866().method_10973() == null ? this.formatNode((class_2561)component) : component;
    }

    private class_5250 formatNode(class_2561 component) {
        List contents = component.method_44746();
        class_5250 result = class_2561.method_43473();
        for (class_2561 content : contents) {
            if (content.method_10866().method_10973() == null) {
                UnsetColorStyle style = new UnsetColorStyle(content.method_10866());
                StringBuilder text = new StringBuilder();
                content.method_10851().method_27659(str -> {
                    text.append(str);
                    return Optional.empty();
                });
                int[] holder = new int[1];
                PrimitiveIterator.OfInt it = text.codePoints().iterator();
                while (it.hasNext()) {
                    holder[0] = it.nextInt();
                    int color = this.updateAndColor(this.ind + this.increment);
                    result.method_10852((class_2561)class_2561.method_43470((String)new String(holder, 0, 1)).method_27696(style.withColor(color)));
                }
                if (content.method_10855().isEmpty()) continue;
                class_5250 siblings = class_2561.method_43473().method_27696(content.method_10866());
                for (class_2561 sibling : content.method_10855()) {
                    siblings.method_10852((class_2561)this.formatNode(sibling));
                }
                result.method_10852((class_2561)siblings);
                continue;
            }
            result.method_10852(content);
            this.updateAndColor(this.ind + this.increment * (float)content.getString().length());
        }
        return result;
    }

    private int updateAndColor(float ind) {
        float prevInd = this.ind;
        int col = MiniMessageUtil.lerpColor(prevInd - (float)this.indMin, this.colMin, this.colMax);
        if (ind > (float)this.realsize) {
            ind -= (float)this.realsize;
            this.overflow = false;
        }
        this.ind = ind;
        if (!this.overflow && (ind > (float)this.indMax || ind < (float)this.indMin)) {
            if (ind > (float)this.size) {
                this.indMin = this.size;
                this.indMax = 0;
                this.overflow = true;
            } else {
                this.indMin = class_3532.method_15375((float)ind);
                this.indMax = class_3532.method_15386((float)ind);
            }
            this.colMin = this.colors.get(this.indMin).method_27716();
            this.colMax = this.colors.get(this.indMax).method_27716();
        }
        return col;
    }
}

