/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.widgets.slider;

import _3650.builders_inventory.api.widgets.slider.SliderWidgetTheme;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8494;

public class StepSliderWidget
extends class_339 {
    private final SliderWidgetTheme theme;
    private final int z;
    private final int min;
    private final int max;
    public final int initialValue;
    private final class_327 font;
    private final Int2ObjectFunction<List<class_2561>> tooltipFormat;
    private final IntConsumer onChange;
    private final IntConsumer onCancel;
    private final boolean canCancel;
    private final int range;
    private final int notchStep;
    private final int innerWidth;
    private final int minX;
    private final int maxX;
    private final int centerY;
    private final int halfBarHeight;
    public int value;
    private boolean dragging = false;
    private boolean focusDragging = false;

    public static StepSliderWidget standard(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange) {
        return StepSliderWidget.internalBuild(theme, x, y, z, min, max, initialValue, 0, font, tooltipFormat, onChange, noop -> {}, false);
    }

    public static StepSliderWidget standardMinSpacing(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, int minSegmentSpacing, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange) {
        return StepSliderWidget.internalBuild(theme, x, y, z, min, max, initialValue, minSegmentSpacing, font, tooltipFormat, onChange, noop -> {}, false);
    }

    public static StepSliderWidget cancel(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange, IntConsumer onCancel) {
        return StepSliderWidget.internalBuild(theme, x, y, z, min, max, initialValue, 0, font, tooltipFormat, onChange, onCancel, true);
    }

    public static StepSliderWidget cancelMinSpacing(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, int minSegmentSpacing, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange, IntConsumer onCancel) {
        return StepSliderWidget.internalBuild(theme, x, y, z, min, max, initialValue, minSegmentSpacing, font, tooltipFormat, onChange, onCancel, true);
    }

    private static StepSliderWidget internalBuild(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, int minSegmentSpacing, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange, IntConsumer onCancel, boolean canCancel) {
        if (min >= max) {
            throw new IllegalArgumentException("Slider minimum value " + min + " must be less than maximum value " + max);
        }
        int segments = max - min;
        int step = Math.max(switch (segments) {
            case 1 -> 50;
            case 2 -> 30;
            case 3 -> 25;
            case 4 -> 22;
            case 5 -> 20;
            case 6 -> 18;
            case 7 -> 16;
            default -> segments > 48 ? 2 : Math.round(116.0f / (float)segments);
        }, minSegmentSpacing);
        int innerWidth = step * segments;
        int borderWidth = (theme.border + theme.horizontalPadding) * 2;
        int rightPadding = 3 + (canCancel ? 13 + 2 * theme.cancelButtonPadding : 0);
        int width = innerWidth + borderWidth + rightPadding;
        return new StepSliderWidget(theme, x, y, z, min, max, initialValue, font, tooltipFormat, onChange, onCancel, width, theme.height, canCancel, segments, step, innerWidth);
    }

    private StepSliderWidget(SliderWidgetTheme theme, int x, int y, int z, int min, int max, int initialValue, class_327 font, Int2ObjectFunction<List<class_2561>> tooltipFormat, IntConsumer onChange, IntConsumer onCancel, int width, int height, boolean canCancel, int segments, int step, int innerWidth) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.theme = theme;
        this.z = z;
        this.min = min;
        this.max = max;
        this.value = initialValue;
        this.initialValue = initialValue;
        this.font = font;
        this.tooltipFormat = tooltipFormat;
        this.onChange = onChange;
        this.onCancel = onCancel;
        this.canCancel = canCancel;
        this.range = segments;
        this.notchStep = step;
        this.innerWidth = innerWidth;
        this.minX = theme.border + theme.horizontalPadding;
        this.maxX = theme.border + theme.horizontalPadding + this.innerWidth + 3;
        this.centerY = Math.floorDiv(this.field_22759, 2);
        this.halfBarHeight = Math.floorDiv(theme.barHeight, 2);
    }

    protected void method_48579(class_332 gui, int mouseXi, int mouseYi, float partialTick) {
        SliderWidgetTheme theme = this.theme;
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, (float)this.z);
        class_2960 bgSprite = theme.spritesBackground.method_52729(this.method_37303(), this.method_25370() && !this.focusDragging);
        gui.method_52706(class_1921::method_62277, bgSprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        this.drawGuides(gui);
        if (this.value >= this.min && this.value <= this.max) {
            int sbx = this.method_46426() + this.minX - 1 + Math.round((this.value - this.min) * this.notchStep);
            int sby = this.method_46427() + this.centerY - this.halfBarHeight;
            int sbwidth = 5;
            int sbheight = theme.barHeight;
            class_2960 barSprite = theme.spritesBar.method_52729(this.method_37303(), this.dragging || mouseXi >= sbx && mouseXi < sbx + 5 && mouseYi >= sby && mouseYi < sby + sbheight);
            gui.method_52706(class_1921::method_62277, barSprite, sbx, sby, 5, sbheight);
        }
        int x = mouseXi - this.method_46426();
        int y = mouseYi - this.method_46427();
        if (!this.field_22763) {
            List tooltip;
            if (x >= 0 && x < this.field_22758 && y >= 0 && y < this.field_22759 && !(tooltip = (List)this.tooltipFormat.apply(this.value)).isEmpty()) {
                gui.method_51434(this.font, tooltip, mouseXi, mouseYi);
            }
        } else if (x >= this.minX - Math.max(theme.horizontalPadding, 1) && x < this.maxX + Math.max(theme.horizontalPadding, 1) && y >= theme.border && y < this.field_22759 - theme.border) {
            class_310 mc = class_310.method_1551();
            class_1041 window = mc.method_22683();
            double mouseX = mc.field_1729.method_1603() * ((double)window.method_4486() / (double)window.method_4480());
            int newVal = class_3532.method_15340((int)((int)Math.round((double)this.min + (mouseX - (double)this.method_46426() - (double)this.minX - 1.5) / (double)this.innerWidth * (double)this.range)), (int)this.min, (int)this.max);
            List tooltip = (List)this.tooltipFormat.apply(newVal);
            if (!tooltip.isEmpty()) {
                gui.method_51434(this.font, tooltip, mouseXi, mouseYi);
            }
        } else if (this.focusDragging && this.dragging) {
            int sbx = this.method_46426() + this.minX - 1 + Math.round((this.value - this.min) * this.notchStep);
            int sby = this.method_46427() + this.centerY - this.halfBarHeight;
            List tooltip = (List)this.tooltipFormat.apply(this.value);
            if (!tooltip.isEmpty()) {
                gui.method_51434(this.font, tooltip, sbx, sby);
            }
        }
        if (this.canCancel) {
            int cancelX = this.field_22758 - theme.border - 12 - theme.cancelButtonPadding;
            boolean hoveringCancel = this.field_22763 && !this.dragging && x >= cancelX && x < cancelX + 12 && y >= theme.border && y < theme.border + 12;
            class_2960 cancelSprite = theme.spritesCancelButton.method_52729(this.method_37303(), hoveringCancel);
            gui.method_52706(class_1921::method_62277, cancelSprite, this.method_46426() + cancelX, this.method_46427() + theme.border + theme.cancelButtonPadding, 12, 12);
            if (hoveringCancel) {
                gui.method_51434(this.font, List.of(class_2561.method_43471((String)"container.builders_inventory.util.tooltip.button.cancel").method_27692(class_124.field_1068), class_2561.method_43471((String)"container.builders_inventory.util.tooltip.button.cancel.desc").method_27692(class_124.field_1080)), mouseXi, mouseYi);
            }
        }
        gui.method_51448().method_22909();
    }

    private void drawGuides(class_332 gui) {
        int minX = this.method_46426() + this.minX;
        int maxX = this.method_46426() + this.maxX;
        int centerY = this.method_46427() + this.centerY;
        int guideColor = this.field_22763 ? (this.method_25370() && !this.focusDragging ? this.theme.guideColorBGHighlighted : this.theme.guideColor) : this.theme.guideColorDisabled;
        gui.method_25294(minX, centerY, maxX, centerY + 1, guideColor);
        gui.method_25294(minX + 1, centerY - 3, minX + 2, centerY + 4, guideColor);
        gui.method_25294(maxX - 2, centerY - 3, maxX - 1, centerY + 4, guideColor);
        int innerNotchCount = this.range - 1;
        for (int i = 1; i <= innerNotchCount; ++i) {
            int snx = minX + 1 + Math.round(i * this.notchStep);
            gui.method_25294(snx, centerY - 2, snx + 1, centerY + 3, guideColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_37303()) {
            return false;
        }
        if (!this.method_25351(button)) {
            return false;
        }
        SliderWidgetTheme theme = this.theme;
        double x = mouseX - (double)this.method_46426();
        double y = mouseY - (double)this.method_46427();
        if (x >= (double)(this.minX - Math.max(theme.horizontalPadding, 1)) && x < (double)(this.maxX + Math.max(theme.horizontalPadding, 1)) && y >= (double)theme.border && y < (double)(this.field_22759 - theme.border)) {
            int newVal = class_3532.method_15340((int)((int)Math.round((double)this.min + (mouseX - (double)this.method_46426() - (double)this.minX - 1.5) / (double)this.innerWidth * (double)this.range)), (int)this.min, (int)this.max);
            if (this.value != newVal) {
                this.value = newVal;
                this.onChange.accept(newVal);
            }
            class_310 mc = class_310.method_1551();
            this.method_25354(mc.method_1483());
            this.dragging = true;
            return true;
        }
        this.dragging = false;
        if (this.canCancel) {
            int cancelX = this.field_22758 - theme.border - 12 - theme.cancelButtonPadding;
            if (!this.dragging && x >= (double)cancelX && x <= (double)(cancelX + 12) && y >= 4.0 && y < 16.0) {
                class_310 mc = class_310.method_1551();
                this.method_25354(mc.method_1483());
                this.onCancel.accept(this.initialValue);
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.method_37303()) {
            return false;
        }
        if (!this.method_25351(button)) {
            return false;
        }
        if (!this.dragging) {
            return false;
        }
        int newVal = class_3532.method_15340((int)((int)Math.round((double)this.min + (mouseX - (double)this.method_46426() - (double)this.minX - 1.5) / (double)this.innerWidth * (double)this.range)), (int)this.min, (int)this.max);
        if (this.value != newVal) {
            this.value = newVal;
            this.onChange.accept(newVal);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.method_37303()) {
            return false;
        }
        if (!this.method_25351(button)) {
            return false;
        }
        this.dragging = false;
        return true;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.dragging = false;
            this.focusDragging = false;
        } else {
            class_310 mc = class_310.method_1551();
            class_8015 lastInput = mc.method_48186();
            if (lastInput == class_8015.field_41778 || lastInput == class_8015.field_41780) {
                this.dragging = true;
                this.focusDragging = true;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.dragging = this.focusDragging = !this.focusDragging;
            return true;
        }
        if (this.focusDragging) {
            boolean right;
            boolean left = keyCode == 263;
            boolean bl = right = keyCode == 262;
            if (left || right) {
                this.dragging = true;
                int diff = left ? -1 : 1;
                int newVal = class_3532.method_15340((int)(this.value + diff), (int)this.min, (int)this.max);
                if (newVal != this.value) {
                    this.value = newVal;
                    this.onChange.accept(newVal);
                }
                return true;
            }
        }
        return false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_25358(int width) {
        throw new UnsupportedOperationException("Changing slider size through code is not supported");
    }

    public void method_53533(int height) {
        throw new UnsupportedOperationException("Changing slider size through code is not supported");
    }
}

