/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.datafixer.extended_inventory;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.datafixer.ModDataFixer;
import com.mojang.datafixers.DataFixer;
import java.util.Optional;
import net.minecraft.class_1208;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_310;

public class ExtendedInventoryPageFixer {
    private static final int VERSION_1_20_4 = 3700;

    public static Optional<class_2487> update(class_2487 tag, int version) {
        class_310 mc = class_310.method_1551();
        DataFixer dataFixer = mc.method_1543();
        switch (version) {
            default: {
                return ExtendedInventoryPageFixer.tryUpdateItems(tag, dataFixer);
            }
            case 1: 
        }
        tag = ExtendedInventoryPageFixer.update1to2(tag, dataFixer);
        return Optional.ofNullable(tag);
    }

    private static Optional<class_2487> tryUpdateItems(class_2487 old, DataFixer dataFixer) {
        int oldVersion = class_2512.method_48309((class_2487)old, (int)3700);
        if (oldVersion < ModDataFixer.currentVersion()) {
            BuildersInventory.LOGGER.info("Updating outdated items for extended inventory");
            Optional oldItemsOpt = old.method_10554("items");
            if (oldItemsOpt.isEmpty()) {
                BuildersInventory.LOGGER.error("Could not update inventory page data {}: No valid items tag", (Object)old);
                return Optional.empty();
            }
            class_2487 tag = old.method_10553();
            class_2499 oldItems = (class_2499)oldItemsOpt.get();
            if (oldItems == null || oldItems.isEmpty()) {
                BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid items tag", (Object)oldItems);
                return Optional.empty();
            }
            class_2499 items = new class_2499();
            for (int i = 0; i < oldItems.size(); ++i) {
                class_2520 class_25202 = oldItems.method_10534(i);
                if (!(class_25202 instanceof class_2487)) {
                    BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid item tag", (Object)oldItems.method_10534(i));
                    return Optional.empty();
                }
                class_2487 itemTag = (class_2487)class_25202;
                class_2487 item = ModDataFixer.updateToCurrentVersion(dataFixer, itemTag, oldVersion, class_1208.field_5712);
                items.add((Object)item);
            }
            tag.method_10566("items", (class_2520)items);
            old.method_10562("icon").ifPresent(oldIcon -> tag.method_10566("icon", (class_2520)ModDataFixer.updateToCurrentVersion(dataFixer, oldIcon, oldVersion, class_1208.field_5712)));
            old.method_10562("original_icon").ifPresent(oldOriginalIcon -> tag.method_10566("original_icon", (class_2520)ModDataFixer.updateToCurrentVersion(dataFixer, oldOriginalIcon, oldVersion, class_1208.field_5712)));
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    private static class_2487 update1to2(class_2487 old, DataFixer dataFixer) {
        if (old == null) {
            return null;
        }
        Optional oldItemsOpt = old.method_10554("items");
        if (oldItemsOpt.isEmpty()) {
            BuildersInventory.LOGGER.error("Could not update inventory page data {}: No valid items tag", (Object)old);
            return null;
        }
        class_2487 tag = old.method_10553();
        class_2499 oldItems = (class_2499)oldItemsOpt.get();
        if (oldItems == null || oldItems.isEmpty()) {
            BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid items tag", (Object)oldItems);
            return null;
        }
        class_2499 items = new class_2499();
        for (int i = 0; i < oldItems.size(); ++i) {
            class_2520 class_25202 = oldItems.method_10534(i);
            if (!(class_25202 instanceof class_2487)) {
                BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid item tag", (Object)oldItems.method_10534(i));
                return null;
            }
            class_2487 itemTag = (class_2487)class_25202;
            class_2487 item = ModDataFixer.updateToCurrentVersion(dataFixer, itemTag, 3700, class_1208.field_5712);
            item.method_10558("id").ifPresent(itemId -> {
                if (itemId.equals("minecraft:air")) {
                    items.add((Object)new class_2487());
                } else {
                    items.add((Object)item);
                }
            });
        }
        tag.method_10566("items", (class_2520)items);
        tag.method_10569("version", 2);
        return tag;
    }
}

