package _3650.builders_inventory.api.minimessage.format;

import java.awt.Color;
import java.util.Optional;
import java.util.PrimitiveIterator;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import _3650.builders_inventory.api.minimessage.color.UnsetColorStyle;

public class RainbowFormat extends Format {
	
	public final boolean invert;
	public final double phase;
	
	private float increment;
	private float hue;
	
	public RainbowFormat(String argString, String tag, boolean invert, int phase) {
		super(argString, tag);
		this.invert = invert;
		this.phase = phase / 10.0;
	}
	
	@Override
	public class_5250 format(class_5250 component) {
		int length = component.getString().length();
		increment = (invert ? -1f : 1f) / length;
		hue = invert ? increment + (float)(phase) : (float)phase;
		if (hue < 0) hue += 1f;
		return component.method_10866().method_10973() == null ? formatNode(component) : component;
	}
	
	private class_5250 formatNode(class_2561 component) {
		var contents = component.method_44746();
		var result = class_2561.method_43473();
		
		for (var content : contents) {
			if (content.method_10866().method_10973() == null) {
				var style = new UnsetColorStyle(content.method_10866());
				final StringBuilder text = new StringBuilder();
				content.method_10851().method_27659((str) -> {
					text.append(str);
					return Optional.empty();
				});
				// some of this adapted from adventure's minimessage code
				final int[] holder = new int[1];
				for (final PrimitiveIterator.OfInt it = text.codePoints().iterator(); it.hasNext();) {
					holder[0] = it.nextInt();
					result.method_10852(class_2561.method_43470(new String(holder, 0, 1))
							.method_27696(style.withColor(Color.HSBtoRGB(hue, 1f, 1f))));
					hue = (hue + increment) % 1f;
					if (hue < 0) hue += 1f;
				}
				// this part's pretty original though
				if (!content.method_10855().isEmpty()) {
					var siblings = class_2561.method_43473().method_27696(content.method_10866());
					for (var sibling : content.method_10855()) {
						siblings.method_10852(formatNode(sibling));
					}
					result.method_10852(siblings);
				}
			} else {
				result.method_10852(content);
				hue = (hue + (increment * content.getString().length())) % 1f;
				if (hue < 0) hue += 1f;
			}
		}
		
		return result;
	}
	
}
