package _3650.builders_inventory.feature.extended_inventory;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class ExtendedInventoryContainer implements class_1263 {
	
	private ExtendedInventoryPage page = ExtendedInventoryPage.INVALID;
	private int pageId = -1;
	private boolean valid = false;
	private boolean locked = true;
	
	public void reset() {
		this.page = ExtendedInventoryPage.INVALID;
		this.pageId = -1;
		this.valid = false;
		this.locked = true;
	}
	
	public ExtendedInventoryContainer() {}
	
	public void setPage(int page) {
		this.page = ExtendedInventoryPages.get(page);
		this.pageId = page;
		this.refresh();
		ExtendedInventoryPages.setChanged();
	}
	
	public void refresh() {
		this.valid = this.page.valid;
		this.locked = this.page.isLocked();
	}
	
	public int getPage() {
		return this.pageId;
	}
	
	public String getName() {
		return this.page.getName();
	}
	
	public void setName(String name) {
		this.page.setName(name);
	}
	
	public boolean isValid() {
		return valid;
	}
	
	public boolean isLocked() {
		return locked;
	}
	
	public boolean canModify() {
		return valid && !locked;
	}
	
	public void setLocked(boolean locked) {
		this.page.setLocked(locked);
	}
	
	@Override
	public int method_5439() {
		return 54;
	}
	
	@Override
	public boolean method_5442() {
		return page.isEmpty();
	}
	
	@Override
	public class_1799 method_5438(int slot) {
		if (!valid) return class_1799.field_8037;
		return slot >= 0 && slot < 54 ? page.get(slot) : class_1799.field_8037;
	}
	
	@Override
	public class_1799 method_5434(int slot, int amount) {
		if (!valid) return class_1799.field_8037;
		class_1799 stack = slot >= 0 && slot < 54 && !(page.get(slot)).method_7960() && amount > 0 ? (page.get(slot)).method_7971(amount) : class_1799.field_8037;
		if (!stack.method_7960()) this.method_5431();
		return stack;
	}
	
	@Override
	public class_1799 method_5441(int slot) {
		if (!valid) return class_1799.field_8037;
		class_1799 stack = page.get(slot);
		if (stack.method_7960()) return class_1799.field_8037;
		else {
			this.method_5447(slot, class_1799.field_8037); // screw the "no update" this is very important to update
			return stack;
		}
	}
	
	@Override
	public void method_5447(int slot, class_1799 stack) {
		if (!valid) return;
		page.set(slot, stack);
		this.method_5431();
	}
	
	public class_1799 swapItem(int slot, class_1799 stack) {
		if (!valid) return class_1799.field_8037;
		class_1799 old = page.set(slot, stack);
		this.method_5431();
		return old;
	}
	
	@Override
	public void method_5431() {
		if (valid) page.setChanged();
	}
	
	@Override
	public boolean method_5443(class_1657 player) {
		return true;
	}
	
	@Override
	public void method_5448() {
		if (!valid) return;
		page.clear();
		this.method_5431();
	}
	
}
