package _3650.builders_inventory.feature.extended_inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_6379;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.ModKeybinds;
import _3650.builders_inventory.api.util.GuiUtil;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButton;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButtonGui;
import _3650.builders_inventory.config.Config;

public class ExtendedInventoryOrganizeScreen extends class_437 {
	
	private static final class_2960 BACKGROUND = BuildersInventory.modLoc("textures/gui/container/extended_inventory/organize.png");
	
	private static final class_2960 SPRITE_CREATIVE_SCROLLER = class_2960.method_60656("container/creative_inventory/scroller");
	private static final class_2960 SPRITE_CREATIVE_SCROLLER_DISABLED = class_2960.method_60656("container/creative_inventory/scroller_disabled");
	
	private static final class_8666 SPRITES_BUTTON_BACK = new class_8666(
			BuildersInventory.modLoc("extended_inventory/organize/button_back"),
			BuildersInventory.modLoc("extended_inventory/organize/button_back_highlighted"));
	
	private static final class_2960 SPRITE_TILE = BuildersInventory.modLoc("extended_inventory/organize/tile");
	private static final class_2960 SPRITE_TILE_SELECTED = BuildersInventory.modLoc("extended_inventory/organize/tile_highlighted");
	private static final class_2960 SPRITE_TILE_SHADOW = BuildersInventory.modLoc("extended_inventory/organize/tile_shadow");
	private static final class_8666 SPRITES_TILE = new class_8666(
			SPRITE_TILE,
			SPRITE_TILE_SELECTED);
	private static final class_2960 SPRITE_TILE_ACTIVE = BuildersInventory.modLoc("extended_inventory/organize/tile_active");
	private static final class_2960 SPRITE_TILE_ACTIVE_SELECTED = BuildersInventory.modLoc("extended_inventory/organize/tile_active_highlighted");
	private static final class_8666 SPRITES_TILE_ACTIVE = new class_8666(
			SPRITE_TILE_ACTIVE,
			SPRITE_TILE_ACTIVE_SELECTED);
	private static final class_2960 SPRITE_TILE_CREATE = BuildersInventory.modLoc("extended_inventory/organize/tile_create");
	private static final class_2960 SPRITE_TILE_CREATE_SELECTED = BuildersInventory.modLoc("extended_inventory/organize/tile_create_highlighted");
	@SuppressWarnings("unused")
	private static final class_8666 SPRITES_TILE_CREATE = new class_8666(
			SPRITE_TILE_CREATE,
			SPRITE_TILE_CREATE_SELECTED);
	@SuppressWarnings("unused")
	private static final class_2960 SPRITE_TILE_CREATE_DIM = BuildersInventory.modLoc("extended_inventory/organize/tile_create_dim");
	
	private static final class_2960 SPRITE_BACKGROUND = BuildersInventory.modLoc("extended_inventory/organize/hover_background");
	private static final class_2960 SPRITE_BACKGROUND_LOCKED = BuildersInventory.modLoc("extended_inventory/organize/hover_background_locked");
	private static final class_2960 SPRITE_BACKGROUND_INVALID = BuildersInventory.modLoc("extended_inventory/organize/hover_background_invalid");
	
	private static final int TILE_MIN_X = 8;
	private static final int TILE_MIN_Y = 17;
	
	private final ExtendedImageButtonGui exGui = new ExtendedImageButtonGui();
	private final int imageWidth;
	private final int imageHeight;
	
	private int leftPos;
	private int topPos;
	
	private final ArrayList<PageTile> tiles = new ArrayList<>(ExtendedInventoryPages.size());
	
	private boolean doubleClick = false;
	private long lastClickTime = 0L; // me when my last click was at January 1st 1970
	private int lastClickButton = -1;
	private int lastClickIndex = -1;
	
	private int dragTileIndex = -1;
	private PageTile dragTile = null;
	private int dragOffsetX = 0;
	private int dragOffsetY = 0;
	private double dragDeltaX = 0;
	private double dragDeltaY = 0;
	private boolean dragPickup = false;
	private int dragHoveredIndex = -1;
	
	private PageTile hoveredTile = null;
	
	private int scrollRow = 0;
	private double scrollAmount = 0.0;
	private boolean scrolling = false;
	
	public ExtendedInventoryOrganizeScreen() {
		super(class_2561.method_43471("container.builders_inventory.extended_inventory.organize"));
		this.imageWidth = 213;
		this.imageHeight = 204;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		this.exGui.init();
		this.leftPos = (this.field_22789 - this.imageWidth) / 2;
		this.topPos = (this.field_22790 - this.imageHeight) / 2;
		
		this.method_37063(new ExtendedImageButton(this.leftPos + 193, this.topPos + 4, 12, 12,
				SPRITES_BUTTON_BACK,
				button -> {
					ExtendedInventory.open(this.field_22787);
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.organize.tooltip.button.back").method_27692(class_124.field_1068)));
		
		int scrollRow = this.scrollRow;
		int scrollRowMax = scrollRow + 10;
		for (int i = 0; i < ExtendedInventoryPages.size(); i++) {
			int column = i % 10;
			int row = i / 10;
			var tile = new PageTile(this.leftPos + tileX(column), this.topPos + tileY(row - scrollRow), this, ExtendedInventoryPages.get(i), i);
			tile.visible = row >= scrollRow && row < scrollRowMax;
			tiles.add(tile);
		}
	}
	
	private static int tileX(int column) {
		return TILE_MIN_X + (column * 18);
	}
	
	private static int tileY(int row) {
		return TILE_MIN_Y + (row * 18);
	}
	
	private void scrolledToPos(double mouseX, double mouseY) {
		double scroll = (mouseY - this.topPos - 17 - 7.5) / (180 - 15);
		this.scrolledTo(class_3532.method_15350(scroll, 0.0, 1.0), mouseX, mouseY);
	}
	
	private void scrolledTo(double scroll, double mouseX, double mouseY) {
		this.scrollAmount = scroll;
		int row = (int)((scroll * getScrollRows()) + 0.5);
		if (row != this.scrollRow) this.setScrollRow(row, mouseX, mouseY);
	}
	
	private void setScrollRow(int scrollRow, double mouseX, double mouseY) {
		int oldRow = this.scrollRow;
		this.scrollRow = scrollRow;
		for (int i = 0; i < this.tiles.size(); i++) {
			final var tile = this.tiles.get(i);
			final int sy = tile.y - ((scrollRow - oldRow) * 18);
			final boolean continueSlowMove = tile.visible;
			final var relY = sy - TILE_MIN_Y - this.topPos;
			tile.visible = relY >= 0 && relY < 180 && tile != this.dragTile;
			if (continueSlowMove && tile.visible && tile.slowMoveTime > 0L) {
				tile.slowMove(tile.x, sy);
			} else {
				tile.slowMoveTime = 0L;
				tile.y = sy;
			}
		}
		if (this.dragTile != null) {
			var hovered = this.findNearestTile((int)mouseX, (int)mouseY);
			if (hovered.index != this.dragHoveredIndex) {
				this.shiftTiles(this.dragHoveredIndex, hovered.index);
				this.dragHoveredIndex = hovered.index;
			}
		}
	}
	
	private int getScrollRows() {
		return class_3532.method_38788(this.tiles.size(), 10) - 10;
	}
	
	// WARNING: NO guarantee that start < end
	/** ONLY CALL AFTER TRANSFORMING INDEX WITH SCROLL */
	private void shiftTiles(int start, int end) {
		if (start == end) return;
		
		// true  = move left  (drag moved right)
		// false = move right (drag moved left)
		boolean dir = start < end;
		
		int low = dir ? start : end;
		int high = dir ? end : start;
		
		for (int i = low; i <= high; i++) {
			if (i == this.dragTileIndex) continue;
			int newInd = dir ? i - 1 : i + 1;
			if (dir && i < this.dragTileIndex || !dir && i > this.dragTileIndex) newInd = i;
			if (newInd == end) continue;
			var tile = this.tiles.get(i); // index already transformed by scroll
			int row = newInd / 10;
			int relRow = row - this.scrollRow;
			if (relRow < 0 || relRow >= 10) tile.visible = false;
			tile.slowMove(this.leftPos + tileX(newInd % 10), this.topPos + tileY(relRow));
		}
	}
	
	/** please ensure start != end and that the index is already transformed */
	private void reorderTiles(int start, int end) {
		boolean dir = start < end;
		int from = (dir ? start : end);
		int to = (dir ? end : start) + 1;
		int dist = dir ? -1 : 1;
		for (int i = from; i < to; i++) {
			var tile = this.tiles.get(i);
			tile.index = i == start ? end : (i + dist);
			tile.page.setChanged();
		}
		Collections.rotate(this.tiles.subList(from, to), dist);
		ExtendedInventoryPages.rotatePages(from, to, dist);
		int curPage = ExtendedInventory.getPage();
		ExtendedInventory.setPage(curPage == start ? end : curPage + dist);
	}
	
	@Nullable
	private TileFindResult findTile(int x, int y) {
		x -= 8 + this.leftPos;
		y -= 17 + this.topPos;
		if (x >= 0 && x < 180 && y >= 0 && y < 180) {
			int col = x / 18;
			int rx = x % 18;
			int row = y / 18;
			int ry = y % 18;
			int index = col + (row * 10);
			index += (this.scrollRow * 10);
			if (index < this.tiles.size()) return new TileFindResult(index, this.tiles.get(index), rx - 1, ry - 1, col, row);
		}
		return null;
	}
	
	@NotNull
	private TileFindResult findNearestTile(int x, int y) {
		x -= 8 + this.leftPos;
		y -= 17 + this.topPos;
		if (x < 0) x = 0;
		else if (x >= 180) x = 179;
		if (y < 0) y = 0;
		else if (y >= 180) y = 179;
		
		int col = x / 18;
		int rx = x % 18;
		int row = y / 18;
		int ry = y % 18;
		
		int index = col + (row * 10);
		index += (this.scrollRow * 10);
		if (index >= tiles.size()) index = tiles.size() - 1;
		return new TileFindResult(index, tiles.get(index), rx - 1, ry - 1, col, row);
	}
	
	@Override
	protected <T extends class_364 & class_4068 & class_6379> T method_37063(T widget) {
		this.exGui.addRenderableWidget(widget);
		return super.method_37063(widget);
	}
	
	@Override
	protected void method_37067() {
		this.exGui.clearWidgets();
		this.tiles.clear();
		super.method_37067();
	}
	
	@Override
	public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTick) {
		super.method_25394(gui, mouseX, mouseY, partialTick);
		gui.method_51439(this.field_22793, this.field_22785, this.leftPos + 8, this.topPos + 6, 0xFF404040, false);
		
		if (this.dragTile != null) {
			int col = this.dragHoveredIndex % 10;
			int row = (this.dragHoveredIndex / 10) - this.scrollRow;
			gui.method_52706(class_10799.field_56883, SPRITE_TILE_SHADOW, this.leftPos + tileX(col) + 1, this.topPos + tileY(row) + 1, 16, 16);
			this.renderTiles(gui, mouseX, mouseY, partialTick);
//			gui.fill(this.leftPos + tileX(col) + 1, this.topPos + tileY(row) + 1, this.leftPos + tileX(col) + 1 + 16, this.topPos + tileY(row) + 1 + 16, 0xBB77BB77); //DEBUG THING
			gui.method_52706(class_10799.field_56883, this.dragTileIndex == ExtendedInventory.getPage() ? SPRITE_TILE_ACTIVE_SELECTED : SPRITE_TILE_SELECTED, mouseX - this.dragOffsetX, mouseY - this.dragOffsetY, 16, 16);
			if (this.dragTile.page.icon.method_7960()) {
				this.renderTileText(gui, this.dragTileIndex + 1, mouseX - this.dragOffsetX + 8, mouseY - this.dragOffsetY + 4); //Z_4
			} else {
				this.renderTileIcon(gui, this.dragTile.page.icon, this.dragTile.page.iconScaleDown, mouseX - this.dragOffsetX, mouseY - this.dragOffsetY); //Z_4
			}
			if (!this.dragPickup) this.renderTileTooltip(this.dragTile, this.dragTileIndex, gui, mouseX, mouseY); //Z_4
		} else {
			this.renderTiles(gui, mouseX, mouseY, partialTick);
			final var hover = findTile(mouseX, mouseY);
			this.hoveredTile = hover == null ? null : hover.tile;
			this.renderTooltip(gui, hover, mouseX, mouseY); //Z_4
		}
	}
	
	private void renderTiles(class_332 gui, int mouseX, int mouseY, float partialTick) {
		for (var tile : this.tiles) {
			tile.render(gui, mouseX, mouseY, partialTick);
		}
	}
	
	protected void renderTooltip(class_332 gui, TileFindResult hover, int mouseX, int mouseY) {
		if (hover != null && hover.tile.isActive()) {
			renderTileTooltip(hover.tile, hover.index, gui, mouseX, mouseY);
			return;
		}
		this.exGui.renderTooltip(this.field_22793, gui, mouseX, mouseY);
	}
	
	void renderTileText(class_332 gui, int number, int x, int y) {
		String text = String.valueOf(number);
		gui.method_51448().pushMatrix();
		gui.method_51448().translate(x, y);
		if (text.length() > 2) {
			float scale = 2f / text.length();
			gui.method_51448().translate(0, 4 * (1f - scale)); // (8*scale - 8) / 2
			gui.method_51448().scale(scale, scale);
		}
		gui.method_25300(this.field_22793, text, 0, 0, 0xFFFFFFFF);
		gui.method_51448().popMatrix();
	}
	
	void renderTileIcon(class_332 gui, class_1799 icon, int iconScaleDown, int x, int y) {
		gui.method_51448().pushMatrix();
		gui.method_51448().translate(x, y);
		if (iconScaleDown > 0) {
			final int guiScale = (int) (this.field_22787.method_22683().method_4495() + 0.5);
			final float iconScale = iconScaleDown >= guiScale ? (1f / guiScale) : (1f - (iconScaleDown / (float)guiScale));
			gui.method_51448().translate((8 * (1f - iconScale)), (8 * (1f - iconScale)));
			gui.method_51448().scale(iconScale, iconScale);
		}
		gui.method_51427(icon, 0, 0);
		gui.method_51431(this.field_22793, icon, 0, 0);
		gui.method_51448().popMatrix();
	}
	
	private void renderTileTooltip(PageTile tile, int index, class_332 gui, int mouseX, int mouseY) {
		gui.method_64038(this.field_22793,
				List.of(ExtendedInventory.pageTitle(index)),
				Optional.of(new PageTooltipImage(tile.page)),
				mouseX,
				mouseY);
	}
	
	private boolean isMouseInScrollbar(int mouseX, int mouseY) {
		return mouseX >= 192 && mouseX < 192 + 14 && mouseY >= 17 && mouseY < 17 + 180;
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (super.method_25402(mouseX, mouseY, button)) {
			return true;
		} else if (this.canScroll() && this.isMouseInScrollbar((int)mouseX - this.leftPos, (int)mouseY - this.topPos)) {
			this.scrolling = true;
			this.scrolledToPos(mouseX, mouseY);
			return true;
		} else {
			boolean consume = false;
			
			long time = class_156.method_658();
			
			var tile = findTile((int)mouseX, (int)mouseY);
			if (tile != null) {
				this.startDrag(tile.tile, tile.index, tile.rx, tile.ry);
				consume = true;
			}
			
			this.doubleClick = tile != null && tile.index == this.lastClickIndex && time - this.lastClickTime < 300L && this.lastClickButton == button;
			this.lastClickTime = time;
			this.lastClickButton = button;
			this.lastClickIndex = tile == null ? -1 : tile.index;
			return consume;
		}
	}
	
	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
		if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
			return true;
		} else if (this.scrolling) {
			this.scrolledToPos(mouseX, mouseY);
			return true;
		} else {
			if (this.dragTile != null) {
				this.dragDeltaX += dragX;
				this.dragDeltaY += dragY;
				if (!this.dragPickup) {
					if (Math.abs(this.dragDeltaX) < 1.5f && Math.abs(this.dragDeltaY) < 1.5f) return true;
					else this.dragPickup = true;
				}
				var hovered = this.findNearestTile((int)mouseX, (int)mouseY);
				if (hovered.index != this.dragHoveredIndex) {
					this.shiftTiles(this.dragHoveredIndex, hovered.index);
					this.dragHoveredIndex = hovered.index;
				}
				return true;
			}
			
			return false;
		}
	}
	
	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		this.scrolling = false;
		if (super.method_25406(mouseX, mouseY, button)) {
			return true;
		} else {
			boolean consume = false;
			
			if (this.dragTile != null) {
				int col = this.dragHoveredIndex % 10;
				int row = (this.dragHoveredIndex / 10) - this.scrollRow;
				this.endDrag((int)mouseX, (int)mouseY, this.leftPos + tileX(col), this.topPos + tileY(row));
				if (this.dragTileIndex != this.dragHoveredIndex) {
					this.reorderTiles(this.dragTileIndex, this.dragHoveredIndex);
				}
				consume = true;
			}
			
			if (this.doubleClick) {
				this.doubleClick = false;
				if (this.lastClickIndex > -1 && class_156.method_658() - this.lastClickTime < 300L) {
					this.field_22787.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
					ExtendedInventory.setPage(this.lastClickIndex);
					ExtendedInventory.open(this.field_22787);
					consume = true;
				}
			}
			
			return consume;
		}
	}
	
	private void startDrag(PageTile tile, int index, int rx, int ry) {
		tile.visible = false;
		this.dragTile = tile;
		this.dragTileIndex = index;
		this.dragOffsetX = rx;
		this.dragOffsetY = ry;
		this.dragDeltaX = 0;
		this.dragDeltaY = 0;
		this.dragPickup = false;
		this.dragHoveredIndex = index;
	}
	
	private void endDrag(int mouseX, int mouseY, int targetX, int targetY) {
		this.dragTile.visible = true;
		this.dragTile.slowMoveFrom(mouseX - this.dragOffsetX, mouseY - this.dragOffsetY, targetX, targetY);
		this.dragTile.slowMoveShadow = true;
		this.dragTile = null;
	}
	
	@Override
	public void method_25420(class_332 gui, int mouseX, int mouseY, float partialTick) {
		this.method_52752(gui);
		GuiUtil.blitScreenBackground(gui, BACKGROUND, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
		
		class_2960 scrollSprite = this.canScroll() ? SPRITE_CREATIVE_SCROLLER : SPRITE_CREATIVE_SCROLLER_DISABLED;
		gui.method_52706(class_10799.field_56883, scrollSprite, this.leftPos + 193, this.topPos + 18 + (int)((178 - 15) * this.scrollAmount), 12, 15);
	}
	
	@Override
	public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
		if (!this.canScroll() || this.scrolling) {
			return false;
		} else {
			this.scrolledTo(class_3532.method_15350(this.scrollAmount - (scrollY / this.getScrollRows()), 0.0, 1.0), mouseX, mouseY);
			return true;
		}
	}
	
	private boolean canScroll() {
		return this.tiles.size() > 100;
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
			this.method_25419();
			return true;
		} else if (ModKeybinds.OPEN_EXTENDED_INVENTORY.method_1417(keyCode, scanCode)) {
			ExtendedInventory.open(this.field_22787);
			return true;
		} else return super.method_25404(keyCode, scanCode, modifiers);
	}
	
	@Override
	public void method_25419() {
		if (Config.instance().extended_inventory_close_to_main) {
			ExtendedInventory.open(this.field_22787);
		} else super.method_25419();
	}
	
	@Override
	public boolean method_25421() {
		return false;
	}
	
	private static class PageTile {
		
		public int x;
		public int y;
		public boolean visible = true;
		public boolean active = true;
		
		public final ExtendedInventoryOrganizeScreen screen;
		public final ExtendedInventoryPage page;
		public int index = -1;
		private long slowMoveTime = 0L;
		private int slowMoveStartX = 0;
		private int slowMoveStartY = 0;
		private float slowMoveLength = 200f;
		public boolean slowMoveShadow = false;
		
		public PageTile(int x, int y, ExtendedInventoryOrganizeScreen screen, ExtendedInventoryPage page, int index) {
			this.x = x;
			this.y = y;
			this.screen = screen;
			this.page = page;
			this.index = index;
		}
		
		public void slowMoveFrom(int originX, int originY, int targetX, int targetY) {
			this.slowMoveTime = class_156.method_658();
			this.slowMoveStartX = originX;
			this.slowMoveStartY = originY;
			int distX = originX - targetX;
			int distY = originY - targetY;
			int distSqr = distX * distX + distY * distY;
			this.slowMoveLength = Math.min((distSqr / 3f) + 50f, 200f);
			this.slowMoveShadow = false;
			this.setPosition(targetX, targetY);
		}
		
		public void slowMove(int targetX, int targetY) {
			int x = this.x + 1;
			int y = this.y + 1;
			if (this.slowMoveTime <= 0L) this.slowMoveFrom(x, y, targetX, targetY);
			float progress = (class_156.method_658() - this.slowMoveTime) / this.slowMoveLength;
			if (progress >= 1.0f) {
				this.slowMoveFrom(x, y, targetX, targetY);
			} else {
				int mx = this.slowMoveStartX + (int)((x - this.slowMoveStartX) * progress);
				int my = this.slowMoveStartY + (int)((y - this.slowMoveStartY) * progress);
				this.slowMoveFrom(mx, my, targetX, targetY);
			}
		}
		
		protected void render(class_332 gui, int mouseX, int mouseY, float partialTick) {
			if (!this.visible) return;
			int x = this.x + 1;
			int y = this.y + 1;
			boolean moving = this.slowMoveTime > 0L;
			class_8666 sprites = this.index == ExtendedInventory.getPage() ? SPRITES_TILE_ACTIVE : SPRITES_TILE;
			class_2960 sprite = sprites.method_52729(this.isActive(), this.screen.dragTile == null && this == this.screen.hoveredTile);
			if (moving) {
				float progress = (class_156.method_658() - this.slowMoveTime) / this.slowMoveLength;
				if (progress >= 1.0f) {
					progress = 1.0f;
					this.slowMoveTime = 0L;
				}
				int mx = this.slowMoveStartX + (int)((x - this.slowMoveStartX) * progress);
				int my = this.slowMoveStartY + (int)((y - this.slowMoveStartY) * progress);
				if (this.slowMoveShadow) gui.method_52706(class_10799.field_56883, SPRITE_TILE_SHADOW, x, y, 16, 16);
				this.renderTile(gui, mx, my, sprite);
			} else {
				this.renderTile(gui, x, y, sprite);
			}
		}
		
		private void renderTile(class_332 gui, int x, int y, class_2960 sprite) {
			gui.method_52706(class_10799.field_56883, sprite, x, y, 16, 16);
			if (this.page.icon.method_7960()) {
				this.screen.renderTileText(gui, this.index + 1, x + 8, y + 4);
			} else {
				this.screen.renderTileIcon(gui, this.page.icon, this.page.iconScaleDown, x, y);
			}
		}
		
		private void setPosition(int x, int y) {
			this.x = x;
			this.y = y;
		}
		
		public boolean isActive() {
			return this.visible && this.active;
		}
		
	}
	
	public static class PageTooltipImage implements class_5684, class_5632 {
		
		private final ExtendedInventoryPage page;
		
		public PageTooltipImage(ExtendedInventoryPage page) {
			this.page = page;
		}
		
		@Override
		public int method_32664(class_327 font) {
			return 174;
		}
		
		@Override
		public int method_32661(class_327 font) {
			return 120;
		}
		
		@Override
		public void method_32666(class_327 font, int x, int y, int width, int height, class_332 gui) {
			class_2960 background = this.page.valid ? this.page.isLocked() ? SPRITE_BACKGROUND_LOCKED : SPRITE_BACKGROUND : SPRITE_BACKGROUND_INVALID;
			gui.method_52706(class_10799.field_56883, background, x, y, this.method_32664(font), this.method_32661(font));
			if (!this.page.valid) return;
			int slot = 0;
			for (int row = 0; row < 6; row++) {
				int slotY = y + (row * 18) + 6 + 1;
				for (int col = 0; col < 9; col++) {
					int slotX = x + (col * 18) + 6 + 1;
					class_1799 stack = this.page.get(slot++);
					gui.method_51427(stack, slotX, slotY);
					gui.method_51431(font, stack, slotX, slotY);
				}
			}
		}
		
	}
	
	private static class TileFindResult {
		
		public final int index;
		public final PageTile tile;
		public final int rx;
		public final int ry;
		@SuppressWarnings("unused")
		public final int col;
		@SuppressWarnings("unused")
		public final int row;
		
		public TileFindResult(int index, PageTile tile, int rx, int ry, int col, int row) {
			this.index = index;
			this.tile = tile;
			this.rx = rx;
			this.ry = ry;
			this.col = col;
			this.row = row;
		}
		
	}
	
}
