/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.autocomplete;

import _3650.builders_inventory.api.minimessage.autocomplete.AutocompleteArg;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2960;

public abstract class ReloadableResourceArg
implements AutocompleteArg {
    public static final ReloadableResourceArg KEYS = ReloadableResourceArg.str();
    public static final ReloadableResourceArg LANG = ReloadableResourceArg.str();
    public static final ReloadableResourceArg FONTS = ReloadableResourceArg.loc();
    public static final ReloadableResourceArg ITEMS = ReloadableResourceArg.plain();
    public static final ReloadableResourceArg ENTITIES = ReloadableResourceArg.plain();

    private ReloadableResourceArg() {
    }

    public static ReloadableResourceArg plain() {
        return new PlainArg();
    }

    public static ReloadableResourceArg str() {
        return new StringArg();
    }

    public static ReloadableResourceArg loc() {
        return new ResourceArg();
    }

    public abstract boolean isLoaded();

    public abstract void loadStr(ArrayList<String> var1);

    public abstract void loadLoc(ArrayList<class_2960> var1);

    private static class PlainArg
    extends ReloadableResourceArg {
        private ArrayList<String> vals;
        private boolean loaded = false;

        private PlainArg() {
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public List<String> find(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.vals.size(); ++i) {
                if (!PlainArg.segmentMatches(this.vals.get(i), startLow)) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        @Override
        public List<String> findNonMatch(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.vals.size(); ++i) {
                String key = this.vals.get(i);
                if (!PlainArg.segmentMatches(key, startLow) || key.length() == start.length() && key.equals(start)) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        private static boolean segmentMatches(String key, String start) {
            int i = 0;
            while (!key.startsWith(start, i)) {
                if ((i = key.indexOf(95, i)) < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void loadStr(ArrayList<String> strs) {
            this.loaded = true;
            this.vals = strs;
        }

        @Override
        public void loadLoc(ArrayList<class_2960> locs) {
            throw new IllegalStateException("Cannot load ResourceLocation values into String arg");
        }
    }

    private static class StringArg
    extends ReloadableResourceArg {
        private ArrayList<String> keys;
        private ArrayList<String> vals;
        private boolean loaded = false;

        private StringArg() {
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public List<String> find(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!StringArg.segmentMatches(this.keys.get(i), startLow)) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        @Override
        public List<String> findNonMatch(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.keys.size(); ++i) {
                String key = this.keys.get(i);
                if (!StringArg.segmentMatches(key, startLow) || key.length() == start.length() && key.equals(start)) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        private static boolean segmentMatches(String key, String start) {
            int i = 0;
            while (!key.startsWith(start, i)) {
                int b;
                int a = key.indexOf(46, i);
                if ((i = Math.min(a, b = key.indexOf(95, i))) < 0) {
                    i = Math.max(a, b);
                }
                if (i < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void loadStr(ArrayList<String> strs) {
            this.loaded = true;
            this.keys = new ArrayList(strs.size());
            this.vals = new ArrayList(strs.size());
            for (String str : strs) {
                this.keys.add(str.toLowerCase(Locale.ROOT));
                this.vals.add(str);
            }
        }

        @Override
        public void loadLoc(ArrayList<class_2960> locs) {
            throw new IllegalStateException("Cannot load ResourceLocation values into String arg");
        }
    }

    private static class ResourceArg
    extends ReloadableResourceArg {
        private ArrayList<class_2960> keys;
        private ArrayList<String> vals;
        private boolean loaded = false;

        private ResourceArg() {
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public List<String> find(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            boolean namespaced = start.indexOf(58) > -1;
            for (int i = 0; i < this.keys.size(); ++i) {
                class_2960 loc = this.keys.get(i);
                if (namespaced) {
                    if (!ResourceArg.segmentMatches(loc.toString(), startLow)) continue;
                    result.add(this.vals.get(i));
                    continue;
                }
                if (!ResourceArg.segmentMatches(loc.method_12836(), startLow) && (!loc.method_12836().equals("minecraft") || !ResourceArg.segmentMatches(loc.method_12832(), startLow))) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        @Override
        public List<String> findNonMatch(String start) {
            if (!this.loaded) {
                return List.of();
            }
            if (start.isEmpty()) {
                return this.vals;
            }
            String startLow = start.toLowerCase(Locale.ROOT);
            ArrayList<String> result = new ArrayList<String>();
            boolean namespaced = start.indexOf(58) > -1;
            for (int i = 0; i < this.keys.size(); ++i) {
                class_2960 loc = this.keys.get(i);
                if (namespaced) {
                    String key = loc.toString();
                    if (!ResourceArg.segmentMatches(key, startLow) || key.length() == start.length() && key.equals(start)) continue;
                    result.add(this.vals.get(i));
                    continue;
                }
                if (ResourceArg.segmentMatches(loc.method_12836(), startLow)) {
                    result.add(this.vals.get(i));
                    continue;
                }
                if (!loc.method_12836().equals("minecraft") || !ResourceArg.segmentMatches(loc.method_12832(), startLow) || loc.method_12832().length() == start.length() && loc.method_12832().equals(start)) continue;
                result.add(this.vals.get(i));
            }
            return result;
        }

        private static boolean segmentMatches(String key, String start) {
            int i = 0;
            while (!key.startsWith(start, i)) {
                int b;
                int a = key.indexOf(47, i);
                if ((i = Math.min(a, b = key.indexOf(95, i))) < 0) {
                    i = Math.max(a, b);
                }
                if (i < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void loadStr(ArrayList<String> strs) {
            throw new IllegalStateException("Cannot load String values into ResourceLocation arg");
        }

        @Override
        public void loadLoc(ArrayList<class_2960> locs) {
            this.loaded = true;
            this.keys = locs;
            this.vals = new ArrayList(this.keys.size());
            for (class_2960 loc : locs) {
                this.vals.add(loc.toString());
            }
        }
    }
}

