/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.instance;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.class_2583;
import net.minecraft.class_5481;

public class HighlightedTextInput {
    public final String text;
    private final StyleData[] styles;
    private final Long2ObjectOpenHashMap<class_5481> cache = new Long2ObjectOpenHashMap();

    public HighlightedTextInput(String text, StyleData[] styles) {
        this.text = text;
        this.styles = styles;
    }

    public class_5481 subseq(int start, int end) {
        long sig = (long)start & 0xFFFFFFFFL | (long)end << 32;
        if (this.cache.containsKey(sig)) {
            return (class_5481)this.cache.get(sig);
        }
        ImmutableList.Builder seq = ImmutableList.builder();
        while (start < end && start < this.text.length()) {
            StyleData data = this.styles[start];
            int dif = Math.min(data.start + data.length, end);
            seq.add((Object)class_5481.method_30747((String)this.text.substring(start, dif), (class_2583)data.style));
            start = dif;
        }
        class_5481 result = class_5481.method_30749((List)seq.build());
        this.cache.put(sig, (Object)result);
        return result;
    }

    static class StyleData {
        public final int length;
        public final int start;
        public final class_2583 style;

        public StyleData(int length, int start, class_2583 style) {
            this.length = length;
            this.start = start;
            this.style = style;
        }
    }

    public static class Builder {
        private final StringBuilder text;
        private final StyleData[] styles;
        public int length;

        public Builder(int size) {
            this.text = new StringBuilder(size);
            this.styles = new StyleData[size];
        }

        public void append(String str, class_2583 style) {
            int len = str.length();
            int max = this.length + len;
            this.text.append(str);
            StyleData data = new StyleData(len, this.length, style);
            for (int i = this.length; i < max; ++i) {
                this.styles[i] = data;
            }
            this.length = max;
        }

        public HighlightedTextInput build() {
            return new HighlightedTextInput(this.text.toString(), this.styles);
        }
    }
}

