/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage;

import _3650.builders_inventory.api.minimessage.MiniMessageResult;
import _3650.builders_inventory.api.minimessage.format.Format;
import _3650.builders_inventory.api.minimessage.format.QuoteFormat;
import _3650.builders_inventory.api.minimessage.parser.ArgData;
import _3650.builders_inventory.api.minimessage.parser.InvalidMiniMessage;
import _3650.builders_inventory.api.minimessage.parser.MiniMessageParserRegistry;
import _3650.builders_inventory.api.minimessage.parser.MiniMessageTagOutput;
import _3650.builders_inventory.api.minimessage.tags.Branch;
import _3650.builders_inventory.api.minimessage.tags.HiddenLiteral;
import _3650.builders_inventory.api.minimessage.tags.Literal;
import _3650.builders_inventory.api.minimessage.tags.Node;
import _3650.builders_inventory.api.util.ArrayStack;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5251;
import net.minecraft.class_7225;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class MiniMessageParser {
    public final Optional<DynamicOps<class_2520>> registryOps;
    @Nullable
    private final String server;
    private MiniMessageTagOutput tagOutput;
    private final String s;
    private final int tMax;
    public final Branch root;
    public Branch ctx;
    private ArrayStack<Branch> stack;
    private ArrayList<String> args;
    private Object2IntOpenHashMap<String> nameCounter;
    @Nullable
    private final ArrayList<String> errors = new ArrayList();
    private int head = 0;
    private int tail = -1;

    public static MiniMessageResult parseNoRegistry(String str) {
        return MiniMessageParser.parse(str, Optional.empty(), null);
    }

    public static MiniMessageResult parse(String str, class_7225.class_7874 registryAccess, @Nullable String server) {
        return MiniMessageParser.parse(str, Optional.ofNullable(registryAccess), server);
    }

    public static MiniMessageResult parse(String str, Optional<class_7225.class_7874> registryAccess, @Nullable String server) {
        return MiniMessageParser.parse(str, Format.PLAIN, registryAccess, server);
    }

    static MiniMessageResult parse(String str, Format rootFormat, Optional<class_7225.class_7874> registryAccess, @Nullable String server) {
        return new MiniMessageParser(str, rootFormat, registryAccess.map(access -> access.method_57093((DynamicOps)class_2509.field_11560)), server).parseContent();
    }

    private MiniMessageResult subParse(String s, Format format) {
        return new MiniMessageParser(s, format, this.registryOps, this.server).parseContent();
    }

    private MiniMessageParser(String s, Format format, Optional<DynamicOps<class_2520>> registryOps, @Nullable String server) {
        this.s = s;
        this.tMax = s.length() - 1;
        this.ctx = this.root = new Branch(format);
        this.registryOps = registryOps;
        this.server = null;
        this.tagOutput = new MiniMessageTagOutput(){

            @Override
            public void append(Node node) {
                MiniMessageParser.this.ctx.append(node);
            }

            @Override
            public void push(Format format) {
                MiniMessageParser.this.pushCtx(format);
            }

            @Override
            public Branch pop() {
                return MiniMessageParser.this.popCtx();
            }

            @Override
            public Branch popUnclosed() {
                return MiniMessageParser.this.popUnclosed();
            }
        };
    }

    private MiniMessageResult parseContent() {
        this.stack = new ArrayStack();
        this.args = new ArrayList();
        this.nameCounter = new Object2IntOpenHashMap();
        ParseState state = ParseState.NORMAL;
        ParseState exitState = ParseState.NORMAL;
        boolean escaped = false;
        char quote = '\u0000';
        int tagHead = 0;
        int argHead = 0;
        while (this.hasNext()) {
            char c = this.next();
            if (!escaped) {
                if (c == '\\' && this.hasNext()) {
                    char next = this.s.charAt(this.tail + 1);
                    switch (state.ordinal()) {
                        case 0: {
                            escaped = next == '<' || next == '\\';
                            break;
                        }
                        case 1: {
                            escaped = next == quote || next == '\\';
                            break;
                        }
                        case 2: {
                            if (next != '<') break;
                            this.head = tagHead;
                            this.terminate();
                            escaped = true;
                            state = ParseState.NORMAL;
                            exitState = ParseState.NORMAL;
                        }
                    }
                }
                if (escaped) {
                    switch (state.ordinal()) {
                        case 0: {
                            this.terminate();
                            ++this.head;
                            this.ctx.append(HiddenLiteral.plain("\\"));
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    continue;
                }
            } else {
                escaped = false;
                continue;
            }
            switch (state.ordinal()) {
                case 0: {
                    if (c != '<') break;
                    this.terminate();
                    tagHead = this.head++;
                    argHead = this.head;
                    state = ParseState.TAG;
                    exitState = ParseState.TAG;
                    break;
                }
                case 2: {
                    if (c == '<') {
                        this.head = tagHead;
                        this.terminate();
                        tagHead = this.tail;
                        argHead = ++this.head;
                        state = ParseState.TAG;
                        exitState = ParseState.TAG;
                        break;
                    }
                    if (c == ':') {
                        if (this.tail + 2 < this.s.length() && this.s.charAt(this.tail + 1) == '/' && this.s.charAt(this.tail + 2) == '/') break;
                        this.finishArg();
                        argHead = this.head;
                        break;
                    }
                    if (c == '>') {
                        this.finishArg();
                        argHead = this.head;
                        if (this.args.size() > 0) {
                            Object argsData;
                            String name;
                            String argString = this.s.substring(tagHead + 1, this.tail);
                            if (!this.parseTag(argString, name = this.args.get(0), (ArgData)(argsData = new ArgData(this.args.size() > 1 ? this.args.subList(1, this.args.size()) : List.of())))) {
                                this.head = tagHead;
                            }
                            this.args.clear();
                        }
                        state = ParseState.NORMAL;
                        exitState = ParseState.NORMAL;
                        break;
                    }
                    if (c != '\'' && c != '\"') break;
                    quote = c;
                    if (this.s.indexOf(c, this.tail + 1) == -1) break;
                    state = ParseState.STRING;
                    exitState = ParseState.STRING;
                    break;
                }
                case 1: {
                    if (c != quote) break;
                    state = ParseState.TAG;
                    exitState = ParseState.TAG;
                }
            }
            if (this.hasNext() || state != ParseState.TAG) continue;
            this.tail = this.head = tagHead;
            state = ParseState.NORMAL;
            exitState = ParseState.TAG;
        }
        String trailingText = null;
        ArrayList<String> trailingArgs = new ArrayList<String>();
        ArrayList<String> unclosedTags = new ArrayList<String>();
        ++this.tail;
        if (exitState == ParseState.TAG) {
            this.head = argHead;
            this.finishArg();
            this.head = tagHead;
        }
        if (this.head < this.tail) {
            this.ctx.append(new Literal(this.s.substring(this.head, this.tail)));
        }
        for (String arg : this.args) {
            trailingArgs.add(arg);
        }
        if (!trailingArgs.isEmpty()) {
            trailingText = (String)trailingArgs.remove(trailingArgs.size() - 1);
        }
        while (this.ctx != this.root) {
            Branch b = this.popUnclosed();
            this.ctx.append(b);
            unclosedTags.add(b.format.tagName);
        }
        if (exitState == ParseState.TAG && this.args.size() > 0) {
            String argString = this.s.substring(tagHead + 1, this.tail);
            String name = this.args.get(0);
            ArgData argsData = new ArgData(this.args.size() > 1 ? this.args.subList(1, this.args.size()) : List.of());
            this.tagOutput = MiniMessageTagOutput.SINK;
            this.parseTag(argString, name, argsData);
        }
        return new MiniMessageResult(this.root, trailingText, trailingArgs, unclosedTags, this.errors);
    }

    private boolean parseTag(String argString, String name, ArgData args) {
        if (name.isEmpty()) {
            return false;
        }
        try {
            return name.charAt(0) == '/' ? this.parseCloseTag(argString, name, args) : this.parseTagUnsafe(argString, name, args);
        }
        catch (InvalidMiniMessage e) {
            if (e.error != null) {
                this.errors.add(e.error);
            }
            return false;
        }
    }

    private boolean parseCloseTag(String argString, String name, ArgData args) throws InvalidMiniMessage {
        String nameLower = name.substring(1).toLowerCase(Locale.ROOT);
        if (this.nameCounter.getInt((Object)nameLower) > 0) {
            Branch b;
            while (this.ctx != this.root && !this.ctx.format.tagName.toLowerCase(Locale.ROOT).equals(nameLower)) {
                b = this.popUnclosed();
                this.ctx.append(b);
            }
            if (this.ctx == this.root) {
                return false;
            }
            b = this.popCtx();
            this.ctx.append(b);
            return true;
        }
        return false;
    }

    private boolean parseTagUnsafe(String argString, String name, ArgData args) throws InvalidMiniMessage {
        return MiniMessageParserRegistry.forEach(parser -> parser.parseTag(this.tagOutput, this, argString, name, args, this.server));
    }

    public char next() {
        return this.tail < this.tMax ? this.s.charAt(++this.tail) : (char)'\u0000';
    }

    public boolean hasNext() {
        return this.tail < this.tMax;
    }

    public boolean finishArg() {
        String str;
        String string = str = this.head <= this.tail ? this.s.substring(this.head, this.tail) : null;
        if (str != null) {
            this.args.add(str);
        }
        this.head = this.tail + 1;
        return str != null;
    }

    public void terminate() {
        this.args.clear();
        String str = this.tok();
        if (str != null && !str.isEmpty()) {
            this.ctx.append(new Literal(str));
        }
        this.head = this.tail;
    }

    public String tok() {
        return this.head < this.tail && this.tail <= this.s.length() ? this.s.substring(this.head, this.tail) : null;
    }

    private Branch pushCtx(Format format) {
        this.stack.push(this.ctx);
        this.ctx = new Branch(format);
        String formatName = format.tagName.toLowerCase(Locale.ROOT);
        this.nameCounter.put((Object)formatName, this.nameCounter.getInt((Object)formatName) + 1);
        return this.ctx;
    }

    private Branch popCtx() {
        Branch b = this.ctx;
        String formatName = b.format.tagName.toLowerCase(Locale.ROOT);
        this.nameCounter.put((Object)formatName, this.nameCounter.getInt((Object)formatName) - 1);
        this.ctx = this.stack.pop();
        return b;
    }

    private Branch popUnclosed() {
        this.ctx.setUnclosed();
        return this.popCtx();
    }

    public static String quoteArg(String arg) {
        if (arg.isEmpty() || arg.length() < 2) {
            return arg;
        }
        int min = 0;
        int max = arg.length();
        char first = arg.charAt(0);
        if (first == '\'' || first == '\"') {
            ++min;
            if (arg.charAt(max - 1) == first) {
                --max;
            }
            return arg.substring(min, max).replaceAll("\\\\" + first, String.valueOf(first));
        }
        return arg;
    }

    public Node nodeArg(String arg) throws InvalidMiniMessage {
        if (arg.isEmpty() || arg.length() < 2) {
            return new Literal(arg);
        }
        int min = 0;
        int max = arg.length();
        char first = arg.charAt(0);
        if (first == '\'' || first == '\"') {
            ++min;
            if (arg.charAt(max - 1) == first) {
                --max;
            }
            return this.subParse((String)arg.substring((int)min, (int)max).replaceAll((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\\\\\u0001"}, (char)first)), (String)String.valueOf((char)first)), (Format)new QuoteFormat((String)String.valueOf((char)first))).root;
        }
        return new Literal(arg);
    }

    public static Optional<class_5251> parseColor(String color) {
        if (color.startsWith("#")) {
            try {
                int i = Integer.parseInt(color.substring(1), 16);
                return i >= 0 && i <= 0xFFFFFF ? Optional.of(class_5251.method_27717((int)i)) : Optional.empty();
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return MiniMessageParser.parseNamedColor(color);
    }

    public static Optional<class_5251> parseNamedColor(String color) {
        switch (color.toLowerCase(Locale.ROOT)) {
            case "black": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1074));
            }
            case "dark_blue": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1058));
            }
            case "dark_green": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1077));
            }
            case "dark_aqua": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1062));
            }
            case "dark_red": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1079));
            }
            case "dark_purple": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1064));
            }
            case "gold": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1065));
            }
            case "gray": 
            case "grey": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1080));
            }
            case "dark_gray": 
            case "dark_grey": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1063));
            }
            case "blue": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1078));
            }
            case "green": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1060));
            }
            case "aqua": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1075));
            }
            case "red": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1061));
            }
            case "light_purple": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1076));
            }
            case "yellow": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1054));
            }
            case "white": {
                return Optional.of(class_5251.method_27718((class_124)class_124.field_1068));
            }
        }
        return Optional.empty();
    }

    public <T> boolean parseComponent(class_9331<T> type, class_2520 tag, class_9326.class_9327 components) {
        if (this.registryOps.isEmpty()) {
            return false;
        }
        Optional component = type.method_57876().parse(this.registryOps.get(), (Object)tag).resultOrPartial();
        if (component.isEmpty()) {
            return false;
        }
        components.method_57854(type, component.get());
        return true;
    }

    private static enum ParseState {
        NORMAL,
        STRING,
        TAG;

    }
}

