/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.autocomplete;

import _3650.builders_inventory.api.minimessage.autocomplete.AutocompleteArg;
import _3650.builders_inventory.api.minimessage.autocomplete.SimpleStringArg;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutocompleteTagLookup {
    private SimpleStringArg nodes = SimpleStringArg.of(List.of());
    private Object2ObjectOpenHashMap<String, Entry> entries = new Object2ObjectOpenHashMap();

    public ACBuilder builder() {
        return new ACBuilder();
    }

    public List<String> suggestTag(String input) {
        return AutocompleteTagLookup.sort(input, this.nodes.findNonMatch(input));
    }

    public List<String> suggestArg(String tagName, int arg, @Nullable String prev, @NotNull String input) {
        Suggestor suggest;
        Entry entry = (Entry)this.entries.get((Object)tagName);
        if (entry == null) {
            return List.of();
        }
        if (entry.varargs != null) {
            suggest = entry.varargs;
        } else if (arg < entry.args.size()) {
            suggest = entry.args.get(arg);
        } else {
            return List.of();
        }
        return AutocompleteTagLookup.sort(input, suggest.suggest(prev, input));
    }

    private static List<String> sort(String input, List<String> strs) {
        if (strs.isEmpty()) {
            return strs;
        }
        boolean isMc = strs.get(0).startsWith("minecraft:");
        String lower = input.toLowerCase(Locale.ROOT);
        Object str = isMc ? "minecraft:" + lower : lower;
        ArrayList<String> sorted = new ArrayList<String>(strs.size());
        ArrayList<String> nostart = new ArrayList<String>(strs.size());
        for (String s : strs) {
            if (s.startsWith((String)str)) {
                sorted.add(s);
                continue;
            }
            nostart.add(s);
        }
        sorted.addAll(nostart);
        return sorted;
    }

    public class ACBuilder {
        private final ArrayList<String> vals = new ArrayList();
        private final Object2ObjectOpenHashMap<String, Entry> entries = new Object2ObjectOpenHashMap();

        private ACBuilder() {
        }

        public EBStage entry(String name) {
            return new EBStage(List.of(name));
        }

        public EBStage entry(String ... names) {
            return new EBStage(List.of(names));
        }

        public EBStage entry(Collection<String> names) {
            return new EBStage(names);
        }

        public void end() {
            AutocompleteTagLookup.this.nodes = SimpleStringArg.of(this.vals);
            AutocompleteTagLookup.this.entries = this.entries;
        }

        public class EBStage {
            private final Collection<String> names;

            private EBStage(Collection<String> names) {
                this.names = names;
            }

            public ACBuilder build() {
                for (String name : this.names) {
                    ACBuilder.this.entries.put((Object)name, (Object)new Entry(List.of(), null));
                    ACBuilder.this.vals.add(name);
                }
                return ACBuilder.this;
            }

            public ACBuilder build(Consumer<EntryBuilder> builder) {
                for (String name : this.names) {
                    EntryBuilder b = new EntryBuilder();
                    builder.accept(b);
                    ACBuilder.this.entries.put((Object)name, (Object)new Entry(b.args, b.varargs));
                    ACBuilder.this.vals.add(name);
                }
                return ACBuilder.this;
            }
        }
    }

    private static class Entry {
        public final List<Suggestor> args;
        public final Suggestor varargs;

        private Entry(List<Suggestor> args, Suggestor varargs) {
            this.args = args;
            this.varargs = varargs;
        }
    }

    @FunctionalInterface
    public static interface Suggestor {
        public List<String> suggest(@Nullable String var1, @NotNull String var2);

        public static Suggestor empty() {
            return (prev, input) -> List.of();
        }

        public static Suggestor literal(String text) {
            return (prev, input) -> input.isEmpty() || text.startsWith(input) ? List.of(text) : List.of();
        }

        public static Suggestor arg(AutocompleteArg arg) {
            return (prev, input) -> arg.findNonMatch(input);
        }

        public static Suggestor resource(AutocompleteArg arg) {
            return (prev, input) -> prev == null ? arg.findNonMatch(input) : arg.findNonMatch(prev + ":" + input).stream().map(s -> s.substring(prev.length() + 1)).toList();
        }
    }

    public static class EntryBuilder {
        private final List<Suggestor> args = new ArrayList<Suggestor>();
        private Suggestor varargs = null;

        private EntryBuilder() {
        }

        public EntryBuilder emptyArg() {
            this.args.add(Suggestor.empty());
            return this;
        }

        public EntryBuilder arg(AutocompleteArg arg) {
            this.args.add(Suggestor.arg(arg));
            return this;
        }

        public EntryBuilder resource(AutocompleteArg arg) {
            this.args.add(Suggestor.resource(arg));
            this.args.add(Suggestor.resource(arg));
            return this;
        }

        public EntryBuilder arg(String arg) {
            this.args.add(Suggestor.literal(arg));
            return this;
        }

        public EntryBuilder arg(Suggestor arg) {
            this.args.add(arg);
            return this;
        }

        public EntryBuilder varArg(Suggestor arg) {
            this.varargs = arg;
            return this;
        }
    }
}

