package _3650.builders_inventory.api.minimessage.instance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10209;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.api.minimessage.MiniMessageParser;
import _3650.builders_inventory.api.minimessage.MiniMessageResult;
import _3650.builders_inventory.api.minimessage.MiniMessageUtil;
import _3650.builders_inventory.api.minimessage.validator.MiniMessageValidator;
import _3650.builders_inventory.api.minimessage.widgets.wrapper.WrappedTextField;
import _3650.builders_inventory.config.Config;
import _3650.builders_inventory.feature.minimessage.MiniMessageFeature;
import _3650.builders_inventory.feature.minimessage.chat.ChatMiniMessageContext;
import _3650.builders_inventory.util.StringDiff;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

// help me
/**
 * Methods to call when using this:<br>
 * <br>
 * {@link #tick()}<br>
 * {@link #unknownEdit()}<br>
 * {@link #cursorMoved()}<br>
 * {@link #inputEdited()}<br>
 * {@link #quietUpdate()}<br>
 * {@link #renderPreviewOrError(class_332)}
 * {@link #renderSuggestions(class_310, class_332, class_327, int, int)}<br>
 * {@link #keyPressed(int, int, int)}<br>
 * {@link #mouseScrolled(double, double, double, double)}<br>
 * {@link #mouseClicked(double, double, int)}<br>
 * 
 */
public class MiniMessageInstance {
	
	private final class_310 minecraft;
	private final class_437 screen;
	private final class_327 font;
	public final WrappedTextField input;
	private final MiniMessageValidator context;
	private final LastParseListener listener;
	private final PreviewOptions previewOptions;
	private final SuggestionsDisplay display;
	
	
	public MiniMessageInstance(
			class_310 minecraft,
			class_437 screen,
			class_327 font,
			WrappedTextField input,
			MiniMessageValidator context,
			LastParseListener listener,
			PreviewOptions previewOptions,
			SuggestionOptions suggestionOptions) {
		this.minecraft = minecraft;
		this.screen = screen;
		this.font = font;
		this.input = input;
		this.context = context;
		this.listener = listener;
		this.previewOptions = previewOptions;
		this.display = new SuggestionsDisplay(suggestionOptions);
		this.reposition();
	}
	
	@Nullable
	public MiniMessageResult lastParse = null;
	@Nullable
	public HighlightedTextInput inputOverride = null;
	@NotNull
	public List<class_5481> previewLines = List.of();
	
	@Nullable
	private String lastValue = null;
	private int updateTimer = 0;
	
	private boolean active = true;
	
	public void setActive(boolean active) {
		this.active = active;
		if (!active && updateTimer > 0 && lastValue != null) {
			this.updateTimer = 0;
			if (this.updateMiniMessage(lastValue)) {
				this.display.suggestionOptions.claimSuggestions();
			}
		}
	}
	
	public void tick() {
		if (updateTimer > 0) {
			--updateTimer;
			if (updateTimer <= 0 && lastValue != null && updateMiniMessage(lastValue)) {
				this.display.suggestionOptions.claimSuggestions();
			}
		}
	}
	
	public boolean unknownEdit() {
		if (!active) return false;
		@Nullable
		final String value = input.getValue();
		
		if (Objects.equals(value, lastValue)) { 
			return this.cursorMoved(value);
		}
		
		return this.inputEdited(value);
	}
	
	public boolean cursorMoved() {
		if (!active) return false;
		return this.cursorMoved(input.getValue());
	}
	
	private boolean cursorMoved(String value) {
		// cursor move
		this.cursorMoved(value, input.getCursorPosition());
		
		// return regardless
		return lastParse != null;
	}
	
	public boolean inputEdited() {
		if (!active) return false;
		return this.inputEdited(input.getValue());
	}
	
	private boolean inputEdited(String value) {
		this.lastValue = value;
		
		// update delay option for slow computers just in case cuz this could lag idk
		final int delay = Config.instance().minimessage_updateDelay;
		if (delay > 0) {
			this.updateTimer = delay;
			this.inputOverride = null;
			this.clear();
			return lastParse != null;
		}
		
		if (value != null && updateMiniMessage(value)) {
			this.display.suggestionOptions.claimSuggestions();
			return true;
		}
		
		return false;
	}
	
	public boolean quietUpdate() {
		@Nullable
		final String value = input.getValue();
		
		boolean messageUpdated = false;
		if (value != null) {
			this.suppressSuggestionUpdate = true;
			this.lastValue = value;
			messageUpdated = updateMiniMessage(value);
			this.suppressSuggestionUpdate = false;
		}
		if (messageUpdated) {
			this.display.suggestionOptions.claimSuggestions();
			return true;
		}
		return false;
	}
	
	private static final class_2583 LITERAL_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
	
	private boolean updateMiniMessage(@NotNull String value) {
		final String originalValue = value;
		
		{
			// only work in certain contexts
			final var newVal = this.context.isValid(this.minecraft, value);
//			BuildersInventory.LOGGER.warn(newVal.toString());
			
			// validate value
			if (newVal.isEmpty() || newVal.get().isEmpty()) {
				this.clearParse();
				return false;
			} else value = newVal.get();
		}
		
		// parse message
		final var mini = MiniMessageParser.parse(value, registryAccess(this.minecraft), ChatMiniMessageContext.currentServerIP);
		this.setLastParse(mini);
		
		// find any text lost
		final var missing = StringDiff.missing(originalValue, value);
		final List<StringDiff> diffs = missing.diffs;
		final Iterator<StringDiff> diffIter = diffs.iterator();
		final int origS = originalValue.length();
		
		// get plaintext with fun syntax highlighting
		class_5250 highSeq = mini.getFormattedPlain();
		
		// input result
		final var input = new HighlightedTextInput.Builder(origS + missing.length);
		
		final var reconstructor = new class_5348.class_5246<Integer>() {
			public int index = 0;
			public StringDiff diff = diffs.isEmpty() ? null : diffIter.next();
			
			@Override
			public Optional<Integer> accept(class_2583 style, String string) {
				if (input.length + string.length() >= origS) {
					final int i = origS - input.length;
					if (i > 0) {
						final String end = string.substring(0, i);
						input.append(end, style);
					}
					return Optional.of(input.length + i);
				}
				if (diff == null) {
					input.append(string, style);
					return Optional.empty();
				}
				
				if (index + string.length() >= diff.index && diff.index >= index) {
					final int i = diff.index - index;
					
					if (i > 0) {
						final String before = string.substring(0, i);
						input.append(before, style);
						index += before.length();
					}
					input.append(diff.value, style);
					
					diff = diffIter.hasNext() ? diffIter.next() : null;
					
					if (i < string.length()) return accept(style, string.substring(i));
				} else {
					input.append(string, style);
					index += string.length();
				}
				return Optional.empty();
			}
		};
		
		// deal with index 0 diffs first
		while (reconstructor.diff != null && reconstructor.diff.index == 0) {
			input.append(reconstructor.diff.value, LITERAL_STYLE);
			reconstructor.diff = diffIter.hasNext() ? diffIter.next() : null;
		}
		
		// execute order 66
		highSeq.method_27658(reconstructor, class_2583.field_24360).toString();
		
		// clean up remaining diffs
		if (reconstructor.diff != null) {
			input.append(reconstructor.diff.value, class_2583.field_24360);
		}
		while (diffIter.hasNext()) {
			input.append(diffIter.next().value, class_2583.field_24360);
		}
		
		// build formatted input
		final var formattedInput = input.build();
		
		// get error to yell about
		final int err = StringUtils.indexOfDifference(originalValue, formattedInput.text);
		
		// get preview component depending on if it's an error or not
		class_5250 previewComponent = null;
		if (err > -1) {
			previewComponent = class_2561.method_43470(highSeq.getString()).method_27694(style -> style
					.method_27706(class_124.field_1079)
					.method_10949(new class_2568.class_10613(
							class_2561.method_43469("err.builders_inventory.minimessage.mismatch", err)
							.method_27692(class_124.field_1061))));
			BuildersInventory.LOGGER.error("FORMAT ERROR at {} for original {} and reconstructed {}", err, originalValue, formattedInput.text);
			this.inputOverride = null;
		} else {
			if (!mini.errors.isEmpty()) {
				previewComponent = class_2561.method_43473().method_27692(class_124.field_1061);
				final var errors = mini.errors;
				for (int i = 0; i < errors.size(); i++) {
					String error = errors.get(i);
					if (i < errors.size() - 1) error = error + '\n';
					previewComponent.method_10852(class_2561.method_43470(error));
				}
			} else if (this.previewOptions.doStandardPreview(this.minecraft, this.screen, this)) previewComponent = mini.getFormatted();
			if (Config.instance().minimessage_syntaxHighlighting) this.inputOverride = formattedInput;
			else this.inputOverride = null;
			this.update(mini);
		}
		
		this.previewLines = List.of();
		if (previewComponent != null) {
			class_338 chatLog = this.minecraft.field_1705.method_1743();
			this.previewLines = class_341.method_1850(previewComponent, class_3532.method_15357(chatLog.method_1811() / chatLog.method_1814()), this.font);
			this.reposition();
		} else if (this.inputOverride != null) {
			this.reposition();
		}
		return true;
	}
	
	public void clearParse() {
		this.setLastParse(null);
		this.inputOverride = null;
		this.previewLines = List.of();
		this.lastValue = null;
		this.clear();
	}
	
	private void setLastParse(@Nullable MiniMessageResult lastParse) {
		this.lastParse = lastParse;
		this.listener.onParseChange(lastParse);
	}
	
	private static Optional<class_7225.class_7874> registryAccess(class_310 mc) {
		return mc.field_1687 == null ? Optional.empty() : Optional.of(mc.field_1687.method_30349());
	}
	
	private final Int2ObjectOpenHashMap<SuggestionList> cache = new Int2ObjectOpenHashMap<>();
	
	public boolean suppressSuggestionUpdate = false;
	
	public Optional<class_5481> tryFormatInput(String text, int offset) {
		if (this.inputOverride != null) return Optional.ofNullable(this.inputOverride.subseq(offset, offset + text.length()));
		return Optional.empty();
	}
	
	public boolean canFormat() {
		return this.inputOverride != null;
	}
	
	public class_5481 format(int start, int end) {
		if (this.inputOverride != null) {
			return this.inputOverride.subseq(start, end);
		} else throw new IllegalStateException("Expected to be ready to format string but was not");
	}
	
	public static interface PreviewOptions {
		
		public static StandardPreviewOptions standard(boolean doStandardPreview) {
			return new StandardPreviewOptions(doStandardPreview);
		}
		
		static class StandardPreviewOptions implements PreviewOptions {
			
			private final boolean doStandardPreview;
			
			private StandardPreviewOptions(boolean doStandardPreview) {
				this.doStandardPreview = doStandardPreview;
			}
			
			@Override
			public boolean doStandardPreview(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return this.doStandardPreview && Config.instance().minimessage_messagePreview;
			}
			
			@Override
			public int getBGColor(class_310 mc, class_437 screen) {
				return 0xA0000000;
			}
			
			@Override
			public float getScale(class_310 mc, class_437 screen) {
				return 1f;
			}
			
			@Override
			public int getWidth(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return screen.field_22789;
			}
			
			@Override
			public int getX(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return 0;
			}
			
			@Override
			public int getLineTextOffset(class_310 mc, class_437 screen) {
				return -8;
			}
			
			@Override
			public int getLineHeight(class_310 mc, class_437 screen) {
				return 9;
			}
			
			@Override
			public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return widget.input.getY() + widget.input.getHeight() + 2 + class_3532.method_15375(widget.getScaledLineHeight());
			}
			
		}
		
		public static PreviewOptions chat() {
			return new ChatPreviewOptions();
		}
		
		static class ChatPreviewOptions implements PreviewOptions {
			
			private ChatPreviewOptions() {
				
			}
			
			@Override
			public boolean doStandardPreview(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return Config.instance().minimessage_messagePreview;
			}
			
			@Override
			public int getBGColor(class_310 mc, class_437 screen) {
				return ((int)(255.0 * mc.field_1690.method_42550().method_41753())) << 24;
			}
			
			@Override
			public float getScale(class_310 mc, class_437 screen) {
				return (float) mc.field_1705.method_1743().method_1814();
			}
			
			@Override
			public int getWidth(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return mc.field_1705.method_1743().method_1811();
			}
			
			@Override
			public int getX(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return 0;
			}
			
			@Override
			public int getLineTextOffset(class_310 mc, class_437 screen) {
				return (int) Math.round(-8.0 * (mc.field_1690.method_42546().method_41753() + 1.0) + 4.0 * mc.field_1690.method_42546().method_41753());
			}
			
			@Override
			public int getLineHeight(class_310 mc, class_437 screen) {
				return MiniMessageUtil.getLineHeight(mc.field_1705.method_1743());
			}
			
			@Override
			public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget) {
				return screen.field_22790 - 14 - Config.instance().minimessage_chatPreviewHeight;
			}
			
		}
		
		public boolean doStandardPreview(class_310 mc, class_437 screen, MiniMessageInstance widget);
		
		public int getBGColor(class_310 mc, class_437 screen);
		
		public float getScale(class_310 mc, class_437 screen);
		
		public int getWidth(class_310 mc, class_437 screen, MiniMessageInstance widget);
		
		public int getX(class_310 mc, class_437 screen, MiniMessageInstance widget);
		
		public int getLineTextOffset(class_310 mc, class_437 screen);
		
		public int getLineHeight(class_310 mc, class_437 screen);
		
		public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget);
		
	}
	
	private int _previewBGColor;
	private float _previewScale;
	private int _previewWidth;
	private int _previewXMin;
	private int _previewLineTextOffset;
	private int _previewLineHeight;
	private float _previewScaledLineHeight;
	private int _previewYMin;
	
	public void repositionPreview() {
		if (!this.previewLines.isEmpty()) {
			this._previewBGColor = previewOptions.getBGColor(minecraft, screen);
			this._previewScale = previewOptions.getScale(minecraft, screen);
			this._previewWidth = previewOptions.getWidth(minecraft, screen, this);
			this._previewXMin = previewOptions.getX(minecraft, screen, this);
			this._previewLineTextOffset = previewOptions.getLineTextOffset(minecraft, screen);
			this._previewLineHeight = previewOptions.getLineHeight(minecraft, screen);
			this._previewScaledLineHeight = _previewLineHeight * _previewScale;
			this._previewYMin = previewOptions.getY(minecraft, screen, this);
		}
	}
	
	public void renderPreviewOrError(class_332 gui) {
		if (!active) return;
		if (!previewLines.isEmpty()) {
			gui.method_51448().pushMatrix();
			gui.method_51448().translate(_previewXMin, _previewYMin);
			gui.method_51448().scale(_previewScale, _previewScale);
			gui.method_25294(0, 0, class_3532.method_15386(_previewWidth / _previewScale) + 4 + 4 + 4, - (_previewLineHeight * previewLines.size()), _previewBGColor);
			int y = _previewLineTextOffset;
			for (int i = previewLines.size() - 1; i >= 0; --i) {
				class_5481 line = previewLines.get(i);
				gui.method_35720(font, line, 4, y, 0xFFFFFFFF);
				y -= _previewLineHeight;
			}
			gui.method_51448().popMatrix();
		}
	}
	
	public float getScaledLineHeight() {
		return this.previewLines.size() * _previewScaledLineHeight;
	}
	
	public float getScaledLineHeight(int ignoreDiff) {
		return ignoreDiff >= this.previewLines.size() ? 0 : ((this.previewLines.size() - ignoreDiff) * _previewScaledLineHeight);
	}
	
	public boolean renderHover(class_332 gui, int mouseX, int mouseY) {
		if (!previewLines.isEmpty()) {
			double localX = toPreviewX(mouseX);
			double localY = toPreviewYLine(mouseY);
			int line = getPreviewLine(localX, localY);
			if (line >= 0) {
				class_2583 style = font.method_27527().method_30876(previewLines.get(line), class_3532.method_15357(localX));
				if (style != null && style.method_10969() != null) {
					gui.method_51441(font, style, mouseX, mouseY);
					return true;
				}
			}
		}
		return false;
	}
	
	public boolean renderFormatHover(class_332 gui, int mouseX, int mouseY, int start, int end) {
		if (this.inputOverride != null && Config.instance().minimessage_syntaxHighlighting) {
			int inputX = input.getTextX();
			int inputXMax = inputX + input.getInnerWidth();
			int inputY = input.getTextY(start);
			int inputYMax = inputY + input.getLineHeight();
			if (mouseX >= inputX && mouseX < inputXMax && mouseY >= inputY && mouseY < inputYMax) {
				class_2583 style = font.method_27527().method_30876(inputOverride.subseq(start, end), mouseX - inputX);
				if (style != null && style.method_10969() != null) {
					gui.method_51441(font, style, mouseX, mouseY);
					return true;
				}
			}
		}
		return false;
	}
	
	public class_2583 tryClickPreview(double mouseX, double mouseY) {
		if (!active) return null;
		if (!previewLines.isEmpty()) {
			double localX = toPreviewX(mouseX);
			double localY = toPreviewYLine(mouseY);
			int line = getPreviewLine(localX, localY);
			if (line >= 0) {
				class_2583 style = font.method_27527().method_30876(previewLines.get(line), class_3532.method_15357(localX));
				if (style == null) return null;
				final class_2558 click = style.method_10970();
				if (click == null || click instanceof class_2558.class_10610) return null;
				return style;
			}
		}
		return null;
	}
	
	private double toPreviewX(double mouseX) {
		return ((mouseX - 4) / _previewScale) - _previewXMin;
	}
	
	private double toPreviewYLine(double mouseY) {
		return (_previewYMin - mouseY) / (_previewScale * _previewLineHeight);
	}
	
	/**
	 * Make sure to test if line >= 0 outside
	 */
	private int getPreviewLine(double localX, double localY) {
		if (localX >= 0 && localX <= class_3532.method_15375(_previewWidth / _previewScale)) {
			int line = class_3532.method_15357(localY);
			if (line < previewLines.size()) return line; // line >= 0 tested outside
		}
		return -1; // always fails >= 0 as it is not greater than nor equal to zero
	}
	
	@Nullable
	private ArrayList<String> unclosedTags = null;
	@Nullable
	private SuggestionList endSuggestion;
	@Nullable
	private SuggestionList suggestion;
	
	public void clear() {
		cache.clear();
		endSuggestion = null;
		suggestion = null;
		unclosedTags = null;
		if (suppressSuggestionUpdate) return;
		display.clear();
	}
	
	private void update(@NotNull MiniMessageResult msg) {
		this.clear();
		unclosedTags = msg.unclosedTags;
		List<String> unclosed = filterTagClose(msg.trailingText);
		ArrayList<String> formatUnclosed = new ArrayList<>(unclosed.size());
		for (String s : unclosed) formatUnclosed.add("</" + s + '>');
		endSuggestion = new SuggestionList(formatUnclosed, 0);
		class_3695 profiler = class_10209.method_64146();
		profiler.method_15396("cursorMovedMM");
		cursorMoved(input.getValue(), input.getCursorPosition());
		profiler.method_15407();
	}
	
	private void cursorMoved(String value, int cursor) {
		if (suppressSuggestionUpdate) return;
		if (!Config.instance().minimessage_suggestions) {
			this.clear();
			return;
		}
		if (cursor > value.length()) return;
		if (moveCursor(value, cursor)) {
			// get suggestions for finishing tags
			this.display.set(suggestion, suggestion.start, cursor, cursor == value.length());
		} else if (cursor == value.length()) {
			// get suggestions for unclosed tags
			this.display.set(endSuggestion, cursor, cursor, true);
		} else display.clear();
	}
	
	private boolean moveCursor(String value, int cursor) {
		if (cache.containsKey(cursor)) {
			var suggestion = cache.get(cursor);
			if (suggestion.valid) {
				this.suggestion = suggestion;
				return true;
			} else {
				this.suggestion = null;
				return false;
			}
		}
		if (value == null || value.isEmpty()) {
			this.suggestion = null;
			return false;
		}
		final int start = value.lastIndexOf('<', cursor - 1);
		if (start > 0 && value.charAt(start - 1) == '\\') {
			this.suggestion = null;
			return false;
		}
		if (start == -1 || start >= cursor) {
			this.suggestion = null;
			return false;
		}
		final var text = value.substring(start, cursor);
		final var parse = minecraft.field_1687 == null ? MiniMessageParser.parseNoRegistry(text) : MiniMessageParser.parse(text, Optional.of(minecraft.field_1687.method_30349()), ChatMiniMessageContext.currentServerIP);
		if (parse.trailingText == null) {
			this.suggestion = null;
			return false;
		}
		
		// get suggestion list
		final var input = parse.trailingText;
		if (!input.isEmpty() && parse.trailingArgs.isEmpty() && input.charAt(0) == '/') {
			if (cursor == value.length() || value.indexOf('<', cursor) == -1) {
				final var unclosed = filterTagClose(input);
				if (!unclosed.isEmpty()) {
					final var strs = new ArrayList<String>(unclosed.size());
					for (String s : unclosed) strs.add("</" + s + '>');
					this.suggestion = new SuggestionList(strs, cursor - input.length() - 1);
				} else {
					final var strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input.substring(1));
					this.suggestion = new SuggestionList(strs, cursor - input.length() + 1);
				}
			} else {
				final var strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input.substring(1));
				this.suggestion = new SuggestionList(strs, cursor - input.length() + 1);
			}
		} else if (parse.trailingArgs.isEmpty()) {
			final var strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input);
			this.suggestion = new SuggestionList(strs, cursor - input.length());
		} else {
			final var args = parse.trailingArgs;
			final var tagName = args.get(0);
			final var prev = args.size() > 1 ? args.get(args.size() - 1) : null;
			final var strs = MiniMessageFeature.TAG_LOOKUP.suggestArg(tagName, args.size() - 1, prev, input);
			this.suggestion = new SuggestionList(strs, cursor - input.length());
		}
		cache.put(cursor, this.suggestion);
		return true;
	}
	
	private List<String> filterTagClose(String trailingText) {
		if (unclosedTags == null) return List.of();
		return trailingText == null || trailingText.length() <= 1 ? unclosedTags : filterStart(unclosedTags, trailingText.substring(1));
	}
	
	private static ArrayList<String> filterStart(List<String> list, String start) {
		ArrayList<String> result = new ArrayList<>(list.size());
		for (String s : list) if (StringUtils.startsWithIgnoreCase(s, start)) result.add(s);
		return result;
	}
	
	private static class SuggestionList {
		
		public final List<String> strs;
		public final int start;
		public final int size;
		public final boolean valid;
		
		public SuggestionList(List<String> strs, int start) {
			this.strs = strs;
			this.start = start;
			this.size = strs.size();
			this.valid = !strs.isEmpty();
		}
		
	}
	
	public static interface SuggestionOptions {
		
		public static final int BG_MID = 0x80000000;
		public static final int BG_DARK = 0xD0000000;
		
		public static SuggestionOptions standard(int suggestionLimit) {
			return new StandardSuggestionOptions(suggestionLimit);
		}
		
		static class StandardSuggestionOptions implements SuggestionOptions {
			
			private final int suggestionLimit;
			
			private StandardSuggestionOptions(int suggestionLimit) {
				this.suggestionLimit = suggestionLimit;
			}
			
			@Override
			public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget, int x, int suggestionHeight) {
				return widget.previewLines.isEmpty() ? (widget.input.getY() + widget.input.getHeight()) : (widget._previewYMin + 1);
			}
			
			@Override
			public int getColor() {
				return BG_MID;
			}
			
			@Override
			public int getLimit() {
				return this.suggestionLimit;
			}
			
			@Override
			public void claimSuggestions() {
				// Nothing
			}
			
		}
		
		public static SuggestionOptions chat(Supplier<class_4717> commandSuggestions) {
			return new ChatSuggestionOptions(commandSuggestions);
		}
		
		static class ChatSuggestionOptions implements SuggestionOptions {
			
			private final Supplier<class_4717> commandSuggestions;
			
			private ChatSuggestionOptions(Supplier<class_4717> commandSuggestions) {
				this.commandSuggestions = commandSuggestions;
			}
			
			@Override
			public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget, int x, int suggestionHeight) {
				class_338 chatc = mc.field_1705.method_1743();
				return screen.field_22790 - 12 - 3 - suggestionHeight - ((x >= chatc.method_1811() + 12) ? 0 :
					widget.previewLines.isEmpty() ? 0 : (class_3532.method_15386(widget.getScaledLineHeight()) + Config.instance().minimessage_chatPreviewHeight));
			}
			
			@Override
			public int getColor() {
				return BG_DARK;
			}
			
			@Override
			public int getLimit() {
				return 10;
			}
			
			@Override
			public void claimSuggestions() {
				this.commandSuggestions.get().method_23933(false);
			}
			
		}
		
		public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget, int x, int suggestionHeight);
		
		public int getColor();
		
		public int getLimit();
		
		public void claimSuggestions();
		
	}
	
	public void reposition() {
		this.repositionPreview();
		if (this.display.visible) this.display.reposition();
	}
	
	public boolean renderSuggestions(class_332 gui, int mouseX, int mouseY) {
		if (!active) return false;
		final boolean result = this.display.render(gui, mouseX, mouseY);
		return result;
	}
	
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if (!active) return false;
		if (this.display.visible) return this.display.keyPressed(keyCode, scanCode, modifiers);
		else if (keyCode == GLFW.GLFW_KEY_TAB && this.unclosedTags != null) {
			this.cursorMoved(this.input.getValue(), this.input.getCursorPosition());
			return true;
		} else return false;
	}
	
	public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
		if (!active || !this.display.visible) return false;
		return this.display.mouseScrolled(
				(int)mouseX,
				(int)mouseY,
				class_3532.method_15350(scrollY, -1.0, 1.0));
	}
	
	public boolean mouseClicked(double mouseX, double mouseY, int button) {
		if (!active || !this.display.visible) return false;
		return this.display.mouseClicked((int)mouseX, (int)mouseY, button);
	}
	
	private class SuggestionsDisplay {
		
		private final SuggestionOptions suggestionOptions;
		
		public boolean visible = false;
		public List<String> suggestion = List.of();
		public int start = 0;
		private int end = 0;
		private boolean atEnd = false;
		private int x = 0;
		private int y = 0;
		private int width = 0;
		private int height = 0;
		
		public int lastMouseX = 0;
		public int lastMouseY = 0;
		
		public int offset = 0;
		public int selected = 0;
		private boolean tabCycles = false;
		
		public SuggestionsDisplay(SuggestionOptions suggestionOptions) {
			this.suggestionOptions = suggestionOptions;
		}
		
		public void clear() {
			this.hide();
			this.suggestion = null;
			MiniMessageInstance.this.input.setSuggestion(null);
		}
		
		private void hide() {
			this.visible = false;
			this.tabCycles = false;
		}
		
		public void set(SuggestionList list, int start, int cursor, boolean atEnd) {
			this.clear();
			if (list == null || !list.valid) return;
			this.visible = true;
			this.suggestion = list.strs;
			this.start = start;
			this.end = cursor;
			this.atEnd = atEnd;
			
			int widthScan = 0;
			for (String str : this.suggestion) widthScan = Math.max(widthScan, MiniMessageInstance.this.font.method_1727(str));
			this.width = widthScan + 1;
			this.height = Math.min(list.size, this.suggestionOptions.getLimit()) * 12;
			this.reposition();
			
			this.offset = 0;
			this.select(0);
		}
		
		public void reposition() {
			final var input = MiniMessageInstance.this.input;
			x = class_3532.method_15340(
					input.getScreenX(this.start),
					1,
					screen.field_22789 - this.width) - 1;
			y = this.suggestionOptions.getY(
					MiniMessageInstance.this.minecraft,
					screen,
					MiniMessageInstance.this,
					x,
					height);
		}
		
		public boolean render(class_332 gui, int mouseX, int mouseY) {
			if (!this.visible) return false;
			final int size = Math.min(this.suggestion.size(), this.suggestionOptions.getLimit());
			final boolean topCut = this.offset > 0;
			final boolean bottomCut = this.suggestion.size() > this.offset + size;
			
			final int bgColor = this.suggestionOptions.getColor();
			
			if (topCut || bottomCut) {
				gui.method_25294(x, y - 1, x + width, y, bgColor);
				gui.method_25294(x, y + height, x + width, y + height + 1, bgColor);
				if (topCut) for (int i = 0; i < width; i++) {
					if (i % 2 == 0) gui.method_25294(x + i, y - 1, x + i + 1, y, 0xFFFFFFFF);
				}
				
				if (bottomCut) for (int i = 0; i < width; i++) {
					if (i % 2 == 0) gui.method_25294(x + i, y + height, x + i + 1, y + height + 1, 0xFFFFFFFF);
				}
			}
			
			final boolean mouseMoved = mouseX != this.lastMouseX || mouseY != this.lastMouseY;
			if (mouseMoved) {
				this.lastMouseX = mouseX;
				this.lastMouseY = mouseY;
			}
			
			gui.method_25294(x, y, x + width, y + height, bgColor);
			
			for (int i = 0; i < size; i++) {
				final int index = i + this.offset;
				
				if (mouseMoved
						&& mouseX > x
						&& mouseX < x + width
						&& mouseY > y + (i * 12)
						&& mouseY < y + (i * 12) + 12) {
					select(index);
				}
				
				String s = this.suggestion.get(index);
				gui.method_25303(MiniMessageInstance.this.font, s, x + 1, y + 2 + (12 * i), (index == this.selected) ? 0xFFFFFF00 : 0xFFAAAAAA);
			}
			
			return true;
		}
		
		public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
			if (keyCode == GLFW.GLFW_KEY_UP) {
				cycle(-1);
				tabCycles = false;
				return true;
			} else if (keyCode == GLFW.GLFW_KEY_DOWN) {
				cycle(1);
				tabCycles = false;
				return true;
			} else if (keyCode == GLFW.GLFW_KEY_TAB) {
				if (tabCycles) {
					cycle(class_437.method_25442() ? -1 : 1);
				}
				useSuggestion();
				return true;
			} else if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
				hide();
				return true;
			} else return false;
		}
		
		public boolean mouseScrolled(int mouseX, int mouseY, double delta) {
			if (mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height) {
				offset = class_3532.method_15340((int)(offset - delta), 0, Math.max(suggestion.size() - this.suggestionOptions.getLimit(), 0));
				return true;
			} else return false;
		}
		
		public boolean mouseClicked(int mouseX, int mouseY, int button) {
			if (mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height) {
				int ind = (mouseY - y) / 12 + offset;
				if (ind >= 0 && ind < suggestion.size()) {
					select(ind);
					useSuggestion();
				}
				return true;
			} else return false;
		}
		
		private void cycle(int amt) {
			select(selected + amt);
			if (selected < offset) offset = class_3532.method_15340(selected, 0, Math.max(suggestion.size() - this.suggestionOptions.getLimit(), 0));
			else if (selected > offset + this.suggestionOptions.getLimit() - 1) offset = class_3532.method_15340(selected + 9, 0, Math.max(suggestion.size() - this.suggestionOptions.getLimit(), 0));
		}
		
		private void select(int i) {
			if (i < 0) i += suggestion.size();
			if (i >= suggestion.size()) i -= suggestion.size();
			this.selected = i;
			String sel = suggestion.get(i);
			String hint = substr(sel, end - start);
			if (hint == null) MiniMessageInstance.this.input.setSuggestion(null);
			else if (atEnd && sel.startsWith(MiniMessageInstance.this.input.getValue().substring(start, end))) MiniMessageInstance.this.input.setSuggestion(hint);
		}
		
		@Nullable
		private static String substr(String s, int begin) {
			return begin >= s.length() ? null : s.substring(begin);
		}
		
		private void useSuggestion() {
			String str = suggestion.get(selected);
			MiniMessageInstance.this.suppressSuggestionUpdate = true;
			final var input = MiniMessageInstance.this.input;
			String original = input.getValue();
			input.setValue(original.substring(0, start) + str + (this.atEnd ? "" : input.getValue().substring(end)));
			input.setSuggestion(null);
			final int cursor = start + str.length();
			input.setCursorPosition(cursor);
			input.setHighlightPos(cursor);
			this.end = cursor;
			MiniMessageInstance.this.suppressSuggestionUpdate = false;
			tabCycles = true;
		}
		
	}
	
}
