package _3650.builders_inventory.api.widgets.editbox;

import java.util.ArrayList;
import java.util.function.IntConsumer;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7533;
import org.jetbrains.annotations.Nullable;
import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.api.minimessage.MiniMessageResult;
import _3650.builders_inventory.api.minimessage.instance.LastParseListener;
import _3650.builders_inventory.api.minimessage.instance.MMInstanceConstructor;
import _3650.builders_inventory.api.minimessage.instance.MiniMessageInstance;
import _3650.builders_inventory.api.minimessage.widgets.MiniMessageEventListener;
import _3650.builders_inventory.api.minimessage.widgets.wrapper.WrappedTextField;
import _3650.builders_inventory.api.util.StringPos;

// scary evil monolithic class thats an amalgam of EditBox, MultiLineEditBox, AbstractScrollWidget and MultilineTextField with some MiniMessageWidget thrown in for bad luck
// if this crashes again im gonna be the one crashing next
/**
 * An Abomination.<br>
 * You still need to handle calling the following:<br>
 * {@link #miniMessageTick()}<br>
 * {@link #miniMessageMouseScrolled(double, double, double, double)}<br>
 * {@link #miniMessageMouseClicked(double, double, int)}<br>
 * These are either not possible in a widget or occur outside the widget's area and need full-screen coverage
 */
public class MultiLineMMEditBox extends class_339 implements MiniMessageEventListener {
	
	private static final int CURSOR_COLOR = 0xFFD0D0D0;
	
	private static final double SCROLL_RATE = 4.5;
	
	private final MMInstanceConstructor mmConstructor;
	private final EditBoxTheme theme;
	private final class_327 font;
	private final ArrayList<StringPos> displayLines = new ArrayList<>();
	private final ArrayList<FormatLine> formatLines = new ArrayList<>();
	
	
	private int maxLength = Integer.MAX_VALUE;
	
	@Nullable
	private String suggestion = null;
	
	private static final IntConsumer IGNORE_INT = x -> {};
	private static final Runnable IGNORE_RUN = () -> {};
	
	private LinedMMEditBoxListener changeListener = LinedMMEditBoxListener.IGNORE;
	private FormatLineConsumer lineEditListener = FormatLineConsumer.IGNORE;
	private IntConsumer lineCreateListener = IGNORE_INT;
	private IntConsumer lineDeleteListener = IGNORE_INT;
	private Runnable linesResetListener = IGNORE_RUN;
	
	@Nullable
	private MiniMessageInstance activeWidget = null;
	
	private boolean showLineNumbers = false;
	private int lineNumWidth = 0;
	
	private boolean externalScrollbar = false;
	private int scrollbarPadding = 0;
	private int scrollbarHeight = 0;
	private int rightPadding = 0;
	
	
	private String value;
	private int cursor;
	private int selectCursor;
	private boolean selecting;
	
	private double scrollAmount;
	private boolean scrolling;
	private long focusedTime = class_156.method_658();
	
	public MultiLineMMEditBox(MMInstanceConstructor mmConstructor, EditBoxTheme options, class_327 font, int x, int y, int width, int height, class_2561 message) {
		super(x, y, width, height, message);
		this.mmConstructor = mmConstructor;
		this.theme = options;
		this.font = font;
		this.setValue("");
	}
	
	public void setChangeListener(LinedMMEditBoxListener changeListener) {
		this.changeListener = changeListener;
	}
	
	public void setMiniMessageListener(
			FormatLineConsumer lineEditListener,
			IntConsumer lineCreateListener,
			IntConsumer lineDeleteListener,
			Runnable linesResetListener) {
		this.lineEditListener = lineEditListener;
		this.lineCreateListener = lineCreateListener;
		this.lineDeleteListener = lineDeleteListener;
		this.linesResetListener = linesResetListener;
	}
	
	public void setMaxLength(int limit) {
		this.maxLength = limit;
	}
	
	public void setSuggestion(@Nullable String suggestion) {
		this.suggestion = suggestion;
	}
	
	public void setShowLineNumbers(boolean showLineNumbers) {
		this.showLineNumbers = showLineNumbers;
		this.refreshLineNumWidth();
	}
	
	public void setExternalScrollbar(boolean externalScrollbar) {
		this.externalScrollbar = externalScrollbar;
		this.refreshScrollbar();
	}
	
	public void setValue(String value) {
		this.value = class_3544.method_34963(
				value,
				this.maxLength,
				false);
		this.cursor = this.value.length();
		this.selectCursor = this.cursor;
		var initLines = this.refreshFormatLines();
		this.reflowDisplayLines();
		this.scrollToCursor();
		for (var line : initLines) line.initUpdate();
	}
	
	public String getValue() {
		return this.value;
	}
	
	public String getText(StringPos pos) {
		return this.value.substring(pos.beginIndex, pos.endIndex);
	}
	
	public void insertText(String text) {
		if (!text.isEmpty() || this.hasSelection()) {
			StringPos selection = this.getSelected();
			this.insertTextCommon(text, selection);
		}
	}
	
	protected void insertTextInternal(String text) {
		if (!text.isEmpty() || this.hasSelection()) {
			StringPos selection = this.getSelected();
			String string = this.insertTextCommon(text, selection);
			this.changeListener.onInsert(string, selection.beginIndex, selection.endIndex);
		}
	}
	
	private String insertTextCommon(String text, StringPos selection) {
		String string = class_3544.method_34963(
				class_3544.method_57177(text, true),
				this.maxLength - this.value.length(),
				false);
		this.value = new StringBuilder(this.value).replace(selection.beginIndex, selection.endIndex, string).toString();
		this.cursor = selection.beginIndex + string.length();
		this.selectCursor = this.cursor;
		var initLines = this.refreshFormatRange(selection.beginIndex, selection.endIndex, this.cursor);
		this.reflowDisplayLines();
		this.scrollToCursor();
		for (var line : initLines) line.initUpdate();
		return string;
	}
	
	public void deleteText(int length) {
		this.deleteTextCommon(length);
		this.insertText("");
	}
	
	protected void deleteTextInternal(int length) {
		this.deleteTextCommon(length);
		this.insertTextInternal("");
	}
	
	private void deleteTextCommon(int length) {
		if (!this.hasSelection()) {
			this.selectCursor = class_3532.method_15340(this.cursor + length, 0, this.value.length());
		}
	}
	
	public int getCursorPos() {
		return this.cursor;
	}
	
	public void setSelected(int begin, int end) {
		this.selectCursor = begin;
		this.cursor = end;
	}
	
	public StringPos getSelected() {
		return new StringPos(Math.min(this.selectCursor, this.cursor), Math.max(this.selectCursor, this.cursor));
	}
	
	public String getSelectedText() {
		var selection = this.getSelected();
		return this.value.substring(selection.beginIndex, selection.endIndex);
	}
	
	public boolean hasSelection() {
		return this.selectCursor != this.cursor;
	}
	
	public int getLineCount() {
		return this.displayLines.size();
	}
	
	public boolean hasMaxLength() {
		return this.maxLength != Integer.MAX_VALUE;
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		boolean inBounds = this.inBounds(mouseX, mouseY);
		if (inBounds && button == class_3675.field_32000) {
			this.selecting = class_437.method_25442();
			this.seekCursorScreen(mouseX, mouseY);
			return true;
		} else {
			final int xMin = this.method_46426() + this.field_22758 - this.scrollbarPadding;
			final int xMax = xMin + Math.max(this.scrollBarWidth(), this.scrollbarPadding);
			final int yMin = this.method_46427();
			final int yMax = this.method_46427() + this.field_22759;
			boolean clickedScrollbar = this.scrollBarVisible() && mouseX >= xMin && mouseX <= xMax && mouseY >= yMin && mouseY < yMax;
			if (clickedScrollbar && button == class_3675.field_32000) {
				this.scrolling = true;
				return true;
			} else return inBounds || clickedScrollbar;
		}
	}
	
	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
		if (this.method_37303() && this.method_25370() && this.scrolling) {
			final int scrollSnapEdge = this.innerPadding() - this.theme.borderThickness;
			if (mouseY < this.method_46427() + scrollSnapEdge) {
				this.setScrollAmount(0);
			} else if (mouseY > this.method_46427() + this.field_22759 - scrollSnapEdge) {
				this.setScrollAmount(this.getMaxScrollAmount());
			} else {
				double scrollMod = Math.max(1, this.getMaxScrollAmount() / (this.field_22759 - this.totalVerticalPadding() - this.getScrollBarHeight()));
				this.setScrollAmount(this.scrollAmount + dragY * scrollMod);
			}
			return true;
		} else if (this.inBounds(mouseX, mouseY) && button == class_3675.field_32000) {
			this.selecting = true;
			this.seekCursorScreen(mouseX, mouseY);
			this.selecting = class_437.method_25442();
			return true;
		}
		return false;
	}
	
	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (button == class_3675.field_32000) {
			this.scrolling = false;
		}
		return super.method_25406(mouseX, mouseY, button);
	}
	
	@Override
	public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
		if (!this.method_37303()) return false;
		this.setScrollAmount(this.scrollAmount - scrollY * SCROLL_RATE);
		return true;
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (!this.method_37303()) return false;
		this.selecting = class_437.method_25442();
		if (keyCode != class_3675.field_31932 && keyCode != class_3675.field_31982) {
			if (this.activeWidget != null) {
				if (this.activeWidget.keyPressed(keyCode, scanCode, modifiers)) return true;
			}
		}
		if (class_437.method_25439(keyCode)) {
			this.cursor = this.value.length();
			this.selectCursor = 0;
			return true;
		} else if (class_437.method_25438(keyCode)) {
			class_310 mc = class_310.method_1551();
			mc.field_1774.method_1455(this.getSelectedText());
			return true;
		} else if (class_437.method_25436(keyCode)) {
			class_310 mc = class_310.method_1551();
			mc.field_1774.method_1455(this.getSelectedText());
			this.insertTextInternal("");
			return true;
		} else if (class_437.method_25437(keyCode)) {
			class_310 mc = class_310.method_1551();
			this.insertTextInternal(mc.field_1774.method_1460());
			return true;
		} else {
			switch (keyCode) {
			case class_3675.field_31957:
			case class_3675.field_31980:
				this.insertTextInternal("\n");
				return true;
			case class_3675.field_31986:
				if (class_437.method_25441()) {
					var pos = this.getPreviousWord();
					this.deleteTextInternal(pos.beginIndex - this.cursor);
				} else {
					this.deleteTextInternal(-1);
				}
				return true;
			case class_3675.field_31987:
				if (class_437.method_25441()) {
					var pos = this.getNextWord();
					this.deleteTextInternal(pos.beginIndex - this.cursor);
				} else {
					this.deleteTextInternal(1);
				}
				return true;
			case class_3675.field_31984:
				if (class_437.method_25441()) {
					var pos = this.getNextWord();
					this.seekCursor(class_7533.field_39535, pos.beginIndex);
				} else {
					this.seekCursor(class_7533.field_39536, 1);
				}
				return true;
			case class_3675.field_31983:
				if (class_437.method_25441()) {
					var pos = this.getPreviousWord();
					this.seekCursor(class_7533.field_39535, pos.beginIndex);
				} else {
					this.seekCursor(class_7533.field_39536, -1);
				}
				return true;
			case class_3675.field_31982:
				if (!class_437.method_25441()) {
					this.seekCursorLine(1);
				}
				return true;
			case class_3675.field_31932:
				if (!class_437.method_25441()) {
					this.seekCursorLine(-1);
				}
				return true;
			case class_3675.field_31992:
				this.seekCursor(class_7533.field_39535, 0);
				return true;
			case class_3675.field_31991:
				this.seekCursor(class_7533.field_39537, 0);
				return true;
			case class_3675.field_31989:
				if (class_437.method_25441()) {
					this.seekCursor(class_7533.field_39535, 0);
				} else {
					this.seekCursor(class_7533.field_39535, this.getDisplayLineAt(this.cursor).beginIndex);
				}
				return true;
			case class_3675.field_31988:
				if (class_437.method_25441()) {
					this.seekCursor(class_7533.field_39537, 0);
				} else {
					this.seekCursor(class_7533.field_39535, this.getDisplayLineAt(this.cursor).endIndex);
				}
				return true;
			default:
				return false;
			}
		}
	}
	
	@Override
	public boolean method_25400(char codePoint, int modifiers) {
		if (this.method_37303() && this.method_25370() && class_3544.method_57175(codePoint)) {
			this.insertTextInternal(Character.toString(codePoint));
			return true;
		}
		return false;
	}
	
	@Override
	public void miniMessageTick() {
		if (!this.method_37303() || !this.method_25370()) return;
		if (this.activeWidget != null) {
			this.activeWidget.tick();
		}
	}
	
	@Override
	public boolean miniMessageMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
		if (!this.method_37303() || !this.method_25370()) return false;
		if (this.activeWidget != null) {
			if (this.activeWidget.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) return true;
		}
		return false;
	}
	
	@Override
	public boolean miniMessageMouseClicked(double mouseX, double mouseY, int button) {
		if (!this.method_37303() || !this.method_25370()) return false;
		if (this.activeWidget != null) {
			if (this.activeWidget.mouseClicked(mouseX, mouseY, button)) return true;
		}
		return false;
	}
	
	@Override
	public void miniMessageRender(class_332 gui, int mouseX, int mouseY) {
		if (this.method_37303() && this.method_25370() && this.activeWidget != null) {
			this.activeWidget.renderPreviewOrError(gui);
			this.activeWidget.renderSuggestions(gui, mouseX, mouseY);
			this.activeWidget.renderHover(gui, mouseX, mouseY);
		}
		int y = this.method_46427() + this.innerPadding();
		var formatLine = this.formatLines.get(0);
		int lineCounter = 0;
		for (var line : this.displayLines) {
			if (formatLine.line.endIndex < line.beginIndex) {
				formatLine = this.formatLines.get(++lineCounter);
			}
			if (this.inVerticalBounds(y, y + 9)) {
				formatLine.minimessage.renderFormatHover(gui, mouseX, mouseY, line.beginIndex, line.endIndex);
			}
			y += 9;
		}
	}
	
	public void seekCursor(class_7533 whence, int pos) {
		final var oldLine = this.getFormatLineAt(this.cursor);
		switch (whence) {
		case field_39535:
			this.cursor = pos;
			break;
		case field_39536:
			this.cursor = class_156.method_27761(this.value, this.cursor, pos);
			break;
		case field_39537:
			this.cursor = this.value.length() + pos;
			break;
		}
		this.cursor = class_3532.method_15340(this.cursor, 0, this.value.length());
		this.scrollToCursor();
		final var newLine = this.getFormatLineAt(this.cursor);
		if (oldLine != newLine) {
			oldLine.setActive(oldLine.isActive());
		}
		newLine.cursorMoved();
		if (!this.selecting) {
			this.selectCursor = this.cursor;
		}
	}
	
	public void seekCursorLine(int offset) {
		if (offset != 0) {
			int maxX = this.font.method_1727(this.value.substring(this.getDisplayLineAt(this.cursor).beginIndex, this.cursor)) + 2;
			var cursorLineNum = this.getDisplayLineNumberAt(this.cursor);
			var targetLine = this.getDisplayLineByNumber(cursorLineNum + offset);
			int linePos = this.font.method_27523(this.value.substring(targetLine.beginIndex, targetLine.endIndex), maxX).length();
			this.seekCursor(class_7533.field_39535, targetLine.beginIndex + linePos);
		}
	}
	
	public void seekCursorToPoint(double x, double y) {
		int row = class_3532.method_15357(x);
		int col = class_3532.method_15357(y / 9.0);
		var line = this.getDisplayLineByNumber(col);
		int offset = this.font.method_27523(this.value.substring(line.beginIndex, line.endIndex), row).length();
		this.seekCursor(class_7533.field_39535, line.beginIndex + offset);
	}
	
	@Override
	public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTick) {
		if (this.field_22764) {
			this.renderBackground(gui);
			final int borderThickness = this.theme.borderThickness;
			gui.method_44379(this.method_46426() + borderThickness, this.method_46427() + borderThickness, this.method_46426() + this.field_22758 - borderThickness, this.method_46427() + this.field_22759 - borderThickness);
			gui.method_51448().pushMatrix();
			gui.method_51448().translate(0, (float)(-this.scrollAmount));
			// wrapping this in a try catch to gather more info when it crashes because I don't trust this code
			try {
				this.renderContents(gui, mouseX, mouseY, partialTick);
			} catch (Exception e) {
				BuildersInventory.LOGGER.error("MultiLineMMEditBox.renderContents is about to crash. Printing report.");
				BuildersInventory.LOGGER.error("cursor=" + this.cursor);
				BuildersInventory.LOGGER.error("value=" + this.value);
				throw e;
			}
			gui.method_51448().popMatrix();
			gui.method_44380();
			if (this.scrollBarVisible()) {
				int scrollBarHeight = this.getScrollBarHeight();
				final int x = this.method_46426() + this.field_22758 - this.scrollbarPadding + this.theme.scrollbarPadding;
				final int y = Math.max(
						this.method_46427() + this.innerPadding(),
						this.method_46427() + this.innerPadding() + (int)this.scrollAmount * (this.field_22759 - this.totalVerticalPadding() - scrollBarHeight) / this.getMaxScrollAmount());
				gui.method_52707(class_10799.field_56883, this.theme.spritesScrollbar.method_52729(this.method_37303(), this.method_25370()), x, y, 1, this.theme.scrollbarWidth, scrollBarHeight);
			}
			if (this.hasMaxLength()) {
				int charLimit = this.maxLength;
				class_2561 error = class_2561.method_43469("gui.multiLineEditBox.character_limit", this.value.length(), charLimit);
				gui.method_27535(this.font, error, this.method_46426() + this.field_22758 - this.font.method_27525(error), this.method_46427() + this.field_22759 + 4, 0xA0A0A0);
			}
		}
	}
	
	private void renderBackground(class_332 gui) {
		class_2960 background = this.theme.spritesBackground.method_52729(this.method_37303(), this.method_25370());
		gui.method_52706(class_10799.field_56883, background, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
		final int borderThickness = this.theme.borderThickness;
		if (this.showLineNumbers) gui.method_25294(this.method_46426() + borderThickness, this.method_46427() + borderThickness, this.method_46426() + this.lineNumWidth + borderThickness, this.method_46427() + this.method_25364() - borderThickness, this.theme.lineNumBackgroundColor);
	}
	
	private void renderContents(class_332 gui, int mouseX, int mouseY, float partialTick) {
		String str = this.value;
		if (!str.isEmpty() || this.method_25370()) {
			final int cursor = this.cursor;
			final int textColor = this.method_37303() ? this.theme.textColor : this.theme.disabledTextColor;
			final boolean blink = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L;
			
			int y = this.method_46427() + this.innerPadding();
			var formatLine = this.formatLines.get(0);
			var formatPos = new StringPos(-1, -1);
			int lineCounter = 0;
			for (var line : this.displayLines) {
				final boolean lineVisible = this.inVerticalBounds(y, y + 9);
				
				int x = this.method_46426() + this.leftPadding();
				
				// current format line
				if (formatPos.endIndex < line.beginIndex) {
					formatLine = this.formatLines.get(lineCounter++);
					formatPos = formatLine.line;
					// line numbers
					if (lineVisible && this.showLineNumbers) {
						final String lineNumStr = new StringBuilder().append(lineCounter).append("").toString();
						final int strWidth = this.font.method_1727(lineNumStr);
						gui.method_51433(this.font, lineNumStr, x - strWidth - 4, y, this.theme.lineNumColor, true);
					}
				}
				
				// line contents
				if (lineVisible) {
					final boolean cursorInserting = cursor < line.endIndex;
					
					if (blink && cursorInserting && cursor >= line.beginIndex && cursor <= line.endIndex) {
						final var formatStr1 = this.format(formatLine, str, line.beginIndex, cursor);
						final var formatStr2 = this.format(formatLine, str, cursor, line.endIndex);
						gui.method_35720(this.font, formatStr1, x, y, textColor);
						x += font.method_30880(formatStr1) - 1;
						
						gui.method_35720(this.font, formatStr2, x, y, textColor);
						
						gui.method_25294(x, y, x + 1, y + 9, CURSOR_COLOR);
					} else {
						final var formatStr = this.format(formatLine, str, line.beginIndex, line.endIndex);
						gui.method_35720(this.font, formatStr, x, y, textColor);
						x += font.method_30880(formatStr);
						
						if (!cursorInserting && !this.hasSelection() && cursor >= line.beginIndex && cursor <= line.endIndex && line.endIndex == formatPos.endIndex) {
							if (this.suggestion != null) {
								gui.method_25303(this.font, this.suggestion, x - 1, y, this.theme.suggestionColor);
							}
							
							if (blink) {
								if (this.cursor == line.beginIndex) x -= 1;
								gui.method_25303(this.font, "_", x, y, textColor);
							}
						}
					}
				}
				y += 9;
			}
			
			if (this.hasSelection()) {
				var selection = this.getSelected();
				int xMin = this.method_46426() + this.leftPadding();
				y = this.method_46427() + this.innerPadding();
				
				for (var line : this.displayLines) {
					if (selection.beginIndex > line.endIndex) {
						y += 9;
					} else {
						if (line.beginIndex > selection.endIndex) break;
						if (this.inVerticalBounds(y, y + 9)) {
							int xStart = this.font.method_1727(str.substring(line.beginIndex, Math.max(selection.beginIndex, line.beginIndex)));
							int xEnd;
							if (selection.endIndex > line.endIndex) {
								xEnd = this.field_22758 - this.totalHorizontalPadding();
							} else {
								xEnd = this.font.method_1727(str.substring(line.beginIndex, selection.endIndex));
							}
							
							gui.method_48196(class_10799.field_56881, xMin + xStart, y, xMin + xEnd, y + 9, 0xFF0000FF);
						}
						y += 9;
					}
				}
			}
		} else if (str.isEmpty() && this.showLineNumbers) {
			int x = this.method_46426() + this.leftPadding();
			int y = this.method_46427() + this.innerPadding();
			final String lineNumStr = "1";
			final int strWidth = this.font.method_1727(lineNumStr);
			gui.method_25303(this.font, lineNumStr, x - strWidth - 4, y, this.theme.lineNumColor);
		}
	}
	
	private class_5481 format(FormatLine line, String str, int beginIndex, int endIndex) {
		if (line.minimessage.canFormat()) {
			return line.minimessage.format(beginIndex - line.line.beginIndex, endIndex - line.line.beginIndex);
		} else {
			return class_5481.method_30747(str.substring(beginIndex, endIndex), class_2583.field_24360);
		}
	}
	
	@Override
	protected class_5250 method_25360() {
		return class_2561.method_43469("gui.narrate.editBox", this.method_25369(), this.value);
	}
	
	@Override
	protected void method_47399(class_6382 narrationElementOutput) {
		narrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
	}
	
	private void scrollToCursor() {
		double scroll = this.scrollAmount;
		var currentLine = this.getDisplayLineByNumber((int)(scroll / 9.0));
		if (this.cursor <= currentLine.beginIndex) {
			scroll = this.getDisplayLineNumberAt(this.cursor) * 9;
		} else {
			var line = this.getDisplayLineByNumber((int)((scroll + this.field_22759) / 9.0) - 1);
			if (this.cursor >= line.endIndex) {
				scroll = this.getDisplayLineNumberAt(this.cursor) * 9 - this.field_22759 + 9 + this.totalVerticalPadding();
			}
		}
		
		this.setScrollAmount(scroll);
	}
	
	private double getDisplayableLineCount() {
		return (this.field_22759 - this.totalVerticalPadding()) / 9.0;
	}
	
	private void seekCursorScreen(double mouseX, double mouseY) {
		double x = mouseX - this.method_46426() - this.leftPadding();
		double y = mouseY - this.method_46427() - this.innerPadding() + this.scrollAmount;
		this.seekCursorToPoint(x, y);
	}
	
	public StringPos getPreviousWord() {
		if (this.value.isEmpty()) {
			return StringPos.EMPTY;
		} else {
			int cursor = class_3532.method_15340(this.cursor, 0, this.value.length() - 1);
			
			while (cursor > 0 && Character.isWhitespace(this.value.charAt(cursor - 1))) cursor--;
			while (cursor > 0 && !Character.isWhitespace(this.value.charAt(cursor - 1))) cursor--;
			
			return new StringPos(cursor, this.getWordEndPosition(cursor));
		}
	}
	
	public StringPos getNextWord() {
		if (this.value.isEmpty()) {
			return StringPos.EMPTY;
		} else {
			int cursor = class_3532.method_15340(this.cursor, 0, this.value.length() - 1);
			
			while (cursor < this.value.length() && Character.isWhitespace(this.value.charAt(cursor))) cursor++;
			while (cursor < this.value.length() && !Character.isWhitespace(this.value.charAt(cursor))) cursor++;
			
			return new StringPos(cursor, this.getWordEndPosition(cursor));
		}
	}
	
	private int getWordEndPosition(int cursor) {
		while (cursor < this.value.length() && !Character.isWhitespace(this.value.charAt(cursor))) cursor++;
		return cursor;
	}
	
	private void reflowDisplayLines() {
		this.displayLines.clear();
		if (this.value.isEmpty()) {
			this.displayLines.add(StringPos.EMPTY);
		} else {
			this.font.method_27527().method_27485(
					this.value,
					this.getInnerWidth(),
					class_2583.field_24360,
					false,
					(style, start, end) -> this.displayLines.add(new StringPos(start, end)));
			if (this.value.charAt(this.value.length() - 1) == '\n') {
				this.displayLines.add(new StringPos(this.value.length(), this.value.length()));
			}
		}
		this.refreshScrollbar();
	}
	
	private ArrayList<FormatLine> refreshFormatLines() {
		final var initLines = new ArrayList<FormatLine>();
		
		this.linesResetListener.run();
		this.formatLines.clear();
		final String value = this.value;
		if (value.isEmpty()) {
			var line = formatLine(StringPos.EMPTY, initLines.size());
			this.formatLines.add(line);
			initLines.add(line);
		} else {
			int i = 0;
			int start = 0;
			boolean endsOnNewline = false;
			while (i < value.length()) {
				if (value.charAt(i) == '\n') {
					var line = formatLine(new StringPos(start, i), initLines.size());
					this.formatLines.add(line);
					initLines.add(line);
					start = ++i;
					endsOnNewline = true;
					continue;
				}
				endsOnNewline = false;
				i++;
			}
			if (endsOnNewline || start < i) {
				var line = formatLine(new StringPos(start, i), initLines.size());
				this.formatLines.add(line);
				initLines.add(line);
			}
		}
		this.refreshLineNumWidth();
		
		return initLines;
	}
	
	private ArrayList<FormatLine> refreshFormatRange(int beginIndex, int endIndexOld, int endIndexNew) {
		final var initLines = new ArrayList<FormatLine>();
		// find first line to replace
		int lineNum = 0;
		while (lineNum < this.formatLines.size()) {
			var line = this.formatLines.get(lineNum).line;
			if (beginIndex >= line.beginIndex && beginIndex <= line.endIndex) break;
			lineNum++;
		}
//		if (lineNum >= this.formatLines.size()) lineNum = this.formatLines.size() - 1;
		
		// count lines being replaced
		int targets = 0;
		while (lineNum + targets < this.formatLines.size()) {
			var line = this.formatLines.get(lineNum + targets).line;
			targets++;
			if (line.endIndex >= endIndexOld) break;
		}
//		if (lineNum + targets >= this.formatLines.size()) targets = this.formatLines.size() - lineNum - 1;
		
		// determine new lines
		ArrayList<StringPos> newLines = new ArrayList<>();
		final int beginLineIndex = this.formatLines.get(lineNum).line.beginIndex;
//		final int endLineIndex = this.formatLines.get(lineNum + targets - 1).line.endIndex;
		{
			final String value = this.value;
			int i = beginLineIndex;
			int start = i;
			boolean endsOnNewline = false;
			boolean breakAtNextLine = false;
			while (i < value.length()) {
				if (i >= endIndexNew) {
					endsOnNewline = false;
					breakAtNextLine = true;
				}
				if (value.charAt(i) == '\n') {
					newLines.add(new StringPos(start, i));
					start = ++i;
					if (breakAtNextLine) break;
					endsOnNewline = true;
					continue;
				}
				endsOnNewline = false;
				i++;
			}
			if (endsOnNewline || start < i) {
				newLines.add(new StringPos(start, i));
			}
		}
		if (newLines.isEmpty()) {
			newLines.add(new StringPos(beginIndex, endIndexNew));
		}
		
		// add lines to fit list size
		if (newLines.size() < targets) {
			// delete excess targets
			int i = targets;
			while (i > newLines.size()) { // while loop works better than for loop here
				final int deleteIndex = lineNum + --i;
				this.lineDeleteListener.accept(deleteIndex);
				this.formatLines.remove(deleteIndex);
			}
			targets = newLines.size();
		} else { // newLines.size() >= targets
			// add excess new lines
			for (int i = targets; i < newLines.size(); i++) {
				final int createIndex = lineNum + i;
				var line = formatLine(newLines.get(i), createIndex);
				this.formatLines.add(createIndex, line);
				initLines.add(line);
			}
		}
		
		// replace lines
		for (int i = 0; i < targets; i++) {
			var line = this.formatLines.get(lineNum + i);
			line.line = newLines.get(i);
			initLines.add(line);
		}
		
		// shift all lines after
		final int lineShift = endIndexNew - endIndexOld;
		final int lineIndexShift = newLines.size() - targets;
		for (int i = lineNum + newLines.size(); i < this.formatLines.size(); i++) {
			var line = this.formatLines.get(i);
			line.line = line.line.shift(lineShift);
			line.lineIndex += lineIndexShift;
		}
		
		// refresh line number offset
		this.refreshLineNumWidth();
		
		// return
		return initLines;
	}
	
	private void refreshLineNumWidth() {
		if (this.showLineNumbers) {
			final int maxDigits = (int)(Math.log10(this.formatLines.size()) + 1);
			this.lineNumWidth = (6 * maxDigits) + 3;
		} else {
			this.lineNumWidth = 0;
		}
	}
	
	private StringPos getDisplayLineAt(int pos) {
		int lineCounter = 0;
		int lineCounterEnd = -1;
		for (int i = 0; i < this.displayLines.size(); i++) {
			var line = this.displayLines.get(i);
			if (lineCounterEnd < line.beginIndex) {
				lineCounterEnd = this.formatLines.get(lineCounter++).line.endIndex;
			}
			final var lineEndIndex = line.endIndex;
			if (pos >= line.beginIndex && (pos < lineEndIndex || (pos == lineEndIndex && lineEndIndex == lineCounterEnd))) {
				return line;
			}
		}
		return this.displayLines.get(this.displayLines.size() - 1);
	}
	
	private int getDisplayLineNumberAt(int pos) {
		int lineCounter = 0;
		int lineCounterEnd = -1;
		for (int i = 0; i < this.displayLines.size(); i++) {
			var line = this.displayLines.get(i);
			if (lineCounterEnd < line.beginIndex) {
				lineCounterEnd = this.formatLines.get(lineCounter++).line.endIndex;
			}
			final var lineEndIndex = line.endIndex;
			if (pos >= line.beginIndex && (pos < lineEndIndex || (pos == lineEndIndex && lineEndIndex == lineCounterEnd))) {
				return i;
			}
		}
		return this.displayLines.size() - 1;
	}
	
	private StringPos getDisplayLineByNumber(int line) {
		return this.displayLines.get(class_3532.method_15340(line, 0, this.displayLines.size() - 1));
	}
	
	private FormatLine getFormatLineAt(int pos) {
		for (int i = 0; i < this.formatLines.size(); i++) {
			var line = this.formatLines.get(i);
			if (pos >= line.line.beginIndex && pos <= line.line.endIndex) return line;
		}
		return this.formatLines.get(this.formatLines.size() - 1);
	}
	
//	private int getFormatLineNumberAt(int pos) {
//		for (int i = 0; i < this.formatLines.size(); i++) {
//			var line = this.formatLines.get(i).line;
//			if (pos >= line.beginIndex && pos <= line.endIndex) return i;
//		}
//		return this.formatLines.size() - 1;
//	}
//	
//	private FormattedLine getFormatLineByNumber(int line) {
//		return this.formatLines.get(Mth.clamp(line, 0, this.formatLines.size() - 1));
//	}
	
	@Override
	public void method_25365(boolean focused) {
		if (focused) {
			for (var line : this.formatLines) line.setActive(true);
		} else {
			for (var line : this.formatLines) line.setActive(false);
		}
		super.method_25365(focused);
		if (focused) this.focusedTime = class_156.method_658();
	}
	
	protected boolean inVerticalBounds(int top, int bottom) {
		return bottom - this.scrollAmount >= this.method_46427() + this.innerPadding() && top - this.scrollAmount <= this.method_46427() + this.field_22759 - this.innerPadding();
	}
	
	protected boolean inBounds(double x, double y) {
		return x >= this.method_46426() && x < this.method_46426() + this.field_22758 - this.scrollbarPadding && y >= this.method_46427() && y < this.method_46427() + this.method_25364();
	}
	
	public int innerPadding() {
		return this.theme.innerPadding;
	}
	
	public int leftPadding() {
		return this.innerPadding() + this.lineNumWidth;
	}
	
	public int rightPadding() {
		return this.rightPadding;
	}
	
	public int totalHorizontalPadding() {
		return this.leftPadding() + this.rightPadding();
	}
	
	public int totalVerticalPadding() {
		return innerPadding() * 2;
	}
	
	public double scrollAmount() {
		return this.scrollAmount;
	}
	
	public void setScrollAmount(double scroll) {
		this.scrollAmount = class_3532.method_15350(scroll, 0.0, this.getMaxScrollAmount());
	}
	
	private int getScrollBarHeight() {
		return this.scrollbarHeight;
	}
	
	private void refreshScrollbar() {
		if (this.externalScrollbar) {
			this.scrollbarPadding = 0;
			this.rightPadding = this.innerPadding();
		} else {
			this.scrollbarPadding = this.theme.scrollbarWidth + this.theme.scrollbarPadding * 2;
			if (this.theme.scrollbarPadding < this.theme.borderThickness) this.scrollbarPadding += this.theme.borderThickness - this.theme.scrollbarPadding;
			this.rightPadding = this.scrollbarPadding;
		}
		final int scrollbarEdgeHeight = this.theme.scrollbarEdgeHeight;
		final int scrollbarScale = this.theme.scrollbarScale;
		final int innerViewHeight = this.field_22759 - this.totalVerticalPadding();
		final int minScrollbarHeight = Math.max(class_3532.method_38788(innerViewHeight, 6), scrollbarEdgeHeight + scrollbarScale);
		int scrollbarHeight = (int)((innerViewHeight * innerViewHeight) / (float)this.getInnerHeight());
		scrollbarHeight = class_3532.method_15340(scrollbarHeight, minScrollbarHeight, this.field_22759 - this.totalVerticalPadding() - 1);
		scrollbarHeight = Math.round((float)(scrollbarHeight - scrollbarEdgeHeight) / scrollbarScale) * scrollbarScale;
		if (scrollbarHeight < minScrollbarHeight - scrollbarEdgeHeight) scrollbarHeight += scrollbarScale;
		if (scrollbarHeight > this.field_22759 - this.totalVerticalPadding() - Math.max(scrollbarEdgeHeight, 1)) scrollbarHeight -= scrollbarScale;
		this.scrollbarHeight = scrollbarHeight + scrollbarEdgeHeight;
	}
	
	public int getMaxScrollAmount() {
		return Math.max(0, this.getInnerHeight() + this.totalVerticalPadding() - this.field_22759);
	}
	
	public boolean scrollBarVisible() {
		return this.getLineCount() > this.getDisplayableLineCount();
	}
	
	public int scrollBarWidth() {
		return this.theme.scrollbarWidth + this.theme.scrollbarPadding * 2;
	}
	
	public int getInnerWidth() {
		return this.field_22758 - this.totalHorizontalPadding();
	}
	
	public int getInnerHeight() {
		return 9 * this.getLineCount();
	}
	
	@FunctionalInterface
	public static interface FormatLineConsumer {
		public static final FormatLineConsumer IGNORE = (line, lastParse) -> {};
		public void onParseChange(int line, @Nullable MiniMessageResult lastParse);
	}
	
	private FormatLine formatLine(StringPos line, int lineIndex) {
		this.lineCreateListener.accept(lineIndex);
		return new FormatLine(this, line, lineIndex);
	}
	
	private static class FormatLine implements WrappedTextField, LastParseListener {
		
		private final MultiLineMMEditBox input;
		private final MiniMessageInstance minimessage;
		
		private StringPos line;
		private int lineIndex;
		
		public FormatLine(MultiLineMMEditBox input, StringPos line, int lineIndex) {
			this.input = input;
			this.line = line;
			this.lineIndex = lineIndex;
			this.minimessage = input.mmConstructor.construct(this, this);
		}
		
		@Override
		public void onParseChange(@Nullable MiniMessageResult lastParse) {
			this.input.lineEditListener.onParseChange(this.lineIndex, lastParse);
		}
		
		public boolean isActive() {
			return input.cursor >= line.beginIndex && input.cursor <= line.endIndex;
		}
		
//		public void updateActive() {
//			boolean active = this.isActive();
//			this.widget.setActiveNoUpdate(active);
//		}
		
//		public void unknownEdit() {
//			this.updateActive();
//			this.widget.unknownEdit();
//		}
		
		public void cursorMoved() {
			boolean active = this.isActive();
			this.minimessage.setActive(active);
			if (active) {
				this.input.activeWidget = this.minimessage;
				this.minimessage.cursorMoved();
			} else {
				this.input.suggestion = null;
			}
		}
		
//		public void inputEdited() {
//			this.updateActive();
//			this.widget.inputEdited();
//		}
		
		public void initUpdate() {
			boolean active = this.isActive();
			this.minimessage.setActive(active);
			if (active) {
				this.input.activeWidget = this.minimessage;
				this.minimessage.unknownEdit();
			} else {
				this.minimessage.quietUpdate();
			}
		}
		
		public void setActive(boolean active) {
			this.minimessage.setActive(active);
			if (active) {
				this.input.activeWidget = this.minimessage;
				this.minimessage.unknownEdit();
			} else {
				this.input.suggestion = null;
			}
		}
		
		@Override
		public String getValue() {
			return this.input.getText(this.line);
		}
		
		@Override
		public void setValue(String str) {
			this.input.setSelected(line.beginIndex, line.endIndex);
			this.input.insertTextInternal(str);
		}
		
		@Override
		public void setSuggestion(@Nullable String str) {
			this.input.suggestion = str;
		}
		
		@Override
		public int getCursorPosition() {
			return this.input.cursor - this.line.beginIndex;
		}
		
		@Override
		public void setCursorPosition(int pos) {
			this.input.selecting = false;
			this.input.seekCursor(class_7533.field_39535, pos + this.line.beginIndex);
		}
		
		@Override
		public void setHighlightPos(int pos) {
			this.input.selectCursor = pos + this.line.beginIndex;
		}
		
		@Override
		public int getTextX() {
			return this.input.method_46426() + this.input.leftPadding();
		}
		
		@Override
		public int getScreenX(int charNum) {
			final String value = this.getValue();
			if (charNum > value.length()) {
				return this.getTextX();
			} else {
				final int endPos = this.line.beginIndex + charNum;
				final var dispLine = this.input.getDisplayLineAt(endPos);
				final String lineText = this.input.value.substring(dispLine.beginIndex, endPos);
				return this.getTextX() + this.input.font.method_1727(lineText);
			}
		}
		
		@Override
		public int getY() {
			return this.input.method_46427();
		}
		
		@Override
		public int getTextY(int pos) {
			final int lineNum = this.input.getDisplayLineNumberAt(pos);
			return this.input.method_46427() + this.input.innerPadding() + (lineNum * 9) - (int)this.input.scrollAmount;
		}
		
		@Override
		public int getInnerWidth() {
			return this.input.getInnerWidth();
		}
		
		@Override
		public int getHeight() {
			return this.input.method_25364();
		}
		
		@Override
		public int getLineHeight() {
			return 9;
		}
		
	}
	
}
