/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.feature.extended_inventory;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.config.Config;
import _3650.builders_inventory.datafixer.ModDataFixer;
import _3650.builders_inventory.feature.extended_inventory.ExtendedInventory;
import _3650.builders_inventory.feature.extended_inventory.ExtendedInventoryPage;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import org.apache.commons.lang3.tuple.Pair;

public class ExtendedInventoryPages {
    private static final String FILE_PREFIX = "inventory-";
    private static final String FILE_SUFFIX = "-page.nbt";
    private static final ArrayBlockingQueue<class_2561> PLAYER_MESSAGE_QUEUE = new ArrayBlockingQueue(50);
    private static final ArrayList<ExtendedInventoryPage> PAGES = new ArrayList();
    private static int deleted = 0;
    private static boolean loaded = false;
    private static boolean valid = false;
    private static int timeToSave = 0;
    private static boolean hasChanged = false;
    private static boolean forceUpdate = false;

    static void tick(class_310 mc) {
        if (hasChanged && --timeToSave <= 0) {
            ExtendedInventoryPages.save();
        }
        if (!PLAYER_MESSAGE_QUEUE.isEmpty() && mc.field_1724 != null) {
            ArrayList messages = new ArrayList();
            PLAYER_MESSAGE_QUEUE.drainTo(messages);
            for (class_2561 msg : messages) {
                mc.field_1724.method_7353(msg, false);
            }
        }
    }

    public static void setChanged() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return;
        }
        hasChanged = true;
        timeToSave = Config.instance().extended_inventory_save_delay * 20;
    }

    static void forceUpdate() {
        forceUpdate = true;
    }

    public static void load() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            ExtendedInventoryPages.load((class_6903<class_2520>)mc.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560));
        } else if (mc.method_1562() != null) {
            ExtendedInventoryPages.load((class_6903<class_2520>)mc.method_1562().method_29091().method_57093((DynamicOps)class_2509.field_11560));
        } else {
            BuildersInventory.LOGGER.error("Error loading extended inventory saved data: Not in-game!");
            PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.load_failed"));
        }
    }

    public static void load(class_6903<class_2520> registryOps) {
        BuildersInventory.LOGGER.info("Loading Extended Inventory...");
        BuildersInventory.LOGGER.info("Hey Log Readers: LOGS ARE ZERO-INDEXED");
        if (loaded && valid && hasChanged) {
            BuildersInventory.LOGGER.info("Must save extended inventory before reloading");
            if (ExtendedInventoryPages.save(registryOps)) {
                BuildersInventory.LOGGER.info("Saved");
            } else {
                BuildersInventory.LOGGER.error("Error loading extended inventory saved data: Could not save first!");
                PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.load_failed"));
                return;
            }
        }
        loaded = true;
        valid = false;
        PAGES.clear();
        ExtendedInventory.PAGE_CONTAINER.reset();
        Path root = FabricLoader.getInstance().getGameDir().resolve("builders_inventory").resolve("extended_inventory");
        try {
            String[] filenames;
            Path oldRoot;
            if (!Files.isDirectory(root, new LinkOption[0]) && Files.isDirectory(oldRoot = FabricLoader.getInstance().getConfigDir().resolve("builders_inventory"), new LinkOption[0])) {
                root = oldRoot;
                forceUpdate = true;
            }
            if ((filenames = root.toFile().list((dir, name) -> name.startsWith(FILE_PREFIX) && name.endsWith(FILE_SUFFIX))) == null) {
                filenames = new String[]{};
            }
            int substrStart = FILE_PREFIX.length();
            int substrEnd = FILE_SUFFIX.length();
            int max = -1;
            Int2ObjectOpenHashMap pageMap = new Int2ObjectOpenHashMap(filenames.length);
            for (String name2 : filenames) {
                String idStr = name2.substring(substrStart, name2.length() - substrEnd);
                try {
                    int id = Integer.parseInt(idStr) - 1;
                    Optional<ExtendedInventoryPage> optPage = ExtendedInventoryPages.loadPage(registryOps, root.resolve(name2), id);
                    if (!optPage.isPresent()) continue;
                    if (id > max) {
                        max = id;
                    }
                    pageMap.put(id, (Object)optPage.get());
                }
                catch (NumberFormatException e) {
                    BuildersInventory.LOGGER.error("Error loading extended inventory page " + idStr + ": Invalid Integer!", (Throwable)e);
                }
            }
            for (int i = 0; i < max + 1; ++i) {
                if (pageMap.containsKey(i)) {
                    PAGES.add((ExtendedInventoryPage)pageMap.get(i));
                    continue;
                }
                BuildersInventory.LOGGER.warn("Could not find extended inventory page {}", (Object)i);
                PAGES.add(ExtendedInventoryPage.INVALID);
            }
            BuildersInventory.LOGGER.info("Loaded {} extended inventory pages...", (Object)PAGES.size());
            valid = true;
            if (PAGES.isEmpty()) {
                ExtendedInventoryPages.create();
            }
            if (Files.isRegularFile(root.resolve("inventory-data.nbt"), new LinkOption[0])) {
                class_2487 tag = class_2507.method_10633((Path)root.resolve("inventory-data.nbt"));
                if (tag == null) {
                    BuildersInventory.LOGGER.error("Error loading extended inventory saved data: Invalid Data!");
                }
                if (tag.method_10573("page", 3)) {
                    int savedPage = tag.method_10550("page");
                    if (savedPage >= 0 && savedPage < PAGES.size()) {
                        ExtendedInventory.PAGE_CONTAINER.setPage(savedPage);
                        BuildersInventory.LOGGER.info("Loaded selected page as {}...", (Object)savedPage);
                    } else if (savedPage >= 0 && PAGES.size() > 0) {
                        int newPage = Math.max(0, PAGES.size() - 1);
                        ExtendedInventory.PAGE_CONTAINER.setPage(newPage);
                        BuildersInventory.LOGGER.warn("Loaded page out of bounds {}, switched to page {}", (Object)savedPage, (Object)newPage);
                    } else {
                        BuildersInventory.LOGGER.error("Failed to load invalid selected page {}...", (Object)savedPage);
                    }
                }
            }
            if (ExtendedInventory.getPage() < 0) {
                BuildersInventory.LOGGER.info("No page selected! Selecting first page...");
                ExtendedInventory.PAGE_CONTAINER.setPage(0);
            }
            if (forceUpdate) {
                BuildersInventory.LOGGER.info("Pages have been migrated from an older version, saving...");
                hasChanged = true;
                for (ExtendedInventoryPage page : PAGES) {
                    page.discreteChange();
                }
                deleted = 0;
                if (!ExtendedInventoryPages.save(registryOps)) {
                    BuildersInventory.LOGGER.error("Could not save migrated pages!");
                }
                BuildersInventory.LOGGER.info("Saved migrated data!");
                forceUpdate = false;
            }
        }
        catch (Exception e) {
            BuildersInventory.LOGGER.error("Error loading extended inventory pages!", (Throwable)e);
            PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.load_failed").method_27692(class_124.field_1061));
        }
    }

    public static Optional<ExtendedInventoryPage> loadPage(class_6903<class_2520> registryOps, Path path, int id) throws Exception {
        class_2487 tag = class_2507.method_10633((Path)path);
        Optional<class_2487> datafix = ModDataFixer.extendedInventoryPage(tag, 1);
        if (datafix.isPresent()) {
            tag = datafix.get();
        }
        if (tag == null || !tag.method_10573("items", 9)) {
            BuildersInventory.LOGGER.error("Error loading extended inventory page {} tag {}: Invalid Data!", (Object)id, (Object)tag);
            return Optional.empty();
        }
        class_2499 itemTags = tag.method_10554("items", 10);
        if (itemTags == null || itemTags.isEmpty()) {
            BuildersInventory.LOGGER.error("Error loading extended inventory page {} items {}: Invalid Data!", (Object)id, (Object)itemTags);
            return Optional.empty();
        }
        List<class_1799> items = itemTags.stream().map(itemTag -> class_1799.field_49266.parse((DynamicOps)registryOps, itemTag).resultOrPartial(err -> BuildersInventory.LOGGER.error("Could not parse extended inventory item: '{}'", err)).orElse(class_1799.field_8037)).collect(Collectors.toList());
        boolean locked = false;
        if (tag.method_10573("locked", 1)) {
            locked = tag.method_10577("locked");
        }
        String name = "";
        if (tag.method_10573("name", 8)) {
            name = tag.method_10558("name");
        }
        class_1799 icon = class_1799.field_8037;
        if (tag.method_10573("icon", 10)) {
            class_2487 iconTag = tag.method_10562("icon");
            icon = class_1799.field_49266.parse(registryOps, (Object)iconTag).resultOrPartial(err -> BuildersInventory.LOGGER.error("Could not parse extended inventory icon {}: '{}'", (Object)iconTag, err)).orElse(class_1799.field_8037);
        }
        class_1799 originalIcon = class_1799.field_8037;
        if (tag.method_10573("original_icon", 10)) {
            class_2487 iconTag = tag.method_10562("original_icon");
            icon = class_1799.field_49266.parse(registryOps, (Object)iconTag).resultOrPartial(err -> BuildersInventory.LOGGER.error("Could not parse extended inventory original icon {}: '{}'", (Object)iconTag, err)).orElse(class_1799.field_8037);
        }
        boolean iconDataActive = false;
        if (tag.method_10573("icon_data", 1)) {
            iconDataActive = tag.method_10577("icon_data");
        }
        int iconScaleDown = 0;
        if (tag.method_10573("icon_scale_down", 3)) {
            iconScaleDown = tag.method_10550("icon_scale_down");
        }
        ExtendedInventoryPage page = ExtendedInventoryPage.of(items, locked, name, icon, originalIcon, iconDataActive, iconScaleDown);
        if (datafix.isPresent()) {
            forceUpdate = true;
            page.discreteChange();
        }
        return Optional.of(page);
    }

    public static boolean save() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            return ExtendedInventoryPages.save((class_6903<class_2520>)mc.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560));
        }
        if (mc.method_1562() != null) {
            return ExtendedInventoryPages.save((class_6903<class_2520>)mc.method_1562().method_29091().method_57093((DynamicOps)class_2509.field_11560));
        }
        BuildersInventory.LOGGER.error("Error saving extended inventory saved data: Not in-game!");
        PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.save_failed"));
        return false;
    }

    public static boolean save(class_6903<class_2520> registryOps) {
        BuildersInventory.LOGGER.info("Saving Extended Inventory...");
        if (!hasChanged) {
            BuildersInventory.LOGGER.info("Nothing to save.");
            return false;
        }
        BuildersInventory.LOGGER.info("Hey Log Readers: LOGS ARE ZERO-INDEXED");
        timeToSave = 0;
        hasChanged = false;
        if (!loaded) {
            return false;
        }
        if (!valid) {
            BuildersInventory.LOGGER.error("Refusing to save pages; pages failed to load!");
            return false;
        }
        Path root = FabricLoader.getInstance().getGameDir().resolve("builders_inventory").resolve("extended_inventory");
        try {
            ArrayList<Pair> storeFiles = new ArrayList<Pair>(PAGES.size());
            ArrayList<Path> deleteFiles = new ArrayList<Path>();
            for (int i = 0; i < PAGES.size(); ++i) {
                ExtendedInventoryPage page = PAGES.get(i);
                if (!page.valid || !page.resetChanged()) continue;
                class_2487 pageTag = ExtendedInventoryPages.writeTag(registryOps, page);
                storeFiles.add(Pair.of((Object)pageTag, (Object)root.resolve(FILE_PREFIX + (i + 1) + FILE_SUFFIX)));
            }
            if (deleted > 0) {
                int deleteMax = PAGES.size() + deleted;
                for (int i = PAGES.size(); i < deleteMax; ++i) {
                    deleteFiles.add(root.resolve(FILE_PREFIX + (i + 1) + FILE_SUFFIX));
                }
                deleted = 0;
            }
            if (!Files.isDirectory(root, new LinkOption[0])) {
                try {
                    Files.createDirectories(root, new FileAttribute[0]);
                }
                catch (IOException e) {
                    BuildersInventory.LOGGER.error("Error saving extended inventory pages!", (Throwable)e);
                    PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.save_failed").method_27692(class_124.field_1061));
                    return false;
                }
            }
            if (storeFiles.size() > 0 || deleteFiles.size() > 0) {
                class_156.method_27958().execute(() -> {
                    int i;
                    int counter = 0;
                    int failCounter = 0;
                    for (i = 0; i < storeFiles.size(); ++i) {
                        Pair pair = (Pair)storeFiles.get(i);
                        try {
                            class_2507.method_10630((class_2487)((class_2487)pair.getLeft()), (Path)((Path)pair.getRight()));
                            ++counter;
                            continue;
                        }
                        catch (Exception e) {
                            ++failCounter;
                            BuildersInventory.LOGGER.error("Error saving extended inventory page " + i + "!", (Throwable)e);
                            PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43469((String)"error.builders_inventory.extended_inventory.save_failed.page", (Object[])new Object[]{i + 1}).method_27692(class_124.field_1061));
                        }
                    }
                    BuildersInventory.LOGGER.info("Saved {} modified pages!", (Object)counter);
                    if (failCounter > 0) {
                        BuildersInventory.LOGGER.error("Also failed to save {} modified pages...", (Object)counter);
                    }
                    counter = 0;
                    failCounter = 0;
                    for (i = 0; i < deleteFiles.size(); ++i) {
                        Path path = (Path)deleteFiles.get(i);
                        try {
                            if (!Files.deleteIfExists(path)) continue;
                            ++counter;
                            continue;
                        }
                        catch (Exception e) {
                            ++failCounter;
                            BuildersInventory.LOGGER.error("Error deleting extended inventory file " + path.toString() + "!", (Throwable)e);
                            PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43469((String)"error.builders_inventory.extended_inventory.delete_failed", (Object[])new Object[]{i + 1}).method_27692(class_124.field_1061));
                        }
                    }
                    BuildersInventory.LOGGER.info("Deleted {} old pages!", (Object)counter);
                    if (failCounter > 0) {
                        BuildersInventory.LOGGER.error("Also failed to delete {} old pages...", (Object)counter);
                    }
                });
            } else {
                BuildersInventory.LOGGER.info("No pages needed to be saved.");
            }
            if (ExtendedInventory.getPage() >= 0) {
                class_2487 tag = new class_2487();
                tag.method_10569("version", 2);
                tag.method_10569("page", ExtendedInventory.getPage());
                class_2507.method_10630((class_2487)tag, (Path)root.resolve("inventory-data.nbt"));
                BuildersInventory.LOGGER.info("Saved extended inventory extra data!");
            }
        }
        catch (Exception e) {
            BuildersInventory.LOGGER.error("Error saving extended inventory pages!", (Throwable)e);
            PLAYER_MESSAGE_QUEUE.add((class_2561)class_2561.method_43471((String)"error.builders_inventory.extended_inventory.save_failed").method_27692(class_124.field_1061));
            return false;
        }
        return true;
    }

    public static class_2487 writeTag(class_6903<class_2520> registryOps, ExtendedInventoryPage page) {
        Optional result;
        class_2487 tag = new class_2487();
        class_2512.method_48310((class_2487)tag);
        tag.method_10569("version", 2);
        tag.method_10566("items", (class_2520)page.streamItems().map(stack -> (class_2520)class_1799.field_49266.encodeStart((DynamicOps)registryOps, stack).resultOrPartial().orElse(new class_2487())).collect(Collectors.toCollection(class_2499::new)));
        tag.method_10556("locked", page.isLocked());
        if (!page.getName().isBlank()) {
            tag.method_10582("name", page.getName());
        }
        if (!page.icon.method_7960() && (result = class_1799.field_49266.encodeStart((DynamicOps)class_2509.field_11560, (Object)page.icon).resultOrPartial()).isPresent()) {
            tag.method_10566("icon", (class_2520)result.get());
            tag.method_10556("icon_data", page.iconDataActive);
            tag.method_10569("icon_scale_down", page.iconScaleDown);
        }
        if (!page.originalIcon.method_7960() && (result = class_1799.field_49266.encodeStart((DynamicOps)class_2509.field_11560, (Object)page.icon).resultOrPartial()).isPresent()) {
            tag.method_10566("original_icon", (class_2520)result.get());
        }
        return tag;
    }

    public static ExtendedInventoryPage get(int i) {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = PAGES.get(i);
        return page != null ? page : ExtendedInventoryPage.INVALID;
    }

    public static ExtendedInventoryPage create() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = new ExtendedInventoryPage();
        page.setChanged();
        page.setLocked(false);
        PAGES.add(page);
        if (deleted > 0) {
            --deleted;
        }
        return page;
    }

    public static ExtendedInventoryPage reset(int n) {
        if (!loaded) {
            BuildersInventory.LOGGER.warn("Resetting page {} before pages were even loaded... I don't think that's meant to happen.", (Object)n);
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return ExtendedInventoryPage.INVALID;
        }
        if (n >= PAGES.size()) {
            BuildersInventory.LOGGER.error("Tried to reset page {}, but the index was out of bounds!", (Object)n);
            return ExtendedInventoryPage.INVALID;
        }
        ExtendedInventoryPage page = new ExtendedInventoryPage();
        page.setChanged();
        page.setLocked(false);
        PAGES.set(n, page);
        return page;
    }

    public static void delete(int n) {
        if (!loaded) {
            BuildersInventory.LOGGER.warn("Deleting page {} before pages were even loaded... I don't think that's meant to happen.", (Object)n);
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return;
        }
        if (n > PAGES.size()) {
            BuildersInventory.LOGGER.error("Tried to delete page {}, but the index was out of bounds!", (Object)n);
            return;
        }
        PAGES.remove(n);
        ++deleted;
        if (PAGES.size() <= 0) {
            ExtendedInventoryPages.create();
        }
        for (int i = n; i < PAGES.size(); ++i) {
            PAGES.get(i).setChanged();
        }
        ExtendedInventoryPages.setChanged();
    }

    public static boolean contains(int i) {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return false;
        }
        return i < PAGES.size();
    }

    public static int size() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        if (!valid) {
            return 1;
        }
        return PAGES.size();
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isValid() {
        if (!loaded) {
            ExtendedInventoryPages.load();
        }
        return valid;
    }

    public static void rotatePages(int from, int to, int dist) {
        Collections.rotate(PAGES.subList(from, to), dist);
    }
}

