/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.feature.minimessage;

import _3650.builders_inventory.api.minimessage.MiniMessageParser;
import _3650.builders_inventory.api.minimessage.color.PrideFlagGradients;
import _3650.builders_inventory.api.minimessage.format.ClickFormat;
import _3650.builders_inventory.api.minimessage.format.ColorFormat;
import _3650.builders_inventory.api.minimessage.format.FontFormat;
import _3650.builders_inventory.api.minimessage.format.GradientFormat;
import _3650.builders_inventory.api.minimessage.format.HoverFormat;
import _3650.builders_inventory.api.minimessage.format.InsertionFormat;
import _3650.builders_inventory.api.minimessage.format.InverseStyleFormat;
import _3650.builders_inventory.api.minimessage.format.RainbowFormat;
import _3650.builders_inventory.api.minimessage.format.StyleFormat;
import _3650.builders_inventory.api.minimessage.format.TransitionFormat;
import _3650.builders_inventory.api.minimessage.parser.ArgData;
import _3650.builders_inventory.api.minimessage.parser.InvalidMiniMessage;
import _3650.builders_inventory.api.minimessage.parser.MiniMessageTagOutput;
import _3650.builders_inventory.api.minimessage.parser.MiniMessageTagParser;
import _3650.builders_inventory.api.minimessage.tags.Branch;
import _3650.builders_inventory.api.minimessage.tags.HiddenLiteral;
import _3650.builders_inventory.api.minimessage.tags.Keybind;
import _3650.builders_inventory.api.minimessage.tags.Node;
import _3650.builders_inventory.api.minimessage.tags.TaggedLiteral;
import _3650.builders_inventory.api.minimessage.tags.Translatable;
import _3650.builders_inventory.api.minimessage.tags.TranslatableFallback;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class StandardMiniMessageParser
implements MiniMessageTagParser {
    @Override
    public boolean parseTag(MiniMessageTagOutput output, MiniMessageParser parser, String argString, String name, ArgData args, @Nullable String server) throws InvalidMiniMessage {
        if (name.charAt(0) == '#') {
            try {
                int color = Integer.parseInt(name.substring(1), 16);
                if (color > 0xFFFFFF) {
                    throw StandardMiniMessageParser.invalid("Color %s must be less than #FFFFFF", name);
                }
                output.push(new ColorFormat(argString, name, class_5251.method_27717((int)color)));
                return true;
            }
            catch (NumberFormatException e) {
                if (output == MiniMessageTagOutput.SINK) {
                    return false;
                }
                throw StandardMiniMessageParser.invalid("%s is not a valid hex color", name);
            }
            catch (IndexOutOfBoundsException e) {
                if (output == MiniMessageTagOutput.SINK) {
                    return false;
                }
                throw StandardMiniMessageParser.invalid("Color cannot be empty");
            }
        }
        switch (name.toLowerCase()) {
            case "color": 
            case "colour": 
            case "c": {
                String colName = args.require();
                if (colName.isEmpty()) {
                    if (output == MiniMessageTagOutput.SINK) {
                        return false;
                    }
                    throw StandardMiniMessageParser.invalid("Color name cannot be empty");
                }
                Optional<class_5251> color = MiniMessageParser.parseColor(colName);
                if (color.isEmpty()) {
                    if (output == MiniMessageTagOutput.SINK) {
                        return false;
                    }
                    throw StandardMiniMessageParser.invalid("%s is not a valid color", colName);
                }
                output.push(new ColorFormat(argString, name, color.get()));
                return true;
            }
            case "black": 
            case "dark_blue": 
            case "dark_green": 
            case "dark_aqua": 
            case "dark_red": 
            case "dark_purple": 
            case "gold": 
            case "gray": 
            case "grey": 
            case "dark_gray": 
            case "dark_grey": 
            case "blue": 
            case "green": 
            case "aqua": 
            case "red": 
            case "light_purple": 
            case "yellow": 
            case "white": {
                Optional<class_5251> color = MiniMessageParser.parseColor(name);
                if (color.isEmpty()) {
                    if (output == MiniMessageTagOutput.SINK) {
                        return false;
                    }
                    throw StandardMiniMessageParser.invalid("%s is not a valid color, but should be! Please report this bug!", name);
                }
                output.push(new ColorFormat(argString, name, color.get()));
                return true;
            }
            case "bold": 
            case "b": {
                output.push(new StyleFormat(argString, name, class_124.field_1067));
                return true;
            }
            case "!bold": 
            case "!b": {
                output.push(new InverseStyleFormat(argString, name, class_124.field_1067));
                return true;
            }
            case "italic": 
            case "em": 
            case "i": {
                output.push(new StyleFormat(argString, name, class_124.field_1056));
                return true;
            }
            case "!italic": 
            case "!em": 
            case "!i": {
                output.push(new InverseStyleFormat(argString, name, class_124.field_1056));
                return true;
            }
            case "underlined": 
            case "u": {
                output.push(new StyleFormat(argString, name, class_124.field_1073));
                return true;
            }
            case "!underlined": 
            case "!u": {
                output.push(new InverseStyleFormat(argString, name, class_124.field_1073));
                return true;
            }
            case "strikethrough": 
            case "st": {
                output.push(new StyleFormat(argString, name, class_124.field_1055));
                return true;
            }
            case "!strikethrough": 
            case "!st": {
                output.push(new InverseStyleFormat(argString, name, class_124.field_1055));
                return true;
            }
            case "obfuscated": 
            case "obf": {
                output.push(new StyleFormat(argString, name, class_124.field_1051));
                return true;
            }
            case "!obfuscated": 
            case "!obf": {
                output.push(new InverseStyleFormat(argString, name, class_124.field_1051));
                return true;
            }
            case "reset": {
                if (args.size > 0) {
                    throw new InvalidMiniMessage(String.format("Tag %s does not accept arguments", name));
                }
                while (parser.ctx != parser.root) {
                    Branch b = output.popUnclosed();
                    output.append(b);
                }
                output.append(HiddenLiteral.tag(name));
                return true;
            }
            case "click": {
                String action = args.require();
                String value = MiniMessageParser.quoteArg(args.require());
                String actLower = action.toLowerCase();
                for (class_2558.class_2559 act : class_2558.class_2559.values()) {
                    if (!act.method_15434().equals(actLower) || !act.method_10847()) continue;
                    output.push(new ClickFormat(argString, name, new class_2558(act, value)));
                    return true;
                }
                return false;
            }
            case "hover": {
                String action = args.require();
                switch (action.toLowerCase(Locale.ROOT)) {
                    case "show_text": {
                        String arg = args.require();
                        output.push(new HoverFormat(argString, name, HoverFormat.text(parser.nodeArg(arg))));
                        return true;
                    }
                    case "show_item": {
                        int count;
                        class_2960 id;
                        try {
                            id = class_2960.method_60654((String)MiniMessageParser.quoteArg(args.require()));
                        }
                        catch (class_151 e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid(e.getMessage());
                        }
                        class_1792 item = (class_1792)class_7923.field_41178.method_17966(id).orElseThrow(StandardMiniMessageParser.invalidSup(output, args, "%s is not a valid item ID", id.toString()));
                        if (!args.hasNext()) {
                            output.push(new HoverFormat(argString, name, HoverFormat.item(item, 1, class_9326.field_49588)));
                            return true;
                        }
                        String countArg = args.next();
                        try {
                            count = Integer.parseInt(countArg);
                        }
                        catch (NumberFormatException e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid("%s is not a valid item count", countArg);
                        }
                        if (!args.hasNext()) {
                            output.push(new HoverFormat(argString, name, HoverFormat.item(item, count, class_9326.field_49588)));
                            return true;
                        }
                        String fval = args.peek();
                        if (fval.startsWith("{")) {
                            args.next();
                            output.push(new HoverFormat(argString, name, HoverFormat.item(item, count, class_9326.field_49588)));
                            return true;
                        }
                        if (parser.registryOps.isEmpty()) {
                            throw StandardMiniMessageParser.invalid("Item components need a world open to resolve");
                        }
                        class_9326.class_9327 components = class_9326.method_57841();
                        ReferenceArraySet keys = new ReferenceArraySet();
                        try {
                            while (args.hasNext()) {
                                class_2520 tag;
                                String key = MiniMessageParser.quoteArg(args.next());
                                if (key.isEmpty()) {
                                    if (output == MiniMessageTagOutput.SINK && !args.hasNext()) break;
                                    throw StandardMiniMessageParser.invalid("Cannot have empty component type");
                                }
                                if (key.charAt(0) == '!') {
                                    String rmKey = key.substring(1);
                                    if (rmKey.isEmpty()) {
                                        return false;
                                    }
                                    class_2960 loc = class_2960.method_60654((String)rmKey);
                                    class_9331 type = (class_9331)class_7923.field_49658.method_63535(loc);
                                    if (type == null) {
                                        if (output == MiniMessageTagOutput.SINK && !args.hasNext()) break;
                                        throw StandardMiniMessageParser.invalid("Invalid component type %s", key);
                                    }
                                    if (type.method_57877()) {
                                        throw StandardMiniMessageParser.invalid("Component type %s is client-only", rmKey);
                                    }
                                    if (!keys.add((Object)type)) {
                                        throw StandardMiniMessageParser.invalid("Component %s is already specified in this tag", rmKey);
                                    }
                                    components.method_57853(type);
                                    continue;
                                }
                                class_2960 loc = class_2960.method_60654((String)key);
                                class_9331 type = (class_9331)class_7923.field_49658.method_63535(loc);
                                if (type == null) {
                                    if (output == MiniMessageTagOutput.SINK && !args.hasNext()) break;
                                    throw StandardMiniMessageParser.invalid("Invalid component type %s", key);
                                }
                                if (type.method_57877()) {
                                    throw StandardMiniMessageParser.invalid("Component type %s is client-only", key);
                                }
                                if (!keys.add((Object)type)) {
                                    throw StandardMiniMessageParser.invalid("Component %s is already specified in this tag", key);
                                }
                                String value = args.require();
                                try {
                                    tag = new class_2522(new StringReader(value)).method_10723();
                                }
                                catch (CommandSyntaxException e) {
                                    throw StandardMiniMessageParser.invalid("Invalid component NBT for %s: %s", key, value);
                                }
                                if (parser.parseComponent(type, tag, components)) continue;
                                throw StandardMiniMessageParser.invalid("Invalid component value for %s: %s", key, value);
                            }
                        }
                        catch (class_151 e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid(e.getMessage());
                        }
                        output.push(new HoverFormat(argString, name, HoverFormat.item(item, count, components.method_57852())));
                        return true;
                    }
                    case "show_entity": {
                        UUID uuid;
                        class_2960 id;
                        try {
                            id = class_2960.method_60654((String)MiniMessageParser.quoteArg(args.require()));
                        }
                        catch (class_151 e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid(e.getMessage());
                        }
                        class_1299 type = (class_1299)class_7923.field_41177.method_17966(id).orElseThrow(StandardMiniMessageParser.invalidSup(output, args, "%s is not a valid entity ID", id.toString()));
                        String uuidStr = args.require();
                        try {
                            uuid = UUID.fromString(uuidStr);
                        }
                        catch (IllegalArgumentException e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid("%s is not a valid UUID", uuidStr);
                        }
                        if (!args.hasNext()) {
                            output.push(new HoverFormat(argString, name, HoverFormat.entity(type, uuid)));
                            return true;
                        }
                        output.push(new HoverFormat(argString, name, HoverFormat.entity(type, uuid, parser.nodeArg(args.next()))));
                        return true;
                    }
                }
                if (args.hasNext()) {
                    throw StandardMiniMessageParser.invalid("%s is not a valid hover event", action);
                }
                return false;
            }
            case "key": {
                String key = args.require();
                output.append(new Keybind(argString, key));
                return true;
            }
            case "lang": 
            case "translate": 
            case "tr": {
                String key = args.require();
                if (args.size > 1) {
                    ArrayList<Node> trargs = new ArrayList<Node>(args.size);
                    while (args.hasNext()) {
                        trargs.add(parser.nodeArg(args.next()));
                    }
                    output.append(new Translatable(argString, key, trargs));
                } else {
                    output.append(new Translatable(argString, key, List.of()));
                }
                return true;
            }
            case "lang_or": 
            case "translate_or": 
            case "tr_or": {
                String key = args.require();
                String fallback = args.require();
                if (args.size > 2) {
                    ArrayList<Node> trargs = new ArrayList<Node>(args.size);
                    while (args.hasNext()) {
                        trargs.add(parser.nodeArg(args.next()));
                    }
                    output.append(new TranslatableFallback(argString, key, fallback, trargs));
                } else {
                    output.append(new TranslatableFallback(argString, key, fallback, List.of()));
                }
                return true;
            }
            case "insert": {
                String text = args.require();
                output.push(new InsertionFormat(argString, name, text));
                return true;
            }
            case "rainbow": {
                boolean invert;
                if (args.size == 0) {
                    output.push(new RainbowFormat(argString, name, false, 0));
                    return true;
                }
                String arg = args.next();
                if (arg.isEmpty()) {
                    output.push(new RainbowFormat(argString, name, false, 0));
                    return true;
                }
                boolean bl = invert = arg.charAt(0) == '!';
                if (invert) {
                    arg = arg.substring(1);
                }
                int phase = 0;
                if (arg.length() > 0) {
                    try {
                        phase = Integer.valueOf(arg);
                    }
                    catch (NumberFormatException e) {
                        throw StandardMiniMessageParser.invalid("%s is not a valid number", arg);
                    }
                }
                output.push(new RainbowFormat(argString, name, invert, phase));
                return true;
            }
            case "gradient": {
                ArrayList<class_5251> colors = new ArrayList<class_5251>();
                double phase = 0.0;
                while (args.hasNext()) {
                    String arg = args.next();
                    Optional<class_5251> color = MiniMessageParser.parseColor(arg);
                    if (color.isPresent()) {
                        colors.add(color.get());
                        continue;
                    }
                    if (!args.hasNext()) {
                        try {
                            phase = Double.parseDouble(arg);
                            if (phase < -1.0 || phase > 1.0) {
                                throw StandardMiniMessageParser.invalid("Phase %s must be between -1 and 1 (including those numbers)", phase);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid("%s is not a valid color", arg);
                        }
                    }
                    return false;
                }
                if (colors.size() == 1) {
                    throw StandardMiniMessageParser.invalid("Gradient must have more than 1 color, but only has %s", colors.get(0));
                }
                output.push(new GradientFormat(argString, name, colors, phase));
                return true;
            }
            case "transition": {
                ArrayList<class_5251> colors = new ArrayList<class_5251>();
                double phase = 0.0;
                while (args.hasNext()) {
                    String arg = args.next();
                    Optional<class_5251> color = MiniMessageParser.parseColor(arg);
                    if (color.isPresent()) {
                        colors.add(color.get());
                        continue;
                    }
                    if (!args.hasNext()) {
                        try {
                            phase = Double.parseDouble(arg);
                            if (phase < -1.0 || phase > 1.0) {
                                throw StandardMiniMessageParser.invalid("Phase %s must be between -1 and 1 (including those numbers)", phase);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (output == MiniMessageTagOutput.SINK && !args.hasNext()) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid("%s is not a valid color", arg);
                        }
                    }
                    return false;
                }
                if (colors.size() == 1) {
                    if (output == MiniMessageTagOutput.SINK) {
                        return false;
                    }
                    throw StandardMiniMessageParser.invalid("Transition must have more than 1 color, but only has %s", colors.get(0));
                }
                output.push(new TransitionFormat(argString, name, colors, phase));
                return true;
            }
            case "pride": {
                PrideFlagGradients flag = PrideFlagGradients.pride;
                double phase = 0.0;
                if (args.hasNext()) {
                    String arg = args.next();
                    Optional<PrideFlagGradients> flagQuery = PrideFlagGradients.byName(arg);
                    if (flagQuery.isPresent()) {
                        flag = flagQuery.get();
                    } else if (!arg.isEmpty()) {
                        try {
                            phase = Double.parseDouble(arg);
                            if (phase < -1.0 || phase > 1.0) {
                                throw StandardMiniMessageParser.invalid("Phase %s must be between -1 and 1 (including those numbers)", phase);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (output == MiniMessageTagOutput.SINK) {
                                return false;
                            }
                            throw StandardMiniMessageParser.invalid("%s is not an available pride flag gradient");
                        }
                    }
                }
                output.push(new GradientFormat(argString, name, flag.colors, phase));
                return true;
            }
            case "font": {
                try {
                    if (args.hasNext()) {
                        String arg1 = args.next();
                        if (args.hasNext()) {
                            String arg2 = args.next();
                            class_2960 font = class_2960.method_60655((String)arg1, (String)arg2);
                            output.push(new FontFormat(argString, name, font));
                            return true;
                        }
                        class_2960 font = class_2960.method_60654((String)arg1);
                        output.push(new FontFormat(argString, name, font));
                        return true;
                    }
                }
                catch (class_151 e) {
                    if (output == MiniMessageTagOutput.SINK) {
                        return false;
                    }
                    throw StandardMiniMessageParser.invalid(e.getMessage());
                }
                return false;
            }
            case "newline": 
            case "br": {
                output.append(new TaggedLiteral(argString, "\n"));
                return true;
            }
        }
        return false;
    }

    private static InvalidMiniMessage invalid(String error) {
        return new InvalidMiniMessage(error);
    }

    private static InvalidMiniMessage invalid(String error, Object ... formatArgs) {
        return new InvalidMiniMessage(String.format(error, formatArgs));
    }

    private static Supplier<InvalidMiniMessage> invalidSup() {
        return () -> new InvalidMiniMessage();
    }

    private static Supplier<InvalidMiniMessage> invalidSup(MiniMessageTagOutput output, ArgData args, String error, Object ... formatArgs) {
        String format = String.format(error, formatArgs);
        return output == MiniMessageTagOutput.SINK && !args.hasNext() ? StandardMiniMessageParser.invalidSup() : () -> new InvalidMiniMessage(format);
    }
}

