package _3650.builders_inventory.api.minimessage;

import _3650.builders_inventory.api.minimessage.instance.MiniMessageInstance;
import _3650.builders_inventory.mixin.feature.minimessage.ChatComponentInvoker;
import net.minecraft.class_338;
import net.minecraft.class_342;

public class MiniMessageUtil {
	
	public static final int lerpColor(float phase, int a, int b) {
		final float lphase = Math.min(1f, Math.max(0f, phase));
		final int ar = (a >> 16) & 0xFF;
		final int br = (b >> 16) & 0xFF;
		final int ag = (a >> 8) & 0xFF;
		final int bg = (b >> 8) & 0xFF;
		final int ab = (a >> 0) & 0xFF;
		final int bb = (b >> 0) & 0xFF;
		return
				((Math.round(ar + lphase * (br - ar)) & 0xFF) << 16) |
				((Math.round(ag + lphase * (bg - ag)) & 0xFF) << 8) |
				((Math.round(ab + lphase * (bb - ab)) & 0xFF) << 0);
	}
	
	public static int getLineHeight(class_338 chat) {
		return ((ChatComponentInvoker)chat).callGetLineHeight();
	}
	
	public static void addFormatter(class_342 input, MiniMessageInstance widget) {
		input.method_73210((text, offset) -> widget.canFormat() ? widget.format(offset, offset + text.length()) : null);
	}
	
}
