package _3650.builders_inventory.api.minimessage.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import _3650.builders_inventory.api.minimessage.MiniMessageUtil;
import _3650.builders_inventory.api.minimessage.color.UnsetColorStyle;

public class GradientFormat extends Format {
	
	public final List<class_5251> colors;
	public final float phase;
	public final int size;
	public final int realsize;
	
	private float increment;
	private float ind;
	private boolean overflow;
	
	private int indMin;
	private int indMax;
	private int colMin;
	private int colMax;
	
	public GradientFormat(String argString, String tag, List<class_5251> colors, double phase) {
		super(argString, tag);
		if (colors.isEmpty()) colors = List.of(class_5251.method_27717(0xFFFFFF), class_5251.method_27717(0x000000));
		if (phase < 0) {
			this.colors = new ArrayList<>(colors.size());
			this.phase = 1 + (float)phase;
			for (int i = colors.size() - 1; i >= 0; --i) {
				this.colors.add(colors.get(i));
			}
		} else {
			this.colors = colors;
			this.phase = (float)phase;
		}
		this.size = colors.size() - 1;
		this.realsize = colors.size();
	}
	
	@Override
	public class_5250 format(class_5250 component) {
		int length = component.getString().length() - 1;
		
		increment = (1f / length) * size;
		ind = 0;
		overflow = false;
		
		indMin = -1;
		indMax = -1;
		colMin = 0;
		colMax = 0;
		
		updateAndColor(this.phase * size);
		
		return component.method_10866().method_10973() == null ? formatNode(component) : component;
	}
	
	private class_5250 formatNode(class_2561 component) {
		var contents = component.method_44746();
		var result = class_2561.method_43473();
		
		for (var content : contents) {
			if (content.method_10866().method_10973() == null) {
				var style = new UnsetColorStyle(content.method_10866());
				final StringBuilder text = new StringBuilder();
				content.method_10851().method_27659((str) -> {
					text.append(str);
					return Optional.empty();
				});
				// some of this adapted from adventure's minimessage code
				final int[] holder = new int[1];
				for (final PrimitiveIterator.OfInt it = text.codePoints().iterator(); it.hasNext();) {
					holder[0] = it.nextInt();
					final int color = updateAndColor(ind + increment);
					result.method_10852(class_2561.method_43470(new String(holder, 0, 1))
							.method_27696(style.withColor(color)));
				}
				// this part's pretty original though
				if (!content.method_10855().isEmpty()) {
					var siblings = class_2561.method_43473().method_27696(content.method_10866());
					for (var sibling : content.method_10855()) {
						siblings.method_10852(formatNode(sibling));
					}
					result.method_10852(siblings);
				}
			} else {
				result.method_10852(content);
				updateAndColor(ind + (increment * content.getString().length()));
			}
		}
		
		return result;
	}
	
	private int updateAndColor(float ind) {
		final float prevInd = this.ind;
		final int col = MiniMessageUtil.lerpColor(prevInd - indMin, colMin, colMax);
		if (ind > realsize) {
			ind -= realsize;
			overflow = false;
		}
		this.ind = ind;
		if (!overflow && (ind > indMax || ind < indMin)) {
			if (ind > size) {
				indMin = size;
				indMax = 0;
				overflow = true;
			} else {
				indMin = class_3532.method_15375(ind);
				indMax = class_3532.method_15386(ind);
			}
//			System.out.println("DEBUG " + prevInd + "-" + ind + " TO " + indMin + "-" + indMax);
			colMin = colors.get(indMin).method_27716();
			colMax = colors.get(indMax).method_27716();
		}
		
		return col;
	}
	
}
