package _3650.builders_inventory.api.minimessage.format;

import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import _3650.builders_inventory.api.minimessage.MiniMessageUtil;

public class TransitionFormat extends Format {
	
	public final int color;
	
	public TransitionFormat(String argString, String tag, List<class_5251> colors, double phase) {
		super(argString, tag);
		if (colors.isEmpty()) colors = List.of(class_5251.method_27717(0xFFFFFF), class_5251.method_27717(0x000000));
		this.color = color(colors, (float)phase);
	}
	
	private int color(List<class_5251> colors, float phaseIn) {
		final float phase = (phaseIn < 0 ? -phaseIn : phaseIn) * (colors.size() - 1);
		final int indMin = class_3532.method_15375(phase);
		final int indMax = class_3532.method_15386(phase);
		if (indMin == indMax) return colors.get(indMin).method_27716();
		return MiniMessageUtil.lerpColor(phase - indMin, colors.get(indMin).method_27716(), colors.get(indMax).method_27716());
	}
	
	@Override
	public class_5250 format(class_5250 component) {
		return component.method_54663(this.color);
	}
	
}
