package _3650.builders_inventory.api.widgets.exbutton;

import java.util.ArrayList;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;

public class ExtendedImageButtonGui {
	
	private final ArrayList<AbstractExtendedImageButton> exButtons = new ArrayList<>();
	
	public void init() {
		this.clearWidgets();
	}
	
	public <T extends class_364 & class_4068 & class_6379> void addRenderableWidget(T widget) {
		if (widget instanceof AbstractExtendedImageButton button) this.exButtons.add(button);
	}
	
	public void clearWidgets() {
		this.exButtons.clear();
	}
	
	public boolean renderTooltip(class_327 font, class_332 gui, int mouseX, int mouseY) {
		for (var button : this.exButtons) {
			final var tooltip = button.tooltip();
			if (button.method_37303() && button.method_25367() && !tooltip.isEmpty()) {
				gui.method_51434(font,
						tooltip,
						button.method_49606() ? mouseX : button.getCenterX(),
						button.method_49606() ? mouseY : button.getCenterY());
				return true;
			} else {
				final var disabledTooltip = button.disabledTooltip.get();
				if (button.field_22764 && !button.field_22763 && button.method_25367() && !disabledTooltip.isEmpty()) {
					gui.method_51434(font,
							disabledTooltip,
							button.method_49606() ? mouseX : button.getCenterX(),
							button.method_49606() ? mouseY : button.getCenterY());
					return true;
				}
			}
		}
		return false;
	}
	
}
