package _3650.builders_inventory.api.widgets.exbutton;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_8666;

public class ExtendedImageDualButton extends AbstractExtendedImageButton {
	
	private final class_3414 clickSound1;
	private final class_3414 clickSound2;
	private final class_8666 sprites1;
	private final class_8666 sprites2;
	private final OnPress onPress1;
	private final OnPress onPress2;
	private final List<class_2561> tooltip1;
	private final List<class_2561> tooltip2;
	
	public boolean secondMode = false;
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			class_8666 sprites1, OnPress onPress1,
			class_8666 sprites2, OnPress onPress2
			) {
		this(x, y, width, height,
				List::of,
				null, sprites1, onPress1, List.of(),
				null, sprites2, onPress2, List.of());
	}
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			class_3414 clickSound1, class_8666 sprites1, OnPress onPress1,
			class_3414 clickSound2, class_8666 sprites2, OnPress onPress2
			) {
		this(x, y, width, height,
				List::of,
				clickSound1, sprites1, onPress1, List.of(),
				clickSound2, sprites2, onPress2, List.of());
	}
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			class_8666 sprites1, OnPress onPress1, List<class_2561> tooltip1,
			class_8666 sprites2, OnPress onPress2, List<class_2561> tooltip2
			) {
		this(x, y, width, height,
				List::of,
				null, sprites1, onPress1, tooltip1,
				null, sprites2, onPress2, tooltip2);
	}
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			class_3414 clickSound1, class_8666 sprites1, OnPress onPress1, List<class_2561> tooltip1,
			class_3414 clickSound2, class_8666 sprites2, OnPress onPress2, List<class_2561> tooltip2
			) {
		this(x, y, width, height,
				List::of,
				clickSound1, sprites1, onPress1, tooltip1,
				clickSound2, sprites2, onPress2, tooltip2);
	}
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			Supplier<List<class_2561>> disabledTooltip,
			class_8666 sprites1, OnPress onPress1, List<class_2561> tooltip1,
			class_8666 sprites2, OnPress onPress2, List<class_2561> tooltip2
			) {
		this(x, y, width, height,
				disabledTooltip,
				null, sprites1, onPress1, tooltip1,
				null, sprites2, onPress2, tooltip2);
	}
	
	public ExtendedImageDualButton(int x, int y, int width, int height,
			Supplier<List<class_2561>> disabledTooltip,
			class_3414 clickSound1, class_8666 sprites1, OnPress onPress1, List<class_2561> tooltip1,
			class_3414 clickSound2, class_8666 sprites2, OnPress onPress2, List<class_2561> tooltip2) {
		super(x, y, width, height, disabledTooltip);
		this.clickSound1 = clickSound1;
		this.sprites1 = sprites1;
		this.onPress1 = onPress1;
		this.tooltip1 = tooltip1;
		this.clickSound2 = clickSound2;
		this.sprites2 = sprites2;
		this.onPress2 = onPress2;
		this.tooltip2 = tooltip2;
	}
	
	@Override
	public class_3414 clickSound() {
		return this.secondMode ? this.clickSound2 : this.clickSound1;
	}
	
	@Override
	public class_8666 sprites() {
		return this.secondMode ? this.sprites2 : this.sprites1;
	}
	
	@Override
	public List<class_2561> tooltip() {
		return this.secondMode ? this.tooltip2 : this.tooltip1;
	}
	
	@Override
	public void method_25306(class_11907 input) {
		super.method_25306(input);
		if (this.secondMode) this.onPress2.onPress(this, input);
		else this.onPress1.onPress(this, input);
	}
	
	@FunctionalInterface
	public static interface OnPress {
		public void onPress(ExtendedImageDualButton button, class_11907 input);
	}
	
}
