package _3650.builders_inventory.feature.extended_inventory;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.ModKeybinds;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButton;
import _3650.builders_inventory.config.Config;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_490;
import net.minecraft.class_634;
import net.minecraft.class_8666;

public class ExtendedInventory {
	
	public static final ExtendedInventoryContainer PAGE_CONTAINER = new ExtendedInventoryContainer();
	
	/** Not actually meant to be used to void items it's just meant to do nothing if something does */
	public static final class_1263 VOID_CONTAINER = new class_1263() {
		@Override
		public void method_5448() {}
		@Override
		public boolean method_5443(class_1657 player) {
			return true;
		}
		@Override
		public void method_5447(int slot, class_1799 stack) {
			BuildersInventory.LOGGER.error("Something was put inside the void container ({})", stack);
		}
		@Override
		public void method_5431() {}
		@Override
		public class_1799 method_5441(int slot) {
			return class_1799.field_8037;
		}
		@Override
		public class_1799 method_5434(int slot, int amount) {
			return class_1799.field_8037;
		}
		@Override
		public boolean method_5442() {
			return true;
		}
		@Override
		public class_1799 method_5438(int slot) {
			return class_1799.field_8037;
		}
		@Override
		public int method_5439() {
			return 1;
		}
	};
	
	public static boolean enabled = false;
	
	public static void refresh() {
		enabled = Config.instance().extended_inventory_enabled;
	}
	
	/*
	 * Button Sprites
	 */
	
	private static final class_8666 OPEN_BUTTON_SPRITES = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_open"),
			BuildersInventory.modLoc("extended_inventory/button_open_highlighted"));
	
	/*
	 * Creative Screen Switch Button
	 */
	
	public static ExtendedImageButton createOpenButton(int midX, int midY) {
		return new ExtendedImageButton(midX + 57, midY - 28, 12, 12,
				OPEN_BUTTON_SPRITES,
				ExtendedInventory::onPressOpenButton,
				class_2561.method_43471("container.builders_inventory.extended_inventory.button.open").method_27692(class_124.field_1068));
	}
	
	public static boolean isOpenButtonVisible(class_1761 tab) {
		return enabled && tab.method_47312() == class_1761.class_7916.field_41053;
	}
	
	private static void onPressOpenButton(ExtendedImageButton button, class_11907 input) {
		class_310 mc = class_310.method_1551();
		open(mc);
	}
	
	/*
	 * Page Switching
	 */
	
	public static void switchLeft(ExtendedInventoryScreen screen) {
		int page = getPage() - 1;
		if (page >= 0) setPage(page);
		refreshScreen(screen);
	}
	
	public static void switchRight(ExtendedInventoryScreen screen) {
		int page = getPage() + 1;
		if (page < ExtendedInventoryPages.size()) setPage(page);
		refreshScreen(screen);
	}
	
	public static void createPageAndSwitch(ExtendedInventoryScreen screen) {
		ExtendedInventoryPages.create();
		setPage(ExtendedInventoryPages.size() - 1);
		refreshScreen(screen);
	}
	
	public static void lock(ExtendedInventoryScreen screen) {
		PAGE_CONTAINER.setLocked(true);
		refreshScreen(screen);
	}
	
	public static void unlock(ExtendedInventoryScreen screen) {
		PAGE_CONTAINER.setLocked(false);
		refreshScreen(screen);
	}
	
	public static void refreshScreen(ExtendedInventoryScreen screen) {
		PAGE_CONTAINER.refresh();
		screen.updateButtons();
		screen.updatePageTitle();
	}
	
	public static void setPage(int page) {
		PAGE_CONTAINER.setPage(page);
	}
	
	public static int getPage() {
		return PAGE_CONTAINER.getPage();
	}
	
	public static String getPageName() {
		return PAGE_CONTAINER.getName();
	}
	
	public static String getPageName(int page) {
		return ExtendedInventoryPages.get(page).getName();
	}
	
	public static void setPageName(String name) {
		PAGE_CONTAINER.setName(name);
	}
	
	public static class_2561 pageTitle(int page) {
		if (page < 0) {
			return class_2561.method_43471("container.builders_inventory.extended_inventory.invalid");
		} else if (!ExtendedInventory.PAGE_CONTAINER.isValid()) {
			return class_2561.method_43469("container.builders_inventory.extended_inventory.invalid.page", page + 1);
		} else {
			String pageName = ExtendedInventory.getPageName(page);
			if (pageName.isBlank()) {
				return class_2561.method_43469("container.builders_inventory.extended_inventory.page", page + 1);
			} else {
				return class_2561.method_43469("container.builders_inventory.extended_inventory.page.custom", pageName, page + 1);
			}
		}
	}
	
	/*
	 * Logic
	 */
	
	public static void clientTick(class_310 mc) {
		if (!enabled) return;
		
		ExtendedInventoryPages.tick(mc);
		
		if (mc.field_1755 == null && ModKeybinds.OPEN_EXTENDED_INVENTORY.method_1436() && mc.field_1724 != null && mc.field_1724.method_68878()) {
			open(mc);
		}
	}
	
	public static void onJoinWorld(class_634 handler, PacketSender sender, class_310 mc) {
		if (!enabled) return;
		
		ExtendedInventoryPages.load(handler.method_29091().method_57093(class_2509.field_11560));
	}
	
	public static void onQuitWorld(class_634 handler) {
		if (!enabled) return;
		
		ExtendedInventoryPages.save(handler.method_29091().method_57093(class_2509.field_11560));
	}
	
	/*
	 * Utils
	 */
	
	public static void open(class_310 mc) {
		refresh();
		mc.method_1507(new ExtendedInventoryScreen(mc.field_1724));
	}
	
	public static void close(class_310 mc) {
		mc.method_1507(new class_490(mc.field_1724));
	}
	
	public static void openDeleteScreen(class_310 mc) {
		mc.method_1507(new ExtendedInventoryDeleteScreen(getPage()));
	}
	
	public static void openRenameScreen(class_310 mc) {
		if (PAGE_CONTAINER.isValid()) mc.method_1507(new ExtendedInventoryRenameScreen(getPage()));
	}
	
	public static void openIconSelectScreen(class_310 mc) {
		if (PAGE_CONTAINER.isValid()) mc.method_1507(new ExtendedInventoryIconScreen(getPage()));
	}
	
	public static void openOrganizeScreen(class_310 mc) {
		mc.method_1507(new ExtendedInventoryOrganizeScreen());
	}
	
	public static void swap(class_310 mc, int slot, int hotbar) {
		if (slot < 36) mc.field_1761.method_2906(mc.field_1724.field_7498.field_7763, slot, hotbar, class_1713.field_7791, mc.field_1724);
		else {
			// bad code do not use it (depends on creative inventory listener and technically less efficient)
//			mc.player.getInventory().setItem(
//					hotbar,
//					PAGE_CONTAINER.swapItem(
//							slot - 36,
//							mc.player.getInventory().removeItemNoUpdate(hotbar)));
//			mc.player.inventoryMenu.broadcastChanges();
			
			class_1799 swapItem = PAGE_CONTAINER.swapItem(slot - 36, mc.field_1724.method_31548().method_5438(hotbar));
			int swapSlot = hotbar == class_1723.field_30812 ? class_1723.field_30812 : hotbar + class_1723.field_30810;
			mc.field_1724.field_7498.method_7611(swapSlot).method_7673(swapItem);
			mc.field_1761.method_2909(swapItem, swapSlot);
		}
	}
	
	public static class_1799 getItem(class_310 mc, int slot) {
		return slot < 36 ? mc.field_1724.method_31548().method_5438(slot) : PAGE_CONTAINER.method_5438(slot - 36);
	}
	
}
