package _3650.builders_inventory.feature.extended_inventory;

import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ExtendedInventoryMenu extends class_1703 {
	
	public final class_1735 destroyItemSlot;
	
	private final class_1723 inventoryMenu;
	
	protected ExtendedInventoryMenu(int containerId, class_1723 playerInv) {
		super(null, containerId);
		this.inventoryMenu = playerInv;
		
		// Actual Slots
		for (int row = 0; row < 6; row++) {
			int y = 18 + row * 18;
			for (int col = 0; col < 9; col++) {
				int x = 26 + col * 18;
				
				this.method_7621(new ExtendedInventorySlot(ExtendedInventory.PAGE_CONTAINER, col + (row * 9), x, y));
			}
		}
		
		// Creative Slots
		for (int i = 0; i < playerInv.field_7761.size(); i++) {
			if (i < 9 || i >= 45) continue;
			
			int j = i - 9;
			
			int x = 26 + (j % 9) * 18;
			int y = i < 36 ? (140 + (j / 9) * 18) : 198;
			
			this.method_7621(new WrappedSlot(playerInv.field_7761.get(i), i, x, y));
		}
		this.method_7621(destroyItemSlot = new class_1735(ExtendedInventory.VOID_CONTAINER, 0, 190, 198));
	}
	
	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 stack = class_1799.field_8037;
		class_1735 slot = this.field_7761.get(index);
		if (slot != null && slot.method_7681() && slot != this.destroyItemSlot) {
			class_1799 target = slot.method_7677();
			stack = target.method_7972();
			if (index < 54) {
				if (!this.method_7616(target, 54, this.field_7761.size() - 1, true)) {
					return class_1799.field_8037;
				}
			} else if (!this.method_7616(target, 0, 54, false)) {
				return class_1799.field_8037;
			}
			
			if (target.method_7960()) {
				slot.method_53512(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		
		return stack;
	}
	
	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
	
	@Override
	public class_1799 method_34255() {
		return this.inventoryMenu.method_34255();
	}
	
	@Override
	public void method_34254(class_1799 stack) {
		this.inventoryMenu.method_34254(stack);
	}
	
	@Override
	public boolean method_7615(class_1735 slot) {
		return slot != this.destroyItemSlot && (!(slot instanceof ExtendedInventorySlot es) || es.exContainer.canModify());
	}
	
	@Override
	public void method_7619(int slotId, int stateId, class_1799 stack) {
		if (slotId >= 9 && slotId < 45) {
			this.inventoryMenu.method_7619(slotId, stateId, stack);
//			this.inventoryMenu.broadcastChanges();
		}
	}
	
	/** Basically just {@linkplain net.minecraft.class_481.class_484 CreativeModeInventoryScreen$SlotWrapper} */
	protected static class WrappedSlot extends class_1735 {
		
		public final class_1735 target;
		
		public WrappedSlot(class_1735 target, int slot, int x, int y) {
			super(target.field_7871, slot, x, y);
			this.target = target;
		}
		
		@Override
		public void method_7667(class_1657 player, class_1799 stack) {
			this.target.method_7667(player, stack);
		}
		
		@Override
		public boolean method_7680(class_1799 stack) {
			return this.target.method_7680(stack);
		}
		
		@Override
		public class_1799 method_7677() {
			return this.target.method_7677();
		}
		
		@Override
		public boolean method_7681() {
			return this.target.method_7681();
		}
		
		@Override
		public void method_48931(class_1799 newStack, class_1799 oldStack) {
			this.target.method_48931(newStack, oldStack);
		}
		
		@Override
		public void method_7673(class_1799 stack) {
			this.target.method_7673(stack);
		}
		
		@Override
		public void method_7668() {
			this.target.method_7668();
		}
		
		@Override
		public int method_7676(class_1799 stack) {
			return this.target.method_7676(stack);
		}
		
		@Override
		public class_2960 method_7679() {
			return super.method_7679();
		}
		
//		@Nullable
//		@Override
//		public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
//			return this.target.getNoItemIcon();
//		}
		
		@Override
		public class_1799 method_7671(int amount) {
			return this.target.method_7671(amount);
		}
		
		@Override
		public boolean method_7682() {
			return this.target.method_7682();
		}
		
		@Override
		public boolean method_7674(class_1657 player) {
			return this.target.method_7674(player);
		}
		
		@Override
		public boolean method_32754(class_1657 player) {
			return this.target.method_32754(player);
		}
		
	}
	
	public static class ExtendedInventorySlot extends class_1735 {
		
		public final ExtendedInventoryContainer exContainer;
		
		public ExtendedInventorySlot(ExtendedInventoryContainer container, int slot, int x, int y) {
			super(container, slot, x, y);
			this.exContainer = container;
		}
		
		@Override
		public boolean method_7674(class_1657 player) {
			return this.exContainer.isValid() && (this.method_7677().method_7960() || this.method_7677().method_45435(player.method_73183().method_45162()));
		}
		
		@Override
		public boolean method_7680(class_1799 stack) {
			return this.exContainer.isValid();
		}
		
	}
	
}
