package _3650.builders_inventory.feature.extended_inventory;

import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_478;
import net.minecraft.class_6379;
import net.minecraft.class_8666;
import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.ModKeybinds;
import _3650.builders_inventory.api.util.GuiUtil;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButton;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButtonGui;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageDualButton;
import _3650.builders_inventory.config.Config;

public class ExtendedInventoryScreen extends class_465<ExtendedInventoryMenu> {
	
	public static final class_2960 BACKGROUND = BuildersInventory.modLoc("textures/gui/container/extended_inventory/inventory.png");
	public static final class_2960 BACKGROUND_LOCKED = BuildersInventory.modLoc("textures/gui/container/extended_inventory/inventory_locked.png");
	public static final class_2960 BACKGROUND_INVALID = BuildersInventory.modLoc("textures/gui/container/extended_inventory/inventory_invalid.png");
	
	private static final class_8666 SPRITES_BUTTON_REPAIR = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_repair"),
			BuildersInventory.modLoc("extended_inventory/button_repair_highlighted"));
	private static final class_8666 SPRITES_BUTTON_ORGANIZE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_organize"),
			BuildersInventory.modLoc("extended_inventory/button_organize_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_organize_highlighted"));
	private static final class_8666 SPRITES_BUTTON_DELETE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_delete"),
			BuildersInventory.modLoc("extended_inventory/button_delete_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_delete_highlighted"));
	private static final class_8666 SPRITES_BUTTON_ICON = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_icon"),
			BuildersInventory.modLoc("extended_inventory/button_icon_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_icon_highlighted"));
	private static final class_8666 SPRITES_BUTTON_RENAME = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_rename"),
			BuildersInventory.modLoc("extended_inventory/button_rename_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_rename_highlighted"));
	private static final class_8666 SPRITES_BUTTON_UNLOCKED = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_lock_unlocked"),
			BuildersInventory.modLoc("extended_inventory/button_lock_unlocked_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_lock_unlocked_highlighted"));
	private static final class_8666 SPRITES_BUTTON_LOCKED = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_lock_locked"),
			BuildersInventory.modLoc("extended_inventory/button_lock_locked_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_lock_locked_highlighted"));
	private static final class_8666 SPRITES_BUTTON_LEFT = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_switch_left"),
			BuildersInventory.modLoc("extended_inventory/button_switch_left_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_switch_left_highlighted"));
	private static final class_8666 SPRITES_BUTTON_RIGHT = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_switch_right"),
			BuildersInventory.modLoc("extended_inventory/button_switch_right_disabled"),
			BuildersInventory.modLoc("extended_inventory/button_switch_right_highlighted"));
	private static final class_8666 SPRITES_BUTTON_RIGHT_NEW = new class_8666(
			BuildersInventory.modLoc("extended_inventory/button_switch_right_new"),
			BuildersInventory.modLoc("extended_inventory/button_switch_right_new_highlighted"));
	
	private final ExtendedImageButtonGui exGui = new ExtendedImageButtonGui();
	
	private class_478 listener;
	
	// Top Buttons
	private ExtendedImageButton buttonRepair;
	// Toolbar Buttons
	private ExtendedImageButton buttonOrganize;
	private ExtendedImageButton buttonDelete;
	private ExtendedImageButton buttonIcon;
	private ExtendedImageButton buttonRename;
	private ExtendedImageDualButton buttonLock;
	// Switch Buttons
	private ExtendedImageButton buttonLeft;
	private ExtendedImageDualButton buttonRight;
	
	private class_2561 pageTitle;
	
	public ExtendedInventoryScreen(class_1657 player) {
		super(new ExtendedInventoryMenu(0, player.field_7498), player.method_31548(), class_2561.method_43471("container.builders_inventory.extended_inventory"));
		player.field_7512 = this.field_2797;
		this.field_2792 = 212;
		this.field_2779 = 222;
		this.field_25267 += 18;
		this.field_25269 += 18;
		this.field_25270 = this.field_2779 - 94;
		this.pageTitle = this.field_22785;
		this.createAllButtons();
	}
	
	@Override
	protected void method_25426() {
		if (this.field_22787.field_1724 != null && this.field_22787.field_1724.method_68878()) {
			super.method_25426();
			
			//ExGUI
			this.exGui.init();
			
			// Listener
			this.field_22787.field_1724.field_7498.method_7603(this.listener);
			this.listener = new class_478(this.field_22787);
			this.field_22787.field_1724.field_7498.method_7596(this.listener);
			
			// Create Buttons
			this.createAllButtons();
			// Top 
			this.method_37063(this.buttonRepair);
			// Toolbar Buttons
			this.method_37063(this.buttonOrganize);
			this.method_37063(this.buttonDelete);
			this.method_37063(this.buttonIcon);
			this.method_37063(this.buttonRename);
			this.method_37063(this.buttonLock);
			// Switch Buttons
			this.method_37063(this.buttonLeft);
			this.method_37063(this.buttonRight);
			
			// Page Title
			this.updatePageTitle();
		} else {
			ExtendedInventory.close(this.field_22787);
		}
	}
	
	@Override
	public void method_25432() {
		super.method_25432();
		if (this.field_22787.field_1724 != null && this.field_22787.field_1724.method_31548() != null) {
			this.field_22787.field_1724.field_7498.method_7603(this.listener);
		}
	}
	
	private void createAllButtons() {
		// Top Buttons
		this.buttonRepair = new ExtendedImageButton(this.field_2776 + 192, this.field_2800 + 4, 12, 12,
				SPRITES_BUTTON_REPAIR,
				(button, input) -> {
					int page = ExtendedInventory.getPage();
					ExtendedInventoryPages.reset(page);
					ExtendedInventory.setPage(page);
					ExtendedInventory.refreshScreen(this);
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.repair").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.repair.warn").method_27692(class_124.field_1061));
		
		// Toolbar Buttons
		this.buttonOrganize = new ExtendedImageButton(this.field_2776 + 172, this.field_2800 + 126, 12, 12,
				SPRITES_BUTTON_ORGANIZE,
				(button, input) -> ExtendedInventory.openOrganizeScreen(this.field_22787),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.organize").method_27692(class_124.field_1068));
		this.buttonDelete = new ExtendedImageButton(this.field_2776 + 154, this.field_2800 + 126, 12, 12,
				SPRITES_BUTTON_DELETE,
				(button, input) -> ExtendedInventory.openDeleteScreen(this.field_22787),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.delete").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.delete.desc").method_27692(class_124.field_1080));
		this.buttonIcon = new ExtendedImageButton(this.field_2776 + 136, this.field_2800 + 126, 12, 12,
				SPRITES_BUTTON_ICON,
				(button, input) -> ExtendedInventory.openIconSelectScreen(this.field_22787),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.icon").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.icon.desc").method_27692(class_124.field_1080));
		this.buttonRename = new ExtendedImageButton(this.field_2776 + 118, this.field_2800 + 126, 12, 12,
				SPRITES_BUTTON_RENAME,
				(button, input) -> ExtendedInventory.openRenameScreen(this.field_22787),
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.rename").method_27692(class_124.field_1068));
		this.buttonLock = new ExtendedImageDualButton(this.field_2776 + 100, this.field_2800 + 126, 12, 12,
				class_3417.field_23199,
				SPRITES_BUTTON_UNLOCKED,
				(button, input) -> ExtendedInventory.lock(this),
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.lock").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.lock.desc.1").method_27692(class_124.field_1080),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.lock.desc.2").method_27692(class_124.field_1080)),
				class_3417.field_15082,
				SPRITES_BUTTON_LOCKED,
				(button, input) -> ExtendedInventory.unlock(this),
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.unlock").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.unlock.desc").method_27692(class_124.field_1080))
				);
		
		// Switch Buttons
		this.buttonLeft = new ExtendedImageButton(this.field_2776 + 6, this.field_2800 + 17, 16, 108,
				SPRITES_BUTTON_LEFT,
				(button, input) -> {
					ExtendedInventory.switchLeft(this);
					this.updatePageTitle();
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.left").method_27692(class_124.field_1068));
		this.buttonRight = new ExtendedImageDualButton(this.field_2776 + 190, this.field_2800 + 17, 16, 108,
				SPRITES_BUTTON_RIGHT,
				(button, input) -> {
					ExtendedInventory.switchRight(this);
					this.updatePageTitle();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.right").method_27692(class_124.field_1068)),
				SPRITES_BUTTON_RIGHT_NEW,
				(button, input) -> {
					ExtendedInventory.createPageAndSwitch(this);
					this.updatePageTitle();
					this.method_48267();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.right").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.button.right_new").method_27692(class_124.field_1060))
				);
		
		updateButtons();
	}
	
	public void updateButtons() {
		// Reused Data
		boolean validPage = ExtendedInventory.PAGE_CONTAINER.isValid();
		boolean lockedPage = ExtendedInventory.PAGE_CONTAINER.isLocked();
		
		if (ExtendedInventoryPages.isValid()) {
			// Top Buttons
			this.buttonRepair.field_22764 = !validPage;
			// Toolbar Buttons
			this.buttonDelete.field_22763 = true;
			this.buttonIcon.field_22763 = validPage;
			this.buttonRename.field_22763 = validPage;
			this.buttonLock.secondMode = lockedPage;
			// Switch Buttons
			int page = ExtendedInventory.getPage();
			this.buttonLeft.field_22763 = page > 0;
			this.buttonRight.secondMode = page >= ExtendedInventoryPages.size() - 1;
			if (this.buttonRight.secondMode) this.method_48267();
		} else {
			// Top Buttons
			this.buttonRepair.field_22764 = false;
			// Toolbar Buttons
			this.buttonDelete.field_22763 = false;
			this.buttonIcon.field_22763 = false;
			this.buttonRename.field_22763 = false;
			this.buttonLock.field_22763 = false;
			this.buttonLock.secondMode = lockedPage;
			// Switch Buttons
			this.buttonLeft.field_22763 = false;
			this.buttonRight.field_22763 = false;
			this.buttonRight.secondMode = false;
		}
	}
	
	public void updatePageTitle() {
		this.pageTitle = ExtendedInventory.pageTitle(ExtendedInventory.getPage());
	}
	
	@Override
	protected <T extends class_364 & class_4068 & class_6379> T method_37063(T widget) {
		this.exGui.addRenderableWidget(widget);
		return super.method_37063(widget);
	}
	
	@Override
	protected void method_37067() {
		this.exGui.clearWidgets();
		super.method_37067();
	}
	
	@Override
	public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTick) {
		super.method_25394(gui, mouseX, mouseY, partialTick);
		this.method_2380(gui, mouseX, mouseY);
	}
	
	@Override
	protected void method_2380(class_332 gui, int mouseX, int mouseY) {
		if (this.field_2787 instanceof ExtendedInventoryMenu.ExtendedInventorySlot slot) {
			if (!ExtendedInventoryPages.isValid()) {
				gui.method_51434(this.field_22793, List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.failed_load.title").method_27692(class_124.field_1061),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.failed_load.desc.1").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.failed_load.desc.2").method_27692(class_124.field_1068)
					), mouseX, mouseY);
				return;
			}
			
			if (!slot.exContainer.isValid()) {
				gui.method_51434(this.field_22793, List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.invalid_page.title").method_27692(class_124.field_1061),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.invalid_page.desc.1").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.invalid_page.desc.2").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.invalid_page.desc.3").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.tooltip.invalid_page.desc.4").method_27692(class_124.field_1068)
					), mouseX, mouseY);
				return;
			}
		}
		
		if (this.exGui.renderTooltip(this.field_22793, gui, mouseX, mouseY)) return;
		
		super.method_2380(gui, mouseX, mouseY);
	}
	
	@Override
	protected void method_2388(class_332 gui, int mouseX, int mouseY) {
		gui.method_51439(this.field_22793, this.pageTitle, this.field_25267, this.field_25268, 0xFF404040, false);
		gui.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0xFF404040, false);
	}
	
	@Override
	protected void method_2389(class_332 gui, float partialTick, int mouseX, int mouseY) {
		int relX = (this.field_22789 - this.field_2792) / 2;
		int relY = (this.field_22790 - this.field_2779) / 2;
		class_2960 bg = ExtendedInventory.PAGE_CONTAINER.isValid() ? ExtendedInventory.PAGE_CONTAINER.isLocked() ? BACKGROUND_LOCKED : BACKGROUND : BACKGROUND_INVALID;
		GuiUtil.blitScreenBackground(gui, bg, relX, relY, this.field_2792, this.field_2779);
	}
	
	@Override
	protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
		type = slotId == -999 && type == class_1713.field_7790 ? class_1713.field_7795 : type;
		if (slot == this.field_2797.destroyItemSlot) {
			var clear = Config.instance().extended_inventory_clear_behavior;
			if (type == class_1713.field_7794 && clear != ExtendedInventoryClearBehavior.NONE) {
				if (clear.player) {
					for (int i = 0; i < this.field_22787.field_1724.field_7498.method_7602().size(); i++) {
						this.field_22787.field_1724.field_7498.method_7611(i).method_7673(class_1799.field_8037);
						this.field_22787.field_1761.method_2909(class_1799.field_8037, i);
					}
					this.field_22787.field_1724.field_7498.method_7623();
				}
				if (clear.extended) {
					ExtendedInventory.PAGE_CONTAINER.method_5448();
				}
			} else {
				this.field_2797.method_34254(class_1799.field_8037);
			}
		} else if (slot != null && !slot.method_7674(this.field_22787.field_1724)) {
			return;
		} else if (ExtendedInventory.PAGE_CONTAINER.isLocked() && slot instanceof ExtendedInventoryMenu.ExtendedInventorySlot && type != class_1713.field_7791) {
			// Slot is guaranteed not null by the instanceof i think
			class_1799 carried = this.field_2797.method_34255();
			class_1799 stack = slot.method_7677();
			
			if (type == class_1713.field_7789) return; // not my problem
			
			if (type == class_1713.field_7791) {
				if (!stack.method_7960()) {
					this.field_22787.field_1724.method_31548().method_5447(mouseButton, stack.method_46651(stack.method_7914()));
					this.field_22787.field_1724.field_7498.method_7623();
				}
				return;
			}
			
			if (type == class_1713.field_7796) {
				if (carried.method_7960() && !stack.method_7960()) {
					this.field_2797.method_34254(stack.method_46651(stack.method_7914()));
				}
				return;
			}
			
			if (type == class_1713.field_7795) {
				if (!stack.method_7960()) {
					class_1799 drop = stack.method_46651(mouseButton == 0 ? 1 : stack.method_7914());
					this.field_22787.field_1724.method_7328(drop, true);
					this.field_22787.field_1761.method_2915(drop);
				}
				return;
			}
			
			if (!carried.method_7960() && !stack.method_7960() && class_1799.method_31577(carried, stack)) {
				if (mouseButton == 0) {
					if (type == class_1713.field_7794) {
						carried.method_7939(carried.method_7914());
					} else if (carried.method_7947() < carried.method_7914()) {
						carried.method_7933(1);
					}
				} else {
					if (type == class_1713.field_7794) {
						this.field_2797.method_34254(class_1799.field_8037);
					} else {
						carried.method_7934(1);
					}
				}
			} else if (carried.method_7960() && !stack.method_7960()) {
				this.field_2797.method_34254(stack.method_46651(type == class_1713.field_7794 ? stack.method_7914() : stack.method_7947()));
			} else if (mouseButton == 0) {
				this.field_2797.method_34254(class_1799.field_8037);
			} else if (!carried.method_7960()) {
				carried.method_7934(1);
			}
		} else if (type == class_1713.field_7789 && slot == null) {
			this.field_22787.field_1724.field_7498.method_7593(slotId, mouseButton, type, this.field_22787.field_1724);
			this.field_2797.method_7593(slotId, mouseButton, type, this.field_22787.field_1724);
			this.field_22787.field_1724.field_7498.method_7623();
		} else if (slot instanceof ExtendedInventoryMenu.WrappedSlot wrappedSlot) {
			this.wrappedSlotClicked(wrappedSlot.target, slotId, mouseButton, type);
		} else if (type == class_1713.field_7795 && slot != null && slot.method_7681()) {
			class_1799 stack = slot.method_7671(mouseButton == 0 ? 1 : slot.method_7677().method_7914());
			this.field_22787.field_1724.method_7328(stack, true);
			this.field_22787.field_1761.method_2915(stack);
		} else if (type == class_1713.field_7795 && !this.field_2797.method_34255().method_7960()) {
			this.field_22787.field_1724.method_7328(this.field_2797.method_34255(), true);
			this.field_22787.field_1761.method_2915(this.field_2797.method_34255());
			this.field_2797.method_34254(class_1799.field_8037);
		} else if (type == class_1713.field_7791) {
			ExtendedInventory.swap(this.field_22787, slotId + 36, mouseButton);
		} else {
			this.field_2797.method_7593(slotId, mouseButton, type, this.field_22787.field_1724);
		}
	}
	
	private void wrappedSlotClicked(class_1735 target, int slotId, int mouseButton, class_1713 type) {
		if (type == class_1713.field_7795 && target != null && target.method_7681()) {
			class_1799 stack = target.method_7671(mouseButton == 0 ? 1 : target.method_7677().method_7914());
			class_1799 remaining = target.method_7677();
			this.field_22787.field_1724.method_7328(stack, true);
			this.field_22787.field_1761.method_2915(stack);
			this.field_22787.field_1761.method_2909(remaining, target.field_7874);
		} else if (type == class_1713.field_7793 || type == class_1713.field_7794) {
			this.field_2797.method_7593(slotId, mouseButton, type, this.field_22787.field_1724);
			this.field_22787.field_1724.field_7498.method_7623();
		} else {
			this.field_22787.field_1724.field_7498.method_7593(target.field_7874, mouseButton, type, this.field_22787.field_1724);
			this.field_22787.field_1724.field_7498.method_7623();
		}
	}
	
	@Override
	public boolean method_25404(class_11908 event) {
		if (ModKeybinds.OPEN_EXTENDED_INVENTORY.method_1417(event)) {
			ExtendedInventory.close(this.field_22787);
			return true;
		} else return super.method_25404(event);
	}
	
	@Override
	protected void method_37432() {
		super.method_37432();
		if (this.field_22787.field_1724 != null && !this.field_22787.field_1724.method_68878()) {
			ExtendedInventory.close(this.field_22787);
		}
	}
	
}
