package _3650.builders_inventory.mixin.feature.minimessage.resource;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_1078;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import com.llamalad7.mixinextras.sugar.Local;

import _3650.builders_inventory.api.minimessage.autocomplete.ReloadableResourceArg;

@Mixin(class_1076.class)
public abstract class LanguageManagerMixin {
	
	@Shadow
	private Map<String, class_1077> languages;
	@Shadow
	private String currentCode;
	
	@Inject(method = "onResourceManagerReload", at = @At("TAIL"))
	private void builders_inventory_captureLanguages(class_3300 resourceManager, CallbackInfo ci, @Local(ordinal = 0) class_1078 lang) {
		ArrayList<String> langKeys = ((ClientLanguageAccessor)lang).getStorage().keySet().stream()
				.sorted()
				.filter(tag -> !tag.startsWith("_")) // I consider _ to be a comment
				.collect(Collectors.toCollection(() -> new ArrayList<>()));
		ReloadableResourceArg.LANG.loadStr(langKeys);
	}
	
}
