/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.widgets.editbox;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.api.minimessage.MiniMessageResult;
import _3650.builders_inventory.api.minimessage.instance.LastParseListener;
import _3650.builders_inventory.api.minimessage.instance.MMInstanceConstructor;
import _3650.builders_inventory.api.minimessage.instance.MiniMessageInstance;
import _3650.builders_inventory.api.minimessage.widgets.MiniMessageEventListener;
import _3650.builders_inventory.api.minimessage.widgets.wrapper.WrappedTextField;
import _3650.builders_inventory.api.util.StringPos;
import _3650.builders_inventory.api.widgets.editbox.EditBoxTheme;
import _3650.builders_inventory.api.widgets.editbox.LinedMMEditBoxListener;
import java.util.ArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7533;
import org.jetbrains.annotations.Nullable;

public class SingleLineMMEditBox
extends class_339
implements MiniMessageEventListener,
LastParseListener {
    private static final int CURSOR_COLOR = -3092272;
    private static final double SCROLL_RATE = 4.5;
    private final EditBoxTheme theme;
    private final class_327 font;
    private final ArrayList<StringPos> displayLines = new ArrayList();
    private final MiniMessageInstance minimessage;
    private int maxLength = Integer.MAX_VALUE;
    @Nullable
    private String suggestion = null;
    private LinedMMEditBoxListener changeListener = LinedMMEditBoxListener.IGNORE;
    private LastParseListener miniMessageListener = LastParseListener.IGNORE;
    private boolean externalScrollbar = false;
    private int scrollbarPadding = 0;
    private int scrollbarHeight = 0;
    private int rightPadding = 0;
    private String value;
    private int cursor;
    private int selectCursor;
    private boolean selecting;
    private double scrollAmount;
    private boolean scrolling;
    private long focusedTime = class_156.method_658();

    public SingleLineMMEditBox(MMInstanceConstructor mmConstructor, EditBoxTheme options, class_327 font, int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.minimessage = mmConstructor.construct(new LocalWTF(this), this);
        this.theme = options;
        this.font = font;
        this.setValue("");
    }

    public void setChangeListener(LinedMMEditBoxListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setMiniMessageListener(LastParseListener miniMessageListener) {
        this.miniMessageListener = miniMessageListener;
    }

    public void setMaxLength(int limit) {
        this.maxLength = limit;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public void setExternalScrollbar(boolean externalScrollbar) {
        this.externalScrollbar = externalScrollbar;
        this.refreshScrollbar();
    }

    public void setValue(String value) {
        this.value = class_3544.method_34963((String)class_3544.method_57177((String)value, (boolean)false), (int)this.maxLength, (boolean)false);
        this.selectCursor = this.cursor = this.value.length();
        this.minimessage.inputEdited();
        this.reflowDisplayLines();
        this.scrollToCursor();
    }

    public String getValue() {
        return this.value;
    }

    public String getText(StringPos pos) {
        return this.value.substring(pos.beginIndex, pos.endIndex);
    }

    public void insertText(String text) {
        if (!text.isEmpty() || this.hasSelection()) {
            StringPos selection = this.getSelected();
            this.insertTextCommon(text, selection);
        }
    }

    protected void insertTextInternal(String text) {
        if (!text.isEmpty() || this.hasSelection()) {
            StringPos selection = this.getSelected();
            String string = this.insertTextCommon(text, selection);
            this.changeListener.onInsert(string, selection.beginIndex, selection.endIndex);
        }
    }

    private String insertTextCommon(String text, StringPos selection) {
        String string = class_3544.method_34963((String)class_3544.method_57177((String)text, (boolean)false), (int)(this.maxLength - this.value.length()), (boolean)false);
        this.value = new StringBuilder(this.value).replace(selection.beginIndex, selection.endIndex, string).toString();
        this.selectCursor = this.cursor = selection.beginIndex + string.length();
        this.reflowDisplayLines();
        this.scrollToCursor();
        this.minimessage.inputEdited();
        return string;
    }

    public void deleteText(int length) {
        this.deleteTextCommon(length);
        this.insertText("");
    }

    protected void deleteTextInternal(int length) {
        this.deleteTextCommon(length);
        this.insertTextInternal("");
    }

    private void deleteTextCommon(int length) {
        if (!this.hasSelection()) {
            this.selectCursor = class_3532.method_15340((int)(this.cursor + length), (int)0, (int)this.value.length());
        }
    }

    @Override
    public void onParseChange(@Nullable MiniMessageResult lastParse) {
        this.miniMessageListener.onParseChange(lastParse);
    }

    public int getCursorPos() {
        return this.cursor;
    }

    public void setSelected(int begin, int end) {
        this.selectCursor = begin;
        this.cursor = end;
    }

    public StringPos getSelected() {
        return new StringPos(Math.min(this.selectCursor, this.cursor), Math.max(this.selectCursor, this.cursor));
    }

    public String getSelectedText() {
        StringPos selection = this.getSelected();
        return this.value.substring(selection.beginIndex, selection.endIndex);
    }

    public boolean hasSelection() {
        return this.selectCursor != this.cursor;
    }

    public int getLineCount() {
        return this.displayLines.size();
    }

    public boolean hasMaxLength() {
        return this.maxLength != Integer.MAX_VALUE;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        boolean clickedScrollbar;
        double mouseY;
        double mouseX = event.comp_4798();
        boolean inBounds = this.inBounds(mouseX, mouseY = event.comp_4799());
        if (inBounds && event.method_74245() == 0) {
            this.selecting = event.method_74239();
            this.seekCursorScreen(mouseX, mouseY);
            return true;
        }
        boolean bl = clickedScrollbar = this.scrollBarVisible() && this.isOverScrollArea(mouseX, mouseY);
        if (clickedScrollbar && event.method_74245() == 0) {
            this.scrolling = true;
            return true;
        }
        return inBounds || clickedScrollbar;
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        double mouseX = event.comp_4798();
        double mouseY = event.comp_4799();
        if (this.method_37303() && this.method_25370() && this.scrolling) {
            int scrollSnapEdge = this.innerPadding() - this.theme.borderThickness;
            if (mouseY < (double)(this.method_46427() + scrollSnapEdge)) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)(this.method_46427() + this.field_22759 - scrollSnapEdge)) {
                this.setScrollAmount(this.getMaxScrollAmount());
            } else {
                double scrollMod = Math.max(1, this.getMaxScrollAmount() / (this.field_22759 - this.totalVerticalPadding() - this.getScrollBarHeight()));
                this.setScrollAmount(this.scrollAmount + dragY * scrollMod);
            }
            return true;
        }
        if (this.inBounds(mouseX, mouseY) && event.method_74245() == 0) {
            this.selecting = true;
            this.seekCursorScreen(mouseX, mouseY);
            this.selecting = event.method_74239();
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() == 0) {
            this.scrolling = false;
        }
        return super.method_25406(event);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.method_37303()) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - scrollY * 4.5);
        return true;
    }

    public boolean method_25404(class_11908 event) {
        if (!this.method_37303()) {
            return false;
        }
        this.selecting = event.method_74239();
        int keyCode = event.comp_4795();
        if (keyCode != 265 && keyCode != 264 && this.minimessage.keyPressed(event)) {
            return true;
        }
        if (event.method_74241()) {
            this.cursor = this.value.length();
            this.selectCursor = 0;
            return true;
        }
        if (event.method_74242()) {
            class_310 mc = class_310.method_1551();
            mc.field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (event.method_74244()) {
            class_310 mc = class_310.method_1551();
            mc.field_1774.method_1455(this.getSelectedText());
            this.insertTextInternal("");
            return true;
        }
        if (event.method_74243()) {
            class_310 mc = class_310.method_1551();
            this.insertTextInternal(mc.field_1774.method_1460());
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                return true;
            }
            case 259: {
                if (event.method_74240()) {
                    StringPos pos = this.getPreviousWord();
                    this.deleteTextInternal(pos.beginIndex - this.cursor);
                } else {
                    this.deleteTextInternal(-1);
                }
                return true;
            }
            case 261: {
                if (event.method_74240()) {
                    StringPos pos = this.getNextWord();
                    this.deleteTextInternal(pos.beginIndex - this.cursor);
                } else {
                    this.deleteTextInternal(1);
                }
                return true;
            }
            case 262: {
                if (event.method_74240()) {
                    StringPos pos = this.getNextWord();
                    this.seekCursor(class_7533.field_39535, pos.beginIndex);
                } else {
                    this.seekCursor(class_7533.field_39536, 1);
                }
                return true;
            }
            case 263: {
                if (event.method_74240()) {
                    StringPos pos = this.getPreviousWord();
                    this.seekCursor(class_7533.field_39535, pos.beginIndex);
                } else {
                    this.seekCursor(class_7533.field_39536, -1);
                }
                return true;
            }
            case 264: {
                if (!event.method_74240()) {
                    this.seekCursorLine(1);
                }
                return true;
            }
            case 265: {
                if (!event.method_74240()) {
                    this.seekCursorLine(-1);
                }
                return true;
            }
            case 266: {
                this.seekCursor(class_7533.field_39535, 0);
                return true;
            }
            case 267: {
                this.seekCursor(class_7533.field_39537, 0);
                return true;
            }
            case 268: {
                if (event.method_74240()) {
                    this.seekCursor(class_7533.field_39535, 0);
                } else {
                    this.seekCursor(class_7533.field_39535, this.getDisplayLineAt((int)this.cursor).beginIndex);
                }
                return true;
            }
            case 269: {
                if (event.method_74240()) {
                    this.seekCursor(class_7533.field_39537, 0);
                } else {
                    this.seekCursor(class_7533.field_39535, this.getDisplayLineAt((int)this.cursor).endIndex);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25400(class_11905 event) {
        if (this.method_37303() && this.method_25370() && event.method_74227()) {
            this.insertTextInternal(event.method_74226());
            return true;
        }
        return false;
    }

    @Override
    public void miniMessageTick() {
        this.minimessage.tick();
    }

    @Override
    public boolean miniMessageMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.method_37303() || !this.method_25370()) {
            return false;
        }
        return this.minimessage.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean miniMessageMouseClicked(class_11909 event) {
        if (!this.method_37303() || !this.method_25370()) {
            return false;
        }
        return this.minimessage.mouseClicked(event);
    }

    @Override
    public void miniMessageRender(class_332 gui, int mouseX, int mouseY) {
        if (this.method_37303() && this.method_25370()) {
            this.minimessage.renderPreviewOrError(gui);
            this.minimessage.renderSuggestions(gui, mouseX, mouseY);
            this.minimessage.renderHover(gui, mouseX, mouseY);
        }
        int y = this.method_46427() + this.innerPadding();
        for (StringPos line : this.displayLines) {
            if (!this.inVerticalBounds(y, y + 9)) continue;
            this.minimessage.renderFormatHover(gui, mouseX, mouseY, line.beginIndex, line.endIndex);
        }
    }

    public void seekCursor(class_7533 whence, int pos) {
        switch (whence) {
            case field_39535: {
                this.cursor = pos;
                break;
            }
            case field_39536: {
                this.cursor = class_156.method_27761((String)this.value, (int)this.cursor, (int)pos);
                break;
            }
            case field_39537: {
                this.cursor = this.value.length() + pos;
            }
        }
        this.cursor = class_3532.method_15340((int)this.cursor, (int)0, (int)this.value.length());
        this.scrollToCursor();
        this.minimessage.cursorMoved();
        if (!this.selecting) {
            this.selectCursor = this.cursor;
        }
    }

    public void seekCursorLine(int offset) {
        if (offset != 0) {
            int maxX = this.font.method_1727(this.value.substring(this.getDisplayLineAt((int)this.cursor).beginIndex, this.cursor)) + 2;
            int cursorLineNum = this.getDisplayLineNumberAt(this.cursor);
            StringPos targetLine = this.getDisplayLineByNumber(cursorLineNum + offset);
            int linePos = this.font.method_27523(this.value.substring(targetLine.beginIndex, targetLine.endIndex), maxX).length();
            this.seekCursor(class_7533.field_39535, targetLine.beginIndex + linePos);
        }
    }

    public void seekCursorToPoint(double x, double y) {
        int row = class_3532.method_15357((double)x);
        int col = class_3532.method_15357((double)(y / 9.0));
        StringPos line = this.getDisplayLineByNumber(col);
        int offset = this.font.method_27523(this.value.substring(line.beginIndex, line.endIndex), row).length();
        this.seekCursor(class_7533.field_39535, line.beginIndex + offset);
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTick) {
        if (this.field_22764) {
            this.renderBackground(gui);
            int borderThickness = this.theme.borderThickness;
            gui.method_44379(this.method_46426() + borderThickness, this.method_46427() + borderThickness, this.method_46426() + this.field_22758 - borderThickness, this.method_46427() + this.field_22759 - borderThickness);
            gui.method_51448().pushMatrix();
            gui.method_51448().translate(0.0f, (float)(-this.scrollAmount));
            try {
                this.renderContents(gui, mouseX, mouseY, partialTick);
            }
            catch (Exception e) {
                BuildersInventory.LOGGER.error("MultiLineMMEditBox.renderContents is about to crash. Printing report.");
                BuildersInventory.LOGGER.error("cursor=" + this.cursor);
                BuildersInventory.LOGGER.error("value=" + this.value);
                throw e;
            }
            gui.method_51448().popMatrix();
            gui.method_44380();
            if (this.method_49606()) {
                gui.method_74037(this.method_37303() ? class_11876.field_62453 : class_11876.field_62459);
            }
            if (this.scrollBarVisible()) {
                int scrollBarHeight = this.getScrollBarHeight();
                int x = this.method_46426() + this.field_22758 - this.scrollbarPadding + this.theme.scrollbarPadding;
                int y = Math.max(this.method_46427() + this.innerPadding(), this.method_46427() + this.innerPadding() + (int)this.scrollAmount * (this.field_22759 - this.totalVerticalPadding() - scrollBarHeight) / this.getMaxScrollAmount());
                gui.method_52707(class_10799.field_56883, this.theme.spritesScrollbar.method_52729(this.method_37303(), this.method_25370()), x, y, 1, this.theme.scrollbarWidth, scrollBarHeight);
                if (this.isOverScrollArea(mouseX, mouseY)) {
                    gui.method_74037(this.scrolling ? class_11876.field_62456 : class_11876.field_62455);
                }
            }
            if (this.hasMaxLength()) {
                int charLimit = this.maxLength;
                class_5250 error = class_2561.method_43469((String)"gui.multiLineEditBox.character_limit", (Object[])new Object[]{this.value.length(), charLimit});
                gui.method_27535(this.font, (class_2561)error, this.method_46426() + this.field_22758 - this.font.method_27525((class_5348)error), this.method_46427() + this.field_22759 + 4, -6250336);
            }
        }
    }

    private void renderBackground(class_332 gui) {
        class_2960 background = this.theme.spritesBackground.method_52729(this.method_37303(), this.method_25370());
        gui.method_52706(class_10799.field_56883, background, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    private void renderContents(class_332 gui, int mouseX, int mouseY, float partialTick) {
        String str = this.value;
        if (!str.isEmpty() || this.method_25370()) {
            int cursor = this.cursor;
            int textColor = this.method_37303() ? this.theme.textColor : this.theme.disabledTextColor;
            boolean blink = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L;
            int y = this.method_46427() + this.innerPadding();
            for (StringPos line : this.displayLines) {
                boolean lineVisible = this.inVerticalBounds(y, y + 9);
                int x = this.method_46426() + this.leftPadding();
                if (lineVisible) {
                    boolean cursorInserting;
                    boolean bl = cursorInserting = cursor < line.endIndex;
                    if (blink && cursorInserting && cursor >= line.beginIndex && cursor <= line.endIndex) {
                        class_5481 formatStr1 = this.format(str, line.beginIndex, cursor);
                        class_5481 formatStr2 = this.format(str, cursor, line.endIndex);
                        gui.method_35720(this.font, formatStr1, x, y, textColor);
                        gui.method_35720(this.font, formatStr2, x += this.font.method_30880(formatStr1) - 1, y, textColor);
                        gui.method_25294(x, y, x + 1, y + 9, -3092272);
                    } else {
                        class_5481 formatStr = this.format(str, line.beginIndex, line.endIndex);
                        gui.method_35720(this.font, formatStr, x, y, textColor);
                        x += this.font.method_30880(formatStr);
                        if (!cursorInserting && !this.hasSelection() && cursor >= line.beginIndex && cursor <= line.endIndex && line.endIndex == this.value.length()) {
                            if (this.suggestion != null) {
                                gui.method_25303(this.font, this.suggestion, x - 1, y, this.theme.suggestionColor);
                            }
                            if (blink) {
                                if (this.cursor == line.beginIndex) {
                                    --x;
                                }
                                gui.method_25303(this.font, "_", x, y, -3092272);
                            }
                        }
                    }
                }
                y += 9;
            }
            if (this.hasSelection()) {
                StringPos selection = this.getSelected();
                int xMin = this.method_46426() + this.leftPadding();
                y = this.method_46427() + this.innerPadding();
                for (StringPos line : this.displayLines) {
                    if (selection.beginIndex > line.endIndex) {
                        y += 9;
                        continue;
                    }
                    if (line.beginIndex > selection.endIndex) break;
                    if (this.inVerticalBounds(y, y + 9)) {
                        int xStart = this.font.method_1727(str.substring(line.beginIndex, Math.max(selection.beginIndex, line.beginIndex)));
                        int xEnd = selection.endIndex > line.endIndex ? this.field_22758 - this.totalHorizontalPadding() : this.font.method_1727(str.substring(line.beginIndex, selection.endIndex));
                        gui.method_48196(class_10799.field_56881, xMin + xStart, y, xMin + xEnd, y + 9, -16776961);
                    }
                    y += 9;
                }
            }
        }
    }

    private class_5481 format(String str, int beginIndex, int endIndex) {
        if (this.minimessage.canFormat()) {
            return this.minimessage.format(beginIndex, endIndex);
        }
        return class_5481.method_30747((String)str.substring(beginIndex, endIndex), (class_2583)class_2583.field_24360);
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{this.method_25369(), this.value});
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    private void scrollToCursor() {
        double scroll = this.scrollAmount;
        StringPos currentLine = this.getDisplayLineByNumber((int)(scroll / 9.0));
        if (this.cursor <= currentLine.beginIndex) {
            scroll = this.getDisplayLineNumberAt(this.cursor) * 9;
        } else {
            StringPos line = this.getDisplayLineByNumber((int)((scroll + (double)this.field_22759) / 9.0) - 1);
            if (this.cursor >= line.endIndex) {
                scroll = this.getDisplayLineNumberAt(this.cursor) * 9 - this.field_22759 + 9 + this.totalVerticalPadding();
            }
        }
        this.setScrollAmount(scroll);
    }

    private double getDisplayableLineCount() {
        return (double)(this.field_22759 - this.totalVerticalPadding()) / 9.0;
    }

    private void seekCursorScreen(double mouseX, double mouseY) {
        double x = mouseX - (double)this.method_46426() - (double)this.leftPadding();
        double y = mouseY - (double)this.method_46427() - (double)this.innerPadding() + this.scrollAmount;
        this.seekCursorToPoint(x, y);
    }

    public StringPos getPreviousWord() {
        int cursor;
        if (this.value.isEmpty()) {
            return StringPos.EMPTY;
        }
        for (cursor = class_3532.method_15340((int)this.cursor, (int)0, (int)(this.value.length() - 1)); cursor > 0 && Character.isWhitespace(this.value.charAt(cursor - 1)); --cursor) {
        }
        while (cursor > 0 && !Character.isWhitespace(this.value.charAt(cursor - 1))) {
            --cursor;
        }
        return new StringPos(cursor, this.getWordEndPosition(cursor));
    }

    public StringPos getNextWord() {
        int cursor;
        if (this.value.isEmpty()) {
            return StringPos.EMPTY;
        }
        for (cursor = class_3532.method_15340((int)this.cursor, (int)0, (int)(this.value.length() - 1)); cursor < this.value.length() && Character.isWhitespace(this.value.charAt(cursor)); ++cursor) {
        }
        while (cursor < this.value.length() && !Character.isWhitespace(this.value.charAt(cursor))) {
            ++cursor;
        }
        return new StringPos(cursor, this.getWordEndPosition(cursor));
    }

    private int getWordEndPosition(int cursor) {
        while (cursor < this.value.length() && !Character.isWhitespace(this.value.charAt(cursor))) {
            ++cursor;
        }
        return cursor;
    }

    private void reflowDisplayLines() {
        this.displayLines.clear();
        if (this.value.isEmpty()) {
            this.displayLines.add(StringPos.EMPTY);
        } else {
            this.font.method_27527().method_27485(this.value, this.getInnerWidth(), class_2583.field_24360, false, (style, start, end) -> this.displayLines.add(new StringPos(start, end)));
            if (this.value.charAt(this.value.length() - 1) == '\n') {
                this.displayLines.add(new StringPos(this.value.length(), this.value.length()));
            }
        }
        this.refreshScrollbar();
    }

    private StringPos getDisplayLineAt(int pos) {
        for (int i = 0; i < this.displayLines.size(); ++i) {
            StringPos line = this.displayLines.get(i);
            if (pos < line.beginIndex || pos >= line.endIndex) continue;
            return line;
        }
        return this.displayLines.get(this.displayLines.size() - 1);
    }

    private int getDisplayLineNumberAt(int pos) {
        for (int i = 0; i < this.displayLines.size(); ++i) {
            StringPos line = this.displayLines.get(i);
            if (pos < line.beginIndex || pos >= line.endIndex) continue;
            return i;
        }
        return this.displayLines.size() - 1;
    }

    private StringPos getDisplayLineByNumber(int line) {
        return this.displayLines.get(class_3532.method_15340((int)line, (int)0, (int)(this.displayLines.size() - 1)));
    }

    public void method_25365(boolean focused) {
        if (focused) {
            this.minimessage.setActive(true);
        } else {
            this.minimessage.setActive(false);
            this.suggestion = null;
        }
        super.method_25365(focused);
        if (focused) {
            this.focusedTime = class_156.method_658();
        }
    }

    protected boolean inVerticalBounds(int top, int bottom) {
        return (double)bottom - this.scrollAmount >= (double)(this.method_46427() + this.innerPadding()) && (double)top - this.scrollAmount <= (double)(this.method_46427() + this.field_22759 - this.innerPadding());
    }

    protected boolean inBounds(double x, double y) {
        return x >= (double)this.method_46426() && x < (double)(this.method_46426() + this.field_22758 - this.scrollbarPadding) && y >= (double)this.method_46427() && y < (double)(this.method_46427() + this.method_25364());
    }

    public int innerPadding() {
        return this.theme.innerPadding;
    }

    public int leftPadding() {
        return this.innerPadding();
    }

    public int rightPadding() {
        return this.rightPadding;
    }

    public int totalHorizontalPadding() {
        return this.leftPadding() + this.rightPadding();
    }

    public int totalVerticalPadding() {
        return this.innerPadding() * 2;
    }

    public double scrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scroll) {
        this.scrollAmount = class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScrollAmount());
    }

    private int getScrollBarHeight() {
        return this.scrollbarHeight;
    }

    private void refreshScrollbar() {
        if (this.externalScrollbar) {
            this.scrollbarPadding = 0;
            this.rightPadding = this.innerPadding();
        } else {
            this.scrollbarPadding = this.theme.scrollbarWidth + this.theme.scrollbarPadding * 2;
            if (this.theme.scrollbarPadding < this.theme.borderThickness) {
                this.scrollbarPadding += this.theme.borderThickness - this.theme.scrollbarPadding;
            }
            this.rightPadding = this.scrollbarPadding;
        }
        int scrollbarEdgeHeight = this.theme.scrollbarEdgeHeight;
        int scrollbarScale = this.theme.scrollbarScale;
        int innerViewHeight = this.field_22759 - this.totalVerticalPadding();
        int minScrollbarHeight = Math.max(class_3532.method_38788((int)innerViewHeight, (int)6), scrollbarEdgeHeight + scrollbarScale);
        int scrollbarHeight = (int)((float)(innerViewHeight * innerViewHeight) / (float)this.getInnerHeight());
        scrollbarHeight = class_3532.method_15340((int)scrollbarHeight, (int)minScrollbarHeight, (int)(this.field_22759 - this.totalVerticalPadding() - 1));
        scrollbarHeight = Math.round((float)(scrollbarHeight - scrollbarEdgeHeight) / (float)scrollbarScale) * scrollbarScale;
        if (scrollbarHeight < minScrollbarHeight - scrollbarEdgeHeight) {
            scrollbarHeight += scrollbarScale;
        }
        if (scrollbarHeight > this.field_22759 - this.totalVerticalPadding() - Math.max(scrollbarEdgeHeight, 1)) {
            scrollbarHeight -= scrollbarScale;
        }
        this.scrollbarHeight = scrollbarHeight + scrollbarEdgeHeight;
    }

    public int getMaxScrollAmount() {
        return Math.max(0, this.getInnerHeight() + this.totalVerticalPadding() - this.field_22759);
    }

    public boolean scrollBarVisible() {
        return (double)this.getLineCount() > this.getDisplayableLineCount();
    }

    public int scrollBarWidth() {
        return this.theme.scrollbarWidth + this.theme.scrollbarPadding * 2;
    }

    public boolean isOverScrollArea(double mouseX, double mouseY) {
        int xMin = this.method_46426() + this.field_22758 - this.scrollbarPadding;
        int xMax = xMin + Math.max(this.scrollBarWidth(), this.scrollbarPadding);
        int yMin = this.method_46427();
        int yMax = this.method_46427() + this.field_22759;
        return mouseX >= (double)xMin && mouseX <= (double)xMax && mouseY >= (double)yMin && mouseY < (double)yMax;
    }

    public int getInnerWidth() {
        return this.field_22758 - this.totalHorizontalPadding();
    }

    public int getInnerHeight() {
        return 9 * this.getLineCount();
    }

    private static class LocalWTF
    implements WrappedTextField {
        private final SingleLineMMEditBox input;

        private LocalWTF(SingleLineMMEditBox input) {
            this.input = input;
        }

        @Override
        public String getValue() {
            return this.input.value;
        }

        @Override
        public void setValue(String str) {
            this.input.setValue(str);
        }

        @Override
        public void setSuggestion(@Nullable String str) {
            this.input.suggestion = str;
        }

        @Override
        public int getCursorPosition() {
            return this.input.cursor;
        }

        @Override
        public void setCursorPosition(int pos) {
            this.input.cursor = pos;
        }

        @Override
        public void setHighlightPos(int pos) {
            this.input.selectCursor = pos;
        }

        @Override
        public int getTextX() {
            return this.input.method_46426() + this.input.leftPadding();
        }

        @Override
        public int getScreenX(int charNum) {
            String value = this.getValue();
            if (charNum > value.length()) {
                return this.getTextX();
            }
            int endPos = charNum;
            StringPos dispLine = this.input.getDisplayLineAt(endPos);
            String lineText = this.input.value.substring(dispLine.beginIndex, endPos);
            return this.getTextX() + this.input.font.method_1727(lineText);
        }

        @Override
        public int getY() {
            return this.input.method_46427();
        }

        @Override
        public int getTextY(int pos) {
            int lineNum = this.input.getDisplayLineNumberAt(pos);
            return this.input.method_46427() + this.input.innerPadding() + lineNum * 9 - (int)this.input.scrollAmount;
        }

        @Override
        public int getInnerWidth() {
            return this.input.getInnerWidth();
        }

        @Override
        public int getHeight() {
            return this.input.method_25364();
        }

        @Override
        public int getLineHeight() {
            return 9;
        }
    }
}

