package _3650.builders_inventory.api.minimessage;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import _3650.builders_inventory.api.minimessage.tags.Branch;

public class MiniMessageResult {
	
	final Branch root;
	public final String trailingText;
	public final ArrayList<String> trailingArgs;
	public final ArrayList<String> unclosedTags;
	public final ArrayList<String> errors;
	
	MiniMessageResult(Branch root, String trailingText, ArrayList<String> trailingArgs, ArrayList<String> unclosedTags, ArrayList<String> errors) {
		this.root = root;
		this.trailingText = trailingText;
		this.trailingArgs = trailingArgs;
		this.unclosedTags = unclosedTags;
		this.errors = errors;
	}
	
	private class_5250 formatted;
	
	public class_5250 getFormatted() {
		if (formatted == null) {
			formatted = root.visit();
		}
		return formatted;
	}
	
	private class_5250 formattedPlain;
	
	public class_5250 getFormattedPlain() {
		if (formattedPlain == null) {
			formattedPlain = root.visitPlainText();
		}
		return formattedPlain;
	}
	
	public void debug(Consumer<class_2561> output) {
		output.accept(class_2561.method_43473());
		output.accept(class_2561.method_43473());
		output.accept(class_2561.method_43470("DEBUG"));
		output.accept(class_2561.method_43473());
		output.accept(this.getFormatted());
		output.accept(this.getFormattedPlain());
		output.accept(class_2561.method_43473());
		output.accept(class_2561.method_43470("TRAILING TEXT"));
		output.accept(class_2561.method_43473());
		output.accept(class_2561.method_43470("->" + trailingText + "<-"));
		output.accept(class_2561.method_43473());
		if (trailingArgs.size() > 0) {
			output.accept(class_2561.method_43473());
			output.accept(class_2561.method_43470("TRAILING ARGS"));
			output.accept(class_2561.method_43473());
			for (var arg : trailingArgs) output.accept(class_2561.method_43470(String.valueOf(arg)));
			output.accept(class_2561.method_43473());
		}
		if (unclosedTags.size() > 0) {
			output.accept(class_2561.method_43473());
			output.accept(class_2561.method_43470("UNCLOSED TAGS"));
			output.accept(class_2561.method_43473());
			for (var tag : unclosedTags) output.accept(class_2561.method_43470(String.valueOf(tag)));
			output.accept(class_2561.method_43473());
		}
	}
	
}
