package _3650.builders_inventory.api.minimessage.instance;

import com.google.common.collect.ImmutableList;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_2583;
import net.minecraft.class_5481;

public class HighlightedTextInput {
	
	public final String text;
	private final StyleData[] styles;
	
	public HighlightedTextInput(String text, StyleData[] styles) {
		this.text = text;
		this.styles = styles;
	}
	
	private final Long2ObjectOpenHashMap<class_5481> cache = new Long2ObjectOpenHashMap<>();
	
	public class_5481 subseq(int start, int end) {
		long sig = (start & 0xffffffffL) | (((long)end) << 32);
		if (cache.containsKey(sig)) return cache.get(sig);
		ImmutableList.Builder<class_5481> seq = ImmutableList.builder();
		while (start < end && start < text.length()) {
			final StyleData data = styles[start];
			// data.start + data.length = start + data.length - start + data.start = start + data.length - (start - data.start)
			final int dif = Math.min(data.start + data.length, end);
			seq.add(class_5481.method_30747(text.substring(start, dif), data.style));
			start = dif;
		}
		final class_5481 result = class_5481.method_30749(seq.build());
		cache.put(sig, result);
		return result;
	}
	
	public static class Builder {
		
		private final StringBuilder text;
		private final StyleData[] styles;
		public int length;
		
		public Builder(int size) {
			this.text = new StringBuilder(size);
			this.styles = new StyleData[size];
		}
		
		public void append(String str, class_2583 style) {
			final int len = str.length();
			final int max = length + len;
			text.append(str);
			final StyleData data = new StyleData(len, length, style);
			for (int i = length; i < max; i++) styles[i] = data;
			length = max;
		}
		
		public HighlightedTextInput build() {
			return new HighlightedTextInput(text.toString(), styles);
		}
		
	}
	
	static class StyleData {
		
		public final int length;
		public final int start;
		public final class_2583 style;
		
		public StyleData(int length, int start, class_2583 style) {
			this.length = length;
			this.start = start;
			this.style = style;
		}
		
	}
}
