package _3650.builders_inventory.api.minimessage.tags;

import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import _3650.builders_inventory.api.minimessage.format.Format;

public class Branch extends Node {
	
	public final ArrayList<Node> nodes = new ArrayList<>();
	public final Format format;
	private boolean closed = true;
	
	public Branch(Format format) {
		this.format = format;
	}
	
	public void append(Node node) {
		nodes.add(node);
	}
	
	@Override
	public String plainText() {
		StringBuilder result = new StringBuilder();
		result.append(this.format.plainTextFront());
		for (var node : this.nodes) {
			result.append(node.plainText());
		}
		if (closed) result.append(this.format.plainTextBack());
		return result.toString();
	}
	
	@Override
	public class_5250 visit() {
		class_5250 result = class_2561.method_43473();
		for (var node : this.nodes) {
			result.method_10852(node.visit());
		}
		return format.format(result);
	}
	
	@Override
	public class_5250 visitPlainText() {
		class_5250 result = class_2561.method_43473();
		result.method_10852(format.formatPlain(class_2561.method_43470(format.plainTextFront())));
		class_5250 content = class_2561.method_43473();
		for (var node : this.nodes) {
			content.method_10852(node.visitPlainText());
		}
		result.method_10852(format.formatPlain(content));
		if (closed) result.method_10852(format.formatPlain(class_2561.method_43470(format.plainTextBack())));
		return result;
	}
	
	public void setUnclosed() {
		this.closed = false;
	}
	
}
