package _3650.builders_inventory.api.widgets.exbutton;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8666;

public abstract class AbstractExtendedImageButton extends class_4264 {
	
	public final Supplier<List<class_2561>> disabledTooltip;
	private boolean resetFocus = false;
	private int centerX;
	private int centerY;
	
	public AbstractExtendedImageButton(int x, int y, int width, int height) {
		this(x, y, width, height, List::of);
	}
	
	public AbstractExtendedImageButton(int x, int y, int width, int height, Supplier<List<class_2561>> disabledTooltip) {
		super(x, y, width, height, class_5244.field_39003);
		this.disabledTooltip = disabledTooltip;
		this.centerX = x + (width / 2);
		this.centerY = y + (height / 2);
	}
	
	@Override
	protected void method_47399(class_6382 narrationElementOutput) {
		this.method_37021(narrationElementOutput);
	}
	
	@Override
	protected void method_48579(class_332 gui, int mouseX, int mouseY, float partialTick) {
		if (this.resetFocus) {
			this.resetFocus = false;
			this.method_25365(false);
		}
		var sprite = this.sprites().method_52729(this.method_37303(), this.method_25367());
		gui.method_52706(sprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
	}
	
	@Override
	public void method_25306() {
		this.resetFocus = true;
	}
	
	@Override
	public void method_25354(class_1144 handler) {
		final class_3414 clickSound = this.clickSound();
		if (clickSound == null) super.method_25354(handler);
		else handler.method_4873(class_1109.method_4758(clickSound, 1.0f));
	}
	
	public abstract class_3414 clickSound();
	
	public abstract class_8666 sprites();
	
	public abstract List<class_2561> tooltip();
	
	@Override
	public void method_46421(int x) {
		super.method_46421(x);
		this.centerX = x + (this.field_22758 / 2);
	}
	
	@Override
	public void method_46419(int y) {
		super.method_46419(y);
		this.centerY = y + (this.field_22759 / 2);
	}
	
	public int getCenterX() {
		return this.centerX;
	}
	
	public int getCenterY() {
		return this.centerY;
	}
	
}
