package _3650.builders_inventory.api.widgets.slider;

import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8494;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;

public class StepSliderWidget extends class_339 {
	
	public static StepSliderWidget standard(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange
			) {
		return internalBuild(
				theme,
				x,y,z,
				min,max,
				initialValue,
				0,
				font,
				tooltipFormat,
				onChange,
				noop -> {},
				false
				);
	}
	
	public static StepSliderWidget standardMinSpacing(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			int minSegmentSpacing,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange
			) {
		return internalBuild(
				theme,
				x,y,z,
				min,max,
				initialValue,
				minSegmentSpacing,
				font,
				tooltipFormat,
				onChange,
				noop -> {},
				false
				);
	}
	
	public static StepSliderWidget cancel(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange,
			IntConsumer onCancel
			) {
		return internalBuild(
				theme,
				x,y,z,
				min,max,
				initialValue,
				0,
				font,
				tooltipFormat,
				onChange,
				onCancel,
				true
				);
	}
	
	public static StepSliderWidget cancelMinSpacing(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			int minSegmentSpacing,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange,
			IntConsumer onCancel
			) {
		return internalBuild(
				theme,
				x,y,z,
				min,max,
				initialValue,
				minSegmentSpacing,
				font,
				tooltipFormat,
				onChange,
				onCancel,
				true
				);
	}
	
	private static StepSliderWidget internalBuild(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			int minSegmentSpacing,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange,
			IntConsumer onCancel,
			boolean canCancel
			) {
		if (min >= max) throw new IllegalArgumentException("Slider minimum value " + min + " must be less than maximum value " + max);
		final int segments = max - min;
		final int step = Math.max(switch(segments) {
		case 1 -> 50; //  50 segment width
		case 2 -> 30; //  60 segment width
		case 3 -> 25; //  75 segment width
		case 4 -> 22; //  88 segment width
		case 5 -> 20; // 100 segment width
		case 6 -> 18; // 108 segment width
		case 7 -> 16; // 112 segment width
		default -> segments > 48 ? 2 : Math.round(116f / segments);
		}, minSegmentSpacing);
		final int innerWidth = step * segments;
		final int borderWidth = (theme.border + theme.horizontalPadding) * 2;
		final int rightPadding = 3 + (canCancel ? 13 + 2 * theme.cancelButtonPadding : 0); // +3 for R notch, +13 for cancel extension
		final int width = innerWidth + borderWidth + rightPadding;
		
		return new StepSliderWidget(
				theme,
				x,y,z,
				min,max,
				initialValue,
				font,
				tooltipFormat,
				onChange,
				onCancel,
				width,
				theme.height,
				canCancel,
				segments,
				step,
				innerWidth
				);
	}
	
	private final SliderWidgetTheme theme;
	private final int z;
	private final int min;
	private final int max;
	public final int initialValue;
	private final class_327 font;
	private final Int2ObjectFunction<List<class_2561>> tooltipFormat;
	private final IntConsumer onChange;
	private final IntConsumer onCancel;
	
	private final boolean canCancel;
	private final int range;
	private final int notchStep;
	private final int innerWidth;
	private final int minX;
	private final int maxX;
	private final int centerY;
	private final int halfBarHeight;
	
	public int value;
	private boolean dragging = false;
	private boolean focusDragging = false;
	
	private StepSliderWidget(
			SliderWidgetTheme theme,
			int x,
			int y,
			int z,
			int min,
			int max,
			int initialValue,
			class_327 font,
			Int2ObjectFunction<List<class_2561>> tooltipFormat,
			IntConsumer onChange,
			IntConsumer onCancel,
			int width,
			int height,
			boolean canCancel,
			int segments,
			int step,
			int innerWidth
			) {
		super(x, y, width, height, class_2561.method_43473());
		this.theme = theme;
		this.z = z;
		this.min = min;
		this.max = max;
		this.value = initialValue;
		this.initialValue = initialValue;
		this.font = font;
		this.tooltipFormat = tooltipFormat;
		this.onChange = onChange;
		this.onCancel = onCancel;
		
		this.canCancel = canCancel;
		this.range = segments;
		this.notchStep = step;
		this.innerWidth = innerWidth;
		this.minX = theme.border + theme.horizontalPadding;
		this.maxX = theme.border + theme.horizontalPadding + this.innerWidth + 3;
		this.centerY = Math.floorDiv(this.field_22759, 2);
		this.halfBarHeight = Math.floorDiv(theme.barHeight, 2);
	}
	
	@Override
	protected void method_48579(class_332 gui, int mouseXi, int mouseYi, float partialTick) {
		final var theme = this.theme;
		gui.method_51448().method_22903();
		gui.method_51448().method_46416(0, 0, this.z);
		
		final class_2960 bgSprite = theme.spritesBackground.method_52729(this.method_37303(), this.method_25370() && !this.focusDragging);
		gui.method_52706(bgSprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
		
		this.drawGuides(gui);
		
		if (this.value >= this.min && this.value <= this.max) {
			final int sbx = this.method_46426() + this.minX - 1 + Math.round((this.value - this.min) * this.notchStep);
			final int sby = this.method_46427() + this.centerY - this.halfBarHeight;
			final int sbwidth = 5;
			final int sbheight = theme.barHeight;
			final class_2960 barSprite = theme.spritesBar.method_52729(this.method_37303(), (this.dragging || mouseXi >= sbx && mouseXi < sbx + sbwidth && mouseYi >= sby && mouseYi < sby + sbheight));
			gui.method_52706(barSprite, sbx, sby, sbwidth, sbheight);
		}
		
		final int x = mouseXi - this.method_46426();
		final int y = mouseYi - this.method_46427();
		if (!this.field_22763) {
			if (x >= 0 && x < this.field_22758 && y >= 0 && y < this.field_22759) {
				final List<class_2561> tooltip = this.tooltipFormat.apply(this.value);
				if (!tooltip.isEmpty()) gui.method_51434(this.font, tooltip, mouseXi, mouseYi);
			}
		} else if (x >= this.minX - Math.max(theme.horizontalPadding, 1) && x < this.maxX + Math.max(theme.horizontalPadding, 1) && y >= theme.border && y < this.field_22759 - theme.border) {
			class_310 mc = class_310.method_1551();
			class_1041 window = mc.method_22683();
			double mouseX = (mc.field_1729.method_1603() * ((double)window.method_4486() / window.method_4480()));
			final int newVal = class_3532.method_15340((int)Math.round(this.min + (mouseX - this.method_46426() - this.minX - 1.5) / this.innerWidth * this.range), this.min, this.max);
			final List<class_2561> tooltip = this.tooltipFormat.apply(newVal);
			if (!tooltip.isEmpty()) gui.method_51434(this.font, tooltip, mouseXi, mouseYi);
		} else if (this.focusDragging && this.dragging) {
			final int sbx = this.method_46426() + this.minX - 1 + Math.round((this.value - this.min) * this.notchStep);
			final int sby = this.method_46427() + this.centerY - this.halfBarHeight;
			final List<class_2561> tooltip = this.tooltipFormat.apply(this.value);
			if (!tooltip.isEmpty()) gui.method_51434(this.font, tooltip, sbx, sby);
		}
		
		if (this.canCancel) {
			final int cancelX = this.field_22758 - theme.border - 12 - theme.cancelButtonPadding;
			final boolean hoveringCancel = this.field_22763 && !this.dragging && x >= cancelX && x < cancelX + 12 && y >= theme.border && y < theme.border + 12;
			final class_2960 cancelSprite = theme.spritesCancelButton.method_52729(this.method_37303(), hoveringCancel);
			gui.method_52706(cancelSprite, this.method_46426() + cancelX, this.method_46427() + theme.border + theme.cancelButtonPadding, 12, 12);
			if (hoveringCancel) {
				gui.method_51434(this.font, List.of(
						class_2561.method_43471("container.builders_inventory.util.tooltip.button.cancel").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.util.tooltip.button.cancel.desc").method_27692(class_124.field_1080)
						), mouseXi, mouseYi);
			}
		}
		
		gui.method_51448().method_22909();
	}
	
	@SuppressWarnings("deprecation")
	private void drawGuides(class_332 gui) {
		gui.method_51741(() -> this.drawGuidesManaged(gui));
	}
	
	private void drawGuidesManaged(class_332 gui) {
		final int minX = this.method_46426() + this.minX;
		final int maxX = this.method_46426() + this.maxX;
		final int centerY = this.method_46427() + this.centerY;
		final int guideColor = this.field_22763 ? (this.method_25370() && !this.focusDragging ? this.theme.guideColorBGHighlighted : this.theme.guideColor) : this.theme.guideColorDisabled;
		gui.method_25294(minX, centerY, maxX, centerY + 1, guideColor);
		gui.method_25294(minX + 1, centerY - 3, minX + 2, centerY + 4, guideColor);
		gui.method_25294(maxX - 2, centerY - 3, maxX - 1, centerY + 4, guideColor);
		final int innerNotchCount = this.range - 1;
		for (int i = 1; i <= innerNotchCount; i++) {
			final int snx = minX + 1 + Math.round(i * this.notchStep);
			gui.method_25294(snx, centerY - 2, snx + 1, centerY + 3, guideColor);
		}
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (!this.method_37303()) return false;
		if (!this.method_25351(button)) return false;
		
		final var theme = this.theme;
		final double x = mouseX - this.method_46426();
		final double y = mouseY - this.method_46427();
		if (x >= this.minX - Math.max(theme.horizontalPadding, 1) && x < this.maxX + Math.max(theme.horizontalPadding, 1) && y >= theme.border && y < this.field_22759 - theme.border) {
			final int newVal = class_3532.method_15340((int)Math.round(this.min + (mouseX - this.method_46426() - this.minX - 1.5) / this.innerWidth * this.range), this.min, this.max);
			if (this.value != newVal) {
				this.value = newVal;
				this.onChange.accept(newVal);
			}
			
			class_310 mc = class_310.method_1551();
			this.method_25354(mc.method_1483());
			this.dragging = true;
			return true;
		} else {
			this.dragging = false;
		}
		
		if (this.canCancel) {
			final int cancelX = this.field_22758 - theme.border - 12 - theme.cancelButtonPadding;
			if (!this.dragging && x >= cancelX && x <= cancelX + 12 && y >= 4 && y < 16) {
				class_310 mc = class_310.method_1551();
				this.method_25354(mc.method_1483());
				
				this.onCancel.accept(this.initialValue);
				return true;
			}
		}
		return false;
	}
	
	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
		if (!this.method_37303()) return false;
		if (!this.method_25351(button)) return false;
		if (!this.dragging) return false;
		
		final int newVal = class_3532.method_15340((int)Math.round(this.min + (mouseX - this.method_46426() - this.minX - 1.5) / this.innerWidth * this.range), this.min, this.max);
		if (this.value != newVal) {
			this.value = newVal;
			this.onChange.accept(newVal);
		}
		
		return true;
	}
	
	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (!this.method_37303()) return false;
		if (!this.method_25351(button)) return false;
		this.dragging = false;
		return true;
	}
	
	@Override
	public void method_25365(boolean focused) {
		super.method_25365(focused);
		if (!focused) {
			this.dragging = false;
			this.focusDragging = false;
		} else {
			final var mc = class_310.method_1551();
			final var lastInput = mc.method_48186();
			if (lastInput == class_8015.field_41778 || lastInput == class_8015.field_41780) {
				this.dragging = true;
				this.focusDragging = true;
			}
		}
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (class_8494.method_51255(keyCode)) {
			this.focusDragging = !this.focusDragging;
			this.dragging = this.focusDragging;
			return true;
		} else {
			if (this.focusDragging) {
				final boolean left = keyCode == class_3675.field_31983;
				final boolean right = keyCode == class_3675.field_31984;
				if (left || right) {
					this.dragging = true;
					final int diff = left ? -1 : 1;
					final int newVal = class_3532.method_15340(this.value + diff, this.min, this.max);
					if (newVal != this.value) {
						this.value = newVal;
						this.onChange.accept(newVal);
					}
					return true;
				}
			}
		}
		return false;
	}
	
	@Override
	protected void method_47399(class_6382 narrationElementOutput) {
		
	}
	
	@Override
	public void method_25358(int width) {
		throw new UnsupportedOperationException("Changing slider size through code is not supported");
	}
	
	@Override
	public void method_53533(int height) {
		throw new UnsupportedOperationException("Changing slider size through code is not supported");
	}
	
}
