package _3650.builders_inventory.datafixer;

import java.util.Optional;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import com.mojang.datafixers.DSL.TypeReference;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;

import _3650.builders_inventory.datafixer.extended_inventory.ExtendedInventoryPageFixer;

public class ModDataFixer {
	public static final int VERSION = 2;
	
	public static int getVersion(class_2487 tag, int defaultVersion) {
		return tag.method_10573("version", class_2520.field_33253) ? tag.method_10550("version") : defaultVersion;
	}
	
	public static Dynamic<class_2520> tagDynamic(class_2487 tag) {
		return new Dynamic<>(class_2509.field_11560, tag);
	}
	
	public static int currentVersion() {
		return class_155.method_16673().method_37912().method_38494();
	}
	
	public static class_2487 updateToCurrentVersion(DataFixer fixer, class_2487 tag, int version, TypeReference type) {
		return (class_2487) fixer.update(type, tagDynamic(tag), version, currentVersion()).getValue();
	}
	
	public static Optional<class_2487> extendedInventoryPage(class_2487 tag, int defaultVersion) {
		if (tag == null) return Optional.empty();
		final int version = getVersion(tag, defaultVersion);
		return ExtendedInventoryPageFixer.update(tag, version);
	}
}
