package _3650.builders_inventory.datafixer.extended_inventory;

import java.util.Optional;
import net.minecraft.class_1208;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import com.mojang.datafixers.DataFixer;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.datafixer.ModDataFixer;

public class ExtendedInventoryPageFixer {
	
	private static final int VERSION_1_20_4 = 3700;
	
	public static Optional<class_2487> update(class_2487 tag, int version) {
		class_310 mc = class_310.method_1551();
		DataFixer dataFixer = mc.method_1543();
		
		// do not put break after any updates, they're meant to be sequential
		switch (version) {
		default:
			return tryUpdateItems(tag, dataFixer);
		case 1:
			tag = update1to2(tag, dataFixer);
		}
		
		return Optional.ofNullable(tag);
	}
	
	private static Optional<class_2487> tryUpdateItems(class_2487 old, DataFixer dataFixer) {
		int oldVersion = class_2512.method_48309(old, VERSION_1_20_4);
		if (oldVersion < ModDataFixer.currentVersion()) {
			BuildersInventory.LOGGER.info("Updating outdated items for extended inventory");
			
			if (!old.method_10573("items", class_2520.field_33259)) {
				BuildersInventory.LOGGER.error("Could not update inventory page data {}: No valid items tag", old);
				return Optional.empty();
			}
			
			class_2487 tag = old.method_10553();
			class_2499 oldItems = old.method_10554("items", class_2520.field_33260);
			if (oldItems == null || oldItems.isEmpty()) {
				BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid items tag", oldItems);
				return Optional.empty();
			}
			
			class_2499 items = new class_2499();
			for (int i = 0; i < oldItems.size(); i++) {
				class_2487 item = ModDataFixer.updateToCurrentVersion(dataFixer, oldItems.method_10602(i), oldVersion, class_1208.field_5712);
				items.add(item);
			}
			tag.method_10566("items", items);
			
			if (old.method_10573("icon", class_2520.field_33260)) {
				tag.method_10566("icon", ModDataFixer.updateToCurrentVersion(dataFixer, old.method_10562("icon"), oldVersion, class_1208.field_5712));
			}
			
			if (old.method_10573("original_icon", class_2520.field_33260)) {
				tag.method_10566("original_icon", ModDataFixer.updateToCurrentVersion(dataFixer, old.method_10562("original_icon"), oldVersion, class_1208.field_5712));
			}
			
			return Optional.of(tag);
		}
		return Optional.empty();
	}
	
	private static class_2487 update1to2(class_2487 old, DataFixer dataFixer) {
		if (old == null) return null;
		
		// items
		if (!old.method_10573("items", class_2520.field_33259)) {
			BuildersInventory.LOGGER.error("Could not update inventory page data {}: No valid items tag", old);
			return null;
		}
		
		class_2487 tag = old.method_10553();
		class_2499 oldItems = old.method_10554("items", class_2520.field_33260);
		if (oldItems == null || oldItems.isEmpty()) {
			BuildersInventory.LOGGER.error("Could not update inventory page items {}: Invalid items tag", oldItems);
			return null;
		}
		
		class_2499 items = new class_2499();
		for (int i = 0; i < oldItems.size(); i++) {
			class_2487 item = ModDataFixer.updateToCurrentVersion(dataFixer, oldItems.method_10602(i), VERSION_1_20_4, class_1208.field_5712);
			if (item.method_10573("id", class_2520.field_33258) && item.method_10558("id").equals("minecraft:air")) {
				items.add(new class_2487());
			} else {
				items.add(item);
			}
		}
		tag.method_10566("items", items);
		
		// version
		tag.method_10569("version", 2);
		
		return tag;
	}
	
}
