package _3650.builders_inventory.feature.extended_inventory;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_8666;
import net.minecraft.class_9285;
import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.ModKeybinds;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButton;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageButtonGui;
import _3650.builders_inventory.api.widgets.exbutton.ExtendedImageDualButton;
import _3650.builders_inventory.api.widgets.slider.SliderWidgetTheme;
import _3650.builders_inventory.api.widgets.slider.StepSliderWidget;
import _3650.builders_inventory.config.Config;

public class ExtendedInventoryIconScreen extends class_437 {
	
	private static final class_2960 BACKGROUND = BuildersInventory.modLoc("textures/gui/container/extended_inventory/icon.png");
	
	private static final class_8666 SPRITES_TILE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/organize/tile"),
			BuildersInventory.modLoc("extended_inventory/organize/tile_highlighted"));
	private static final class_8666 SPRITES_TILE_ACTIVE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/organize/tile_active"),
			BuildersInventory.modLoc("extended_inventory/organize/tile_active_highlighted"));
	
	private static final class_8666 SPRITES_BUTTON_COUNT = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_count"),
			BuildersInventory.modLoc("extended_inventory/icon/button_count_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_count_highlighted"));
	private static final class_8666 SPRITES_BUTTON_COUNT_OPEN = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_count_open"),
			BuildersInventory.modLoc("extended_inventory/icon/button_count_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_count_open_highlighted"));
	private static final class_8666 SPRITES_BUTTON_DATA = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_data"),
			BuildersInventory.modLoc("extended_inventory/icon/button_data_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_data_highlighted"));
	private static final class_8666 SPRITES_BUTTON_DATA_ACTIVE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_data_active"),
			BuildersInventory.modLoc("extended_inventory/icon/button_data_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_data_active_highlighted"));
	private static final class_8666 SPRITES_BUTTON_SIZE = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_size"),
			BuildersInventory.modLoc("extended_inventory/icon/button_size_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_size_highlighted"));
	private static final class_8666 SPRITES_BUTTON_SIZE_OPEN = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_size_open"),
			BuildersInventory.modLoc("extended_inventory/icon/button_size_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_size_open_highlighted"));
	private static final class_8666 SPRITES_BUTTON_CLEAR = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_clear"),
			BuildersInventory.modLoc("extended_inventory/icon/button_clear_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_clear_highlighted"));
	private static final class_8666 SPRITES_BUTTON_RESET = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_reset"),
			BuildersInventory.modLoc("extended_inventory/icon/button_reset_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_reset_highlighted"));
	
	private static final class_8666 SPRITES_BUTTON_CANCEL = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_cancel"),
			BuildersInventory.modLoc("extended_inventory/icon/button_cancel_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_cancel_highlighted"));
	private static final class_8666 SPRITES_BUTTON_CONFIRM = new class_8666(
			BuildersInventory.modLoc("extended_inventory/icon/button_confirm"),
			BuildersInventory.modLoc("extended_inventory/icon/button_confirm_disabled"),
			BuildersInventory.modLoc("extended_inventory/icon/button_confirm_highlighted"));
	
	private final ExtendedImageButtonGui exGui = new ExtendedImageButtonGui();
	private final int imageWidth;
	private final int imageHeight;
	
	private int leftPos;
	private int topPos;
	
	// Preview Tile
	private ExtendedImageDualButton tilePreview;
	// Toolbar Top
	private ExtendedImageDualButton buttonCount;
	private ExtendedImageDualButton buttonData;
	private ExtendedImageDualButton buttonSize;
	private ExtendedImageButton buttonClear;
	private ExtendedImageButton buttonReset;
	// Toolbar Bottom
	private ExtendedImageButton buttonCancel;
	private ExtendedImageButton buttonConfirm;
	
	// Overlay Widgets
	private StepSliderWidget countSlider;
	private StepSliderWidget sizeSlider;
	
	private final ExtendedInventoryPage page;
	private final int pageIndex;
	
	private class_1799 iconPreview = class_1799.field_8037;
	private class_1799 iconPreviewOriginal = class_1799.field_8037;
	private boolean tileActive = false;
	private boolean dataActive = true;
	private int iconScaleDown = 0;
	private boolean hasChanged = false;
	
	public ExtendedInventoryIconScreen(int page) {
		super(class_2561.method_43469("container.builders_inventory.extended_inventory.icon", page + 1));
		this.page = ExtendedInventoryPages.get(page);
		this.pageIndex = page;
		this.iconPreviewOriginal = this.page.originalIcon;
		this.iconPreview = this.page.icon.method_7972();
		this.dataActive = this.page.iconDataActive;
		this.iconScaleDown = this.page.iconScaleDown;
		this.imageWidth = 194;
		this.imageHeight = 204;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		this.exGui.init();
		this.leftPos = (this.field_22789 - this.imageWidth) / 2;
		this.topPos = (this.field_22790 - this.imageHeight) / 2;
		
		// Create Buttons
		this.createAllButtons();
		// Preview Tile
		this.method_37063(this.tilePreview);
		// Toolbar Top
		this.method_37063(this.buttonCount);
		this.method_37063(this.buttonData);
		this.method_37063(this.buttonSize);
		this.method_37063(this.buttonClear);
		this.method_37063(this.buttonReset);
		// Toolbar Bottom
		this.method_37063(this.buttonCancel);
		this.method_37063(this.buttonConfirm);
		
	}
	
	private void createAllButtons() {
		// Preview Tile
		this.tilePreview = new ExtendedImageDualButton(this.leftPos + 6, this.topPos + 17, 16, 16,
				SPRITES_TILE,
				button -> {
					this.tileActive = true;
					updateButtons();
				},
				SPRITES_TILE_ACTIVE,
				button -> {
					this.tileActive = false;
					updateButtons();
				}
				);
		// Toolbar Top
		this.buttonCount = new ExtendedImageDualButton(this.leftPos + 7, this.topPos + 37, 14, 14,
				SPRITES_BUTTON_COUNT,
				button -> {
					openCountSlider();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count.desc").method_27692(class_124.field_1080),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count.desc.closed").method_27692(class_124.field_1080)),
				SPRITES_BUTTON_COUNT_OPEN,
				button -> {
					closeCountSlider();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count.desc").method_27692(class_124.field_1080),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.count.desc.open").method_27692(class_124.field_1080))
				);
		this.buttonData = new ExtendedImageDualButton(this.leftPos + 7, this.topPos + 55, 14, 14,
				SPRITES_BUTTON_DATA,
				button -> {
					dataOn();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.data").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.data.desc").method_27692(class_124.field_1080)),
				SPRITES_BUTTON_DATA_ACTIVE,
				button -> {
					dataOff();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.data").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.data.desc").method_27692(class_124.field_1080))
				);
		this.buttonSize = new ExtendedImageDualButton(this.leftPos + 7, this.topPos + 73, 14, 14,
				SPRITES_BUTTON_SIZE,
				button -> {
					openSizeSlider();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size.desc").method_27692(class_124.field_1080),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size.desc.closed").method_27692(class_124.field_1080)),
				SPRITES_BUTTON_SIZE_OPEN,
				button -> {
					closeSizeSlider();
				},
				List.of(
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size").method_27692(class_124.field_1068),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size.desc").method_27692(class_124.field_1080),
						class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.size.desc.open").method_27692(class_124.field_1080))
				);
		this.buttonClear = new ExtendedImageButton(this.leftPos + 7, this.topPos + 91, 14, 14,
				SPRITES_BUTTON_CLEAR,
				button -> {
					clearPreview();
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.clear").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.clear.desc").method_27692(class_124.field_1080));
		this.buttonReset = new ExtendedImageButton(this.leftPos + 7, this.topPos + 109, 14, 14,
				SPRITES_BUTTON_RESET,
				button -> {
					resetPreview();
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.reset").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.reset.desc").method_27692(class_124.field_1080));
		// Toolbar Bottom
		this.buttonCancel = new ExtendedImageButton(this.leftPos + 7, this.topPos + 163, 14, 14,
				SPRITES_BUTTON_CANCEL,
				button -> {
					ExtendedInventory.open(this.field_22787);
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.cancel").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.cancel.desc").method_27692(class_124.field_1080));
		this.buttonConfirm = new ExtendedImageButton(this.leftPos + 7, this.topPos + 181, 14, 14,
				SPRITES_BUTTON_CONFIRM,
				button -> {
					savePreview();
					ExtendedInventory.open(this.field_22787);
				},
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.confirm").method_27692(class_124.field_1068),
				class_2561.method_43471("container.builders_inventory.extended_inventory.icon.tooltip.button.confirm.desc").method_27692(class_124.field_1080));
		
		updateButtons();
	}
	
	private void updateButtons() {
		// Preview Tile
		this.tilePreview.secondMode = this.tileActive;
		// Toolbar
		if (this.iconPreview.method_7960()) {
			// Top
			this.buttonCount.field_22763 = false;
			this.buttonData.field_22763 = false;
			this.buttonSize.field_22763 = false;
			this.buttonClear.field_22763 = false;
		} else {
			// Top
			this.buttonCount.field_22763 = true;
			this.buttonData.field_22763 = !this.iconPreviewOriginal.method_57380().method_57848();
			this.buttonSize.field_22763 = this.field_22787.method_22683().method_4495() >= 2;
			this.buttonClear.field_22763 = true;
		}
		// Top
		this.buttonCount.secondMode = this.countSlider != null;
		this.buttonData.secondMode = this.dataActive;
		this.buttonSize.secondMode = this.sizeSlider != null;
		this.buttonReset.field_22763 = hasChanged;
		// Bottom
		this.buttonConfirm.field_22763 = hasChanged;
	}
	
	@Override
	protected void method_41843() {
		super.method_41843();
		if (this.countSlider != null) {
			int initial = this.countSlider.initialValue;
			int value = this.countSlider.value;
			this.iconPreview.method_7939(initial);
			this.closeCountSlider();
			this.iconPreview.method_7939(value);
			this.openCountSlider();
		}
		if (this.sizeSlider != null) {
			int initial = this.sizeSlider.initialValue;
			int value = this.sizeSlider.value;
			this.iconScaleDown = -initial;
			this.closeSizeSlider();
			this.iconScaleDown = -value;
			this.openSizeSlider();
		}
	}
	
	@Override
	protected <T extends class_364 & class_4068 & class_6379> T method_37063(T widget) {
		this.exGui.addRenderableWidget(widget);
		return super.method_37063(widget);
	}
	
	@Override
	protected void method_37067() {
		this.exGui.clearWidgets();
		super.method_37067();
	}
	
	@Override
	public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTick) {
		super.method_25394(gui, mouseX, mouseY, partialTick);
		gui.method_51439(this.field_22793, this.field_22785, this.leftPos + 8, this.topPos + 6, 0xFF404040, false);
		
		int x = this.leftPos + 26;
		int y = this.topPos + 18;
		int slot = 0;
		for (int row = 0; row < 6; row++) {
			int slotY = y + (row * 18);
			for (int col = 0; col < 9; col++) {
				int slotX = x + (col * 18);
				class_1799 stack = this.page.get(slot++);
				gui.method_51427(stack, slotX, slotY);
				gui.method_51431(this.field_22793, stack, slotX, slotY);
			}
		}
		
		class_1661 playerInv = this.field_22787.field_1724.method_31548();
		
		y += 108;
		slot = 9;
		for (int row = 0; row < 3; row++) {
			int slotY = y + (row * 18);
			for (int col = 0; col < 9; col++) {
				int slotX = x + (col * 18);
				class_1799 stack = playerInv.method_5438(slot++);
				gui.method_51427(stack, slotX, slotY);
				gui.method_51431(this.field_22793, stack, slotX, slotY);
			}
		}
		
		y += 54;
		slot = 0;
		for (int col = 0; col < 9; col++) {
			int slotX = x + (col * 18);
			class_1799 stack = playerInv.method_5438(slot++);
			gui.method_51427(stack, slotX, y);
			gui.method_51431(this.field_22793, stack, slotX, y);
		}
		
		ItemFindResult hover = findSlot(mouseX - this.leftPos, mouseY - this.topPos);
		if (hover != null) {
			int gx = this.leftPos + 26 + (hover.col * 18);
			int gy = this.topPos + 18 + (hover.row * 18);
			gui.method_51740(class_1921.method_51785(), gx, gy, gx + 16, gy + 16, 0x80FFFFFF, 0x80FFFFFF, 2);
		}
		
		if (this.countSlider != null) this.countSlider.method_25394(gui, mouseX, mouseY, partialTick);
		if (this.sizeSlider != null) this.sizeSlider.method_25394(gui, mouseX, mouseY, partialTick);
		
		if (this.iconPreview.method_7960()) {
			this.renderTileText(this.pageIndex + 1, gui, this.leftPos + 6 + 8, this.topPos + 17 + 4, 100);
		} else {
			this.renderTileIcon(this.iconPreview, this.iconScaleDown, gui, this.leftPos + 6, this.topPos + 17, 300);
		}
		
		this.renderTooltip(gui, mouseX, mouseY, hover);
	}
	
	private void renderTooltip(class_332 gui, int x, int y, ItemFindResult hover) {
		if (hover != null && !hover.item.method_7960()) {
			gui.method_51437(this.field_22793, method_25408(this.field_22787, hover.item), hover.item.method_32347(), x, y);
		} else {
			this.exGui.renderTooltip(this.field_22793, gui, x, y);
		}
	}
	
	void renderTileText(int number, class_332 gui, int x, int y, int z) {
		String text = String.valueOf(number);
		gui.method_51448().method_22903();
		gui.method_51448().method_46416(x, y, z);
		if (text.length() > 2) {
			float scale = 2f / text.length();
			gui.method_51448().method_46416(0, 4 * (1f - scale), 0); // (8*scale - 8) / 2
			gui.method_51448().method_22905(scale, scale, 1f);
		}
		gui.method_27534(this.field_22793, class_2561.method_43470(text), 0, 0, 0xFFFFFFFF);
		gui.method_51448().method_22909();
	}
	
	void renderTileIcon(class_1799 icon, int iconScaleDown, class_332 gui, int x, int y, int z) {
		gui.method_51448().method_22903();
		gui.method_51448().method_46416(x, y, z);
		if (iconScaleDown > 0) {
			final int guiScale = (int) (this.field_22787.method_22683().method_4495() + 0.5);
			final float iconScale = iconScaleDown >= guiScale ? (1f / guiScale) : (1f - (iconScaleDown / (float)guiScale));
			gui.method_51448().method_46416((8 * (1f - iconScale)), (8 * (1f - iconScale)), 0);
			gui.method_51448().method_22905(iconScale, iconScale, 1);
		}
		gui.method_51427(icon, 0, 0);
		gui.method_51431(this.field_22793, icon, 0, 0);
		gui.method_51448().method_22909();
	}
	
	@Override
	public void method_25420(class_332 gui, int mouseX, int mouseY, float partialTick) {
		this.method_52752(gui);
		gui.method_25302(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
	}
	
	public void openCountSlider() {
		if (this.countSlider != null) this.closeCountSlider();
		this.countSlider = StepSliderWidget.cancel(SliderWidgetTheme.CUBIC, this.leftPos + 24, this.topPos + 33, 300, 1, 64, this.iconPreview.method_7947(), this.field_22793,
				val -> {
					return List.of(class_2561.method_43470(String.valueOf(val)));
				},
				val -> {
					this.iconPreview.method_7939(val);
					this.hasChanged = true;
					updateButtons();
				},
				initialVal -> {
					this.iconPreview.method_7939(initialVal);
					closeCountSlider();
				});
		this.method_25429(this.countSlider);
		this.updateButtons();
	}
	
	public void closeCountSlider() {
		if (this.countSlider == null) return;
		this.method_37066(this.countSlider);
		this.countSlider = null;
		this.updateButtons();
	}
	
	public void openSizeSlider() {
		if (this.sizeSlider != null) this.closeSizeSlider();
		final int guiScale = (int) (this.field_22787.method_22683().method_4495() + 0.5);
		if (guiScale < 2) {
			this.updateButtons();
			return;
		}
		this.sizeSlider = StepSliderWidget.cancel(SliderWidgetTheme.CUBIC, this.leftPos + 24, this.topPos + 69, 300, 1 - guiScale, 0, -this.iconScaleDown, this.field_22793,
				val -> {
					final double sizePercent = (guiScale + val) * 100.0 / (guiScale);
					return List.of(class_2561.method_43469("container.builders_inventory.extended_inventory.icon.tooltip.slider.size",
							class_9285.field_49329.format(sizePercent), guiScale + val, guiScale));
				},
				val -> {
					this.iconScaleDown = -val;
					this.hasChanged = true;
					updateButtons();
				},
				initialVal -> {
					this.iconScaleDown = -initialVal;
					closeSizeSlider();
				});
		this.method_25429(this.sizeSlider);
		this.updateButtons();
	}
	
	public void closeSizeSlider() {
		if (this.sizeSlider == null) return;
		this.method_37066(this.sizeSlider);
		this.sizeSlider = null;
		this.updateButtons();
	}
	
	public void dataOff() {
		if (!this.dataActive) return;
		this.dataActive = false;
		this.iconPreview = this.iconPreviewOriginal.method_7960() ? class_1799.field_8037 : new class_1799(this.iconPreviewOriginal.method_7909(), this.iconPreview.method_7947());
		updateButtons();
	}
	
	public void dataOn() {
		if (this.dataActive) return;
		this.dataActive = true;
		this.iconPreview = this.iconPreviewOriginal.method_46651(this.iconPreview.method_7947());
		updateButtons();
	}
	
	public void setPreview(class_1799 stack) {
		this.iconPreviewOriginal = stack;
		this.iconPreview = stack.method_46651(Math.max(this.iconPreview.method_7947(), 1));
		this.dataActive = true;
		this.hasChanged = true;
		updateButtons();
	}
	
	public void resetPreview() {
		this.iconPreviewOriginal = page.originalIcon;
		this.iconPreview = page.icon.method_7972();
		if (this.countSlider != null) this.countSlider.value = this.iconPreview.method_7947();
		this.dataActive = page.iconDataActive;
		this.iconScaleDown = page.iconScaleDown;
		if (this.sizeSlider != null) this.sizeSlider.value = -this.iconScaleDown;
		this.hasChanged = false;
		updateButtons();
	}
	
	public void clearPreview() {
		this.iconPreviewOriginal = class_1799.field_8037;
		this.iconPreview = class_1799.field_8037;
		this.closeCountSlider();
		this.dataActive = false;
		this.iconScaleDown = 0;
		this.closeSizeSlider();
		this.hasChanged = true;
		updateButtons();
	}
	
	public void savePreview() {
		page.originalIcon = this.iconPreviewOriginal.method_7972();
		page.icon = this.iconPreview.method_7972();
		page.iconDataActive = this.dataActive;
		page.iconScaleDown = this.iconScaleDown;
		page.setChanged();
		this.hasChanged = false;
		updateButtons();
	}
	
	public ItemFindResult findSlot(int x, int y) {
		if ((this.countSlider == null || !this.countSlider.method_49606()) && (this.sizeSlider == null || !this.sizeSlider.method_49606())) {
			x -= 25;
			y -= 17;
			if (x >= 0 && x < 162 && y >= 0 && y < 180) {
				int col = x / 18;
				int row = y / 18;
				if (row < 6) return new ItemFindResult(page.get(col + (row * 9)), row, col);
				else if (row < 9) return new ItemFindResult(this.field_22787.field_1724.method_31548().method_5438(col + ((row - 6) * 9) + 9), row, col);
				else if (row < 10) return new ItemFindResult(this.field_22787.field_1724.method_31548().method_5438(col + ((row - 9) * 9)), row, col);
			}
		}
		return null;
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (super.method_25402(mouseX, mouseY, button)) {
			return true;
		} else {
			var target = findSlot((int)mouseX - this.leftPos, (int)mouseY - this.topPos);
			if (target != null && target.item != class_1799.field_8037) {
				this.setPreview(target.item);
				return true;
			}
		}
		return false;
	}
	
	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
			this.method_25419();
			return true;
		} else if (ModKeybinds.OPEN_EXTENDED_INVENTORY.method_1417(keyCode, scanCode)) {
			ExtendedInventory.open(this.field_22787);
			return true;
		} else return super.method_25404(keyCode, scanCode, modifiers);
	}
	
	@Override
	public void method_25419() {
		if (Config.instance().extended_inventory_close_to_main) {
			ExtendedInventory.open(this.field_22787);
		} else super.method_25419();
	}
	
	@Override
	public boolean method_25421() {
		return false;
	}
	
	private static class ItemFindResult {
		public final class_1799 item;
		public final int row;
		public final int col;
		
		public ItemFindResult(class_1799 item, int row, int col) {
			this.item = item;
			this.row = row;
			this.col = col;
		}
	}
	
}
