/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.autocomplete;

import _3650.builders_inventory.api.minimessage.autocomplete.AutocompleteArg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SimpleStringArg
implements AutocompleteArg {
    private final ArrayList<String> vals;

    private SimpleStringArg(ArrayList<String> vals) {
        this.vals = vals;
    }

    public static SimpleStringArg of(List<String> vals) {
        ArrayList<String> sorted = new ArrayList<String>(vals);
        Collections.sort(sorted);
        return new SimpleStringArg(sorted);
    }

    @Override
    public List<String> find(String start) {
        if (start.isEmpty()) {
            return this.vals;
        }
        String startLow = start.toLowerCase(Locale.ROOT);
        ArrayList<String> result = new ArrayList<String>();
        for (String val : this.vals) {
            if (!SimpleStringArg.segmentMatches(val, startLow)) continue;
            result.add(val);
        }
        return result;
    }

    @Override
    public List<String> findNonMatch(String start) {
        if (start.isEmpty()) {
            return this.vals;
        }
        String startLow = start.toLowerCase(Locale.ROOT);
        ArrayList<String> result = new ArrayList<String>();
        for (String val : this.vals) {
            if (!SimpleStringArg.segmentMatches(val, startLow) || val.length() == start.length() && val.equals(start)) continue;
            result.add(val);
        }
        return result;
    }

    private static boolean segmentMatches(String key, String start) {
        int i = 0;
        while (!key.startsWith(start, i)) {
            if ((i = key.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

