/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.api.minimessage.instance;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.api.minimessage.MiniMessageParser;
import _3650.builders_inventory.api.minimessage.MiniMessageResult;
import _3650.builders_inventory.api.minimessage.MiniMessageUtil;
import _3650.builders_inventory.api.minimessage.instance.HighlightedTextInput;
import _3650.builders_inventory.api.minimessage.instance.LastParseListener;
import _3650.builders_inventory.api.minimessage.validator.MiniMessageValidator;
import _3650.builders_inventory.api.minimessage.widgets.wrapper.WrappedTextField;
import _3650.builders_inventory.config.Config;
import _3650.builders_inventory.feature.minimessage.MiniMessageFeature;
import _3650.builders_inventory.feature.minimessage.chat.ChatMiniMessageContext;
import _3650.builders_inventory.util.StringDiff;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniMessageInstance {
    private final class_310 minecraft;
    private final class_437 screen;
    private final class_327 font;
    public final WrappedTextField input;
    private final MiniMessageValidator context;
    private final LastParseListener listener;
    private final PreviewOptions previewOptions;
    private final SuggestionsDisplay display;
    @Nullable
    public MiniMessageResult lastParse = null;
    @Nullable
    public HighlightedTextInput inputOverride = null;
    @NotNull
    public List<class_5481> previewLines = List.of();
    @Nullable
    private String lastValue = null;
    private int updateTimer = 0;
    private boolean active = true;
    private static final class_2583 LITERAL_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private final Int2ObjectOpenHashMap<SuggestionList> cache = new Int2ObjectOpenHashMap();
    public boolean suppressSuggestionUpdate = false;
    private int _previewBGColor;
    private float _previewScale;
    private int _previewWidth;
    private int _previewXMin;
    private int _previewLineTextOffset;
    private int _previewLineHeight;
    private float _previewScaledLineHeight;
    private int _previewYMin;
    @Nullable
    private ArrayList<String> unclosedTags = null;
    @Nullable
    private SuggestionList endSuggestion;
    @Nullable
    private SuggestionList suggestion;

    public MiniMessageInstance(class_310 minecraft, class_437 screen, class_327 font, WrappedTextField input, MiniMessageValidator context, LastParseListener listener, PreviewOptions previewOptions, SuggestionOptions suggestionOptions) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.font = font;
        this.input = input;
        this.context = context;
        this.listener = listener;
        this.previewOptions = previewOptions;
        this.display = new SuggestionsDisplay(suggestionOptions);
        this.reposition();
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active && this.updateTimer > 0 && this.lastValue != null) {
            this.updateTimer = 0;
            if (this.updateMiniMessage(this.lastValue)) {
                this.display.suggestionOptions.claimSuggestions();
            }
        }
    }

    public void tick() {
        if (this.updateTimer > 0) {
            --this.updateTimer;
            if (this.updateTimer <= 0 && this.lastValue != null && this.updateMiniMessage(this.lastValue)) {
                this.display.suggestionOptions.claimSuggestions();
            }
        }
    }

    public boolean unknownEdit() {
        if (!this.active) {
            return false;
        }
        @Nullable String value = this.input.getValue();
        if (Objects.equals(value, this.lastValue)) {
            return this.cursorMoved(value);
        }
        return this.inputEdited(value);
    }

    public boolean cursorMoved() {
        if (!this.active) {
            return false;
        }
        return this.cursorMoved(this.input.getValue());
    }

    private boolean cursorMoved(String value) {
        this.cursorMoved(value, this.input.getCursorPosition());
        return this.lastParse != null;
    }

    public boolean inputEdited() {
        if (!this.active) {
            return false;
        }
        return this.inputEdited(this.input.getValue());
    }

    private boolean inputEdited(String value) {
        this.lastValue = value;
        int delay = Config.instance().minimessage_updateDelay;
        if (delay > 0) {
            this.updateTimer = delay;
            this.inputOverride = null;
            this.clear();
            return this.lastParse != null;
        }
        if (value != null && this.updateMiniMessage(value)) {
            this.display.suggestionOptions.claimSuggestions();
            return true;
        }
        return false;
    }

    public boolean quietUpdate() {
        @Nullable String value = this.input.getValue();
        boolean messageUpdated = false;
        if (value != null) {
            this.suppressSuggestionUpdate = true;
            this.lastValue = value;
            messageUpdated = this.updateMiniMessage(value);
            this.suppressSuggestionUpdate = false;
        }
        if (messageUpdated) {
            this.display.suggestionOptions.claimSuggestions();
            return true;
        }
        return false;
    }

    private boolean updateMiniMessage(@NotNull String value) {
        String originalValue = value;
        Optional<String> newVal = this.context.isValid(this.minecraft, value);
        if (newVal.isEmpty() || newVal.get().isEmpty()) {
            this.clearParse();
            return false;
        }
        value = newVal.get();
        MiniMessageResult mini = MiniMessageParser.parse(value, MiniMessageInstance.registryAccess(this.minecraft), ChatMiniMessageContext.currentServerIP);
        this.setLastParse(mini);
        StringDiff._SDMissingResult missing = StringDiff.missing(originalValue, value);
        final List<StringDiff> diffs = missing.diffs;
        final Iterator<StringDiff> diffIter = diffs.iterator();
        final int origS = originalValue.length();
        class_5250 highSeq = mini.getFormattedPlain();
        final HighlightedTextInput.Builder input = new HighlightedTextInput.Builder(origS + missing.length);
        var reconstructor = new class_5348.class_5246<Integer>(){
            public int index = 0;
            public StringDiff diff = diffs.isEmpty() ? null : (StringDiff)diffIter.next();

            public Optional<Integer> accept(class_2583 style, String string) {
                if (input.length + string.length() >= origS) {
                    int i = origS - input.length;
                    if (i > 0) {
                        String end = string.substring(0, i);
                        input.append(end, style);
                    }
                    return Optional.of(input.length + i);
                }
                if (this.diff == null) {
                    input.append(string, style);
                    return Optional.empty();
                }
                if (this.index + string.length() >= this.diff.index && this.diff.index >= this.index) {
                    int i = this.diff.index - this.index;
                    if (i > 0) {
                        String before = string.substring(0, i);
                        input.append(before, style);
                        this.index += before.length();
                    }
                    input.append(this.diff.value, style);
                    StringDiff stringDiff = this.diff = diffIter.hasNext() ? (StringDiff)diffIter.next() : null;
                    if (i < string.length()) {
                        return this.accept(style, string.substring(i));
                    }
                } else {
                    input.append(string, style);
                    this.index += string.length();
                }
                return Optional.empty();
            }
        };
        while (reconstructor.diff != null && reconstructor.diff.index == 0) {
            input.append(reconstructor.diff.value, LITERAL_STYLE);
            reconstructor.diff = diffIter.hasNext() ? diffIter.next() : null;
        }
        highSeq.method_27658((class_5348.class_5246)reconstructor, class_2583.field_24360).toString();
        if (reconstructor.diff != null) {
            input.append(reconstructor.diff.value, class_2583.field_24360);
        }
        while (diffIter.hasNext()) {
            input.append(diffIter.next().value, class_2583.field_24360);
        }
        HighlightedTextInput formattedInput = input.build();
        int err = StringUtils.indexOfDifference((CharSequence)originalValue, (CharSequence)formattedInput.text);
        class_5250 previewComponent = null;
        if (err > -1) {
            previewComponent = class_2561.method_43470((String)highSeq.getString()).method_27694(style -> style.method_27706(class_124.field_1079).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"err.builders_inventory.minimessage.mismatch", (Object[])new Object[]{err}).method_27692(class_124.field_1061))));
            BuildersInventory.LOGGER.error("FORMAT ERROR at {} for original {} and reconstructed {}", new Object[]{err, originalValue, formattedInput.text});
            this.inputOverride = null;
        } else {
            if (!mini.errors.isEmpty()) {
                previewComponent = class_2561.method_43473().method_27692(class_124.field_1061);
                ArrayList<String> errors = mini.errors;
                for (int i = 0; i < errors.size(); ++i) {
                    Object error = errors.get(i);
                    if (i < errors.size() - 1) {
                        error = (String)error + "\n";
                    }
                    previewComponent.method_10852((class_2561)class_2561.method_43470((String)error));
                }
            } else if (this.previewOptions.doStandardPreview(this.minecraft, this.screen, this)) {
                previewComponent = mini.getFormatted();
            }
            this.inputOverride = Config.instance().minimessage_syntaxHighlighting ? formattedInput : null;
            this.update(mini);
        }
        this.previewLines = List.of();
        if (previewComponent != null) {
            class_338 chatLog = this.minecraft.field_1705.method_1743();
            this.previewLines = class_341.method_1850((class_5348)previewComponent, (int)class_3532.method_15357((double)((double)chatLog.method_1811() / chatLog.method_1814())), (class_327)this.font);
            this.reposition();
        } else if (this.inputOverride != null) {
            this.reposition();
        }
        return true;
    }

    public void clearParse() {
        this.setLastParse(null);
        this.inputOverride = null;
        this.previewLines = List.of();
        this.lastValue = null;
        this.clear();
    }

    private void setLastParse(@Nullable MiniMessageResult lastParse) {
        this.lastParse = lastParse;
        this.listener.onParseChange(lastParse);
    }

    private static Optional<class_7225.class_7874> registryAccess(class_310 mc) {
        return mc.field_1687 == null ? Optional.empty() : Optional.of(mc.field_1687.method_30349());
    }

    public Optional<class_5481> tryFormatInput(String text, int offset) {
        if (this.inputOverride != null) {
            return Optional.ofNullable(this.inputOverride.subseq(offset, offset + text.length()));
        }
        return Optional.empty();
    }

    public boolean canFormat() {
        return this.inputOverride != null;
    }

    public class_5481 format(int start, int end) {
        if (this.inputOverride != null) {
            return this.inputOverride.subseq(start, end);
        }
        throw new IllegalStateException("Expected to be ready to format string but was not");
    }

    public void repositionPreview() {
        if (!this.previewLines.isEmpty()) {
            this._previewBGColor = this.previewOptions.getBGColor(this.minecraft, this.screen);
            this._previewScale = this.previewOptions.getScale(this.minecraft, this.screen);
            this._previewWidth = this.previewOptions.getWidth(this.minecraft, this.screen, this);
            this._previewXMin = this.previewOptions.getX(this.minecraft, this.screen, this);
            this._previewLineTextOffset = this.previewOptions.getLineTextOffset(this.minecraft, this.screen);
            this._previewLineHeight = this.previewOptions.getLineHeight(this.minecraft, this.screen);
            this._previewScaledLineHeight = (float)this._previewLineHeight * this._previewScale;
            this._previewYMin = this.previewOptions.getY(this.minecraft, this.screen, this);
        }
    }

    public void renderPreviewOrError(class_332 gui) {
        if (!this.active) {
            return;
        }
        if (!this.previewLines.isEmpty()) {
            gui.method_51448().method_22903();
            gui.method_51448().method_46416((float)this._previewXMin, (float)this._previewYMin, 0.0f);
            gui.method_51448().method_22905(this._previewScale, this._previewScale, 1.0f);
            gui.method_25294(0, 0, class_3532.method_15386((float)((float)this._previewWidth / this._previewScale)) + 4 + 4 + 4, -(this._previewLineHeight * this.previewLines.size()), this._previewBGColor);
            int y = this._previewLineTextOffset;
            for (int i = this.previewLines.size() - 1; i >= 0; --i) {
                class_5481 line = this.previewLines.get(i);
                gui.method_51448().method_22903();
                gui.method_51448().method_46416(0.0f, 0.0f, 50.0f);
                gui.method_35720(this.font, line, 4, y, -1);
                gui.method_51448().method_22909();
                y -= this._previewLineHeight;
            }
            gui.method_51448().method_22909();
        }
    }

    public float getScaledLineHeight() {
        return (float)this.previewLines.size() * this._previewScaledLineHeight;
    }

    public float getScaledLineHeight(int ignoreDiff) {
        return ignoreDiff >= this.previewLines.size() ? 0.0f : (float)(this.previewLines.size() - ignoreDiff) * this._previewScaledLineHeight;
    }

    public boolean renderHover(class_332 gui, int mouseX, int mouseY) {
        class_2583 style;
        double localY;
        double localX;
        int line;
        if (!this.previewLines.isEmpty() && (line = this.getPreviewLine(localX = this.toPreviewX(mouseX), localY = this.toPreviewYLine(mouseY))) >= 0 && (style = this.font.method_27527().method_30876(this.previewLines.get(line), class_3532.method_15357((double)localX))) != null && style.method_10969() != null) {
            gui.method_51441(this.font, style, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean renderFormatHover(class_332 gui, int mouseX, int mouseY, int start, int end) {
        if (this.inputOverride != null && Config.instance().minimessage_syntaxHighlighting) {
            class_2583 style;
            int inputX = this.input.getTextX();
            int inputXMax = inputX + this.input.getInnerWidth();
            int inputY = this.input.getTextY(start);
            int inputYMax = inputY + this.input.getLineHeight();
            if (mouseX >= inputX && mouseX < inputXMax && mouseY >= inputY && mouseY < inputYMax && (style = this.font.method_27527().method_30876(this.inputOverride.subseq(start, end), mouseX - inputX)) != null && style.method_10969() != null) {
                gui.method_51441(this.font, style, mouseX, mouseY);
                return true;
            }
        }
        return false;
    }

    public class_2583 tryClickPreview(double mouseX, double mouseY) {
        double localY;
        double localX;
        int line;
        if (!this.active) {
            return null;
        }
        if (!this.previewLines.isEmpty() && (line = this.getPreviewLine(localX = this.toPreviewX(mouseX), localY = this.toPreviewYLine(mouseY))) >= 0) {
            class_2583 style = this.font.method_27527().method_30876(this.previewLines.get(line), class_3532.method_15357((double)localX));
            if (style == null) {
                return null;
            }
            class_2558 click = style.method_10970();
            if (click == null || click.method_10845() == class_2558.class_2559.field_11745) {
                return null;
            }
            return style;
        }
        return null;
    }

    private double toPreviewX(double mouseX) {
        return (mouseX - 4.0) / (double)this._previewScale - (double)this._previewXMin;
    }

    private double toPreviewYLine(double mouseY) {
        return ((double)this._previewYMin - mouseY) / (double)(this._previewScale * (float)this._previewLineHeight);
    }

    private int getPreviewLine(double localX, double localY) {
        int line;
        if (localX >= 0.0 && localX <= (double)class_3532.method_15375((float)((float)this._previewWidth / this._previewScale)) && (line = class_3532.method_15357((double)localY)) < this.previewLines.size()) {
            return line;
        }
        return -1;
    }

    public void clear() {
        this.cache.clear();
        this.endSuggestion = null;
        this.suggestion = null;
        this.unclosedTags = null;
        if (this.suppressSuggestionUpdate) {
            return;
        }
        this.display.clear();
    }

    private void update(@NotNull MiniMessageResult msg) {
        this.clear();
        this.unclosedTags = msg.unclosedTags;
        List<String> unclosed = this.filterTagClose(msg.trailingText);
        ArrayList<String> formatUnclosed = new ArrayList<String>(unclosed.size());
        for (String s : unclosed) {
            formatUnclosed.add("</" + s + ">");
        }
        this.endSuggestion = new SuggestionList(formatUnclosed, 0);
        this.minecraft.method_16011().method_15396("cursorMovedMM");
        this.cursorMoved(this.input.getValue(), this.input.getCursorPosition());
        this.minecraft.method_16011().method_15407();
    }

    private void cursorMoved(String value, int cursor) {
        if (this.suppressSuggestionUpdate) {
            return;
        }
        if (!Config.instance().minimessage_suggestions) {
            this.clear();
            return;
        }
        if (cursor > value.length()) {
            return;
        }
        if (this.moveCursor(value, cursor)) {
            this.display.set(this.suggestion, this.suggestion.start, cursor, cursor == value.length());
        } else if (cursor == value.length()) {
            this.display.set(this.endSuggestion, cursor, cursor, true);
        } else {
            this.display.clear();
        }
    }

    private boolean moveCursor(String value, int cursor) {
        MiniMessageResult parse;
        if (this.cache.containsKey(cursor)) {
            SuggestionList suggestion = (SuggestionList)this.cache.get(cursor);
            if (suggestion.valid) {
                this.suggestion = suggestion;
                return true;
            }
            this.suggestion = null;
            return false;
        }
        if (value == null || value.isEmpty()) {
            this.suggestion = null;
            return false;
        }
        int start = value.lastIndexOf(60, cursor - 1);
        if (start > 0 && value.charAt(start - 1) == '\\') {
            this.suggestion = null;
            return false;
        }
        if (start == -1 || start >= cursor) {
            this.suggestion = null;
            return false;
        }
        String text = value.substring(start, cursor);
        MiniMessageResult miniMessageResult = parse = this.minecraft.field_1687 == null ? MiniMessageParser.parseNoRegistry(text) : MiniMessageParser.parse(text, Optional.of(this.minecraft.field_1687.method_30349()), ChatMiniMessageContext.currentServerIP);
        if (parse.trailingText == null) {
            this.suggestion = null;
            return false;
        }
        String input = parse.trailingText;
        if (!input.isEmpty() && parse.trailingArgs.isEmpty() && input.charAt(0) == '/') {
            if (cursor == value.length() || value.indexOf(60, cursor) == -1) {
                List<String> unclosed = this.filterTagClose(input);
                if (!unclosed.isEmpty()) {
                    ArrayList<String> strs = new ArrayList<String>(unclosed.size());
                    for (String s : unclosed) {
                        strs.add("</" + s + ">");
                    }
                    this.suggestion = new SuggestionList(strs, cursor - input.length() - 1);
                } else {
                    List<String> strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input.substring(1));
                    this.suggestion = new SuggestionList(strs, cursor - input.length() + 1);
                }
            } else {
                List<String> strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input.substring(1));
                this.suggestion = new SuggestionList(strs, cursor - input.length() + 1);
            }
        } else if (parse.trailingArgs.isEmpty()) {
            List<String> strs = MiniMessageFeature.TAG_LOOKUP.suggestTag(input);
            this.suggestion = new SuggestionList(strs, cursor - input.length());
        } else {
            ArrayList<String> args = parse.trailingArgs;
            String tagName = args.get(0);
            String prev = args.size() > 1 ? args.get(args.size() - 1) : null;
            List<String> strs = MiniMessageFeature.TAG_LOOKUP.suggestArg(tagName, args.size() - 1, prev, input);
            this.suggestion = new SuggestionList(strs, cursor - input.length());
        }
        this.cache.put(cursor, (Object)this.suggestion);
        return true;
    }

    private List<String> filterTagClose(String trailingText) {
        if (this.unclosedTags == null) {
            return List.of();
        }
        return trailingText == null || trailingText.length() <= 1 ? this.unclosedTags : MiniMessageInstance.filterStart(this.unclosedTags, trailingText.substring(1));
    }

    private static ArrayList<String> filterStart(List<String> list, String start) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (String s : list) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)start)) continue;
            result.add(s);
        }
        return result;
    }

    public void reposition() {
        this.repositionPreview();
        if (this.display.visible) {
            this.display.reposition();
        }
    }

    public boolean renderSuggestions(class_332 gui, int mouseX, int mouseY) {
        if (!this.active) {
            return false;
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        boolean result = this.display.render(gui, mouseX, mouseY);
        gui.method_51448().method_22909();
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.active) {
            return false;
        }
        if (this.display.visible) {
            return this.display.keyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 258 && this.unclosedTags != null) {
            this.cursorMoved(this.input.getValue(), this.input.getCursorPosition());
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.active || !this.display.visible) {
            return false;
        }
        return this.display.mouseScrolled((int)mouseX, (int)mouseY, class_3532.method_15350((double)scrollY, (double)-1.0, (double)1.0));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.display.visible) {
            return false;
        }
        return this.display.mouseClicked((int)mouseX, (int)mouseY, button);
    }

    public static interface PreviewOptions {
        public static StandardPreviewOptions standard(boolean doStandardPreview) {
            return new StandardPreviewOptions(doStandardPreview);
        }

        public static PreviewOptions chat() {
            return new ChatPreviewOptions();
        }

        public boolean doStandardPreview(class_310 var1, class_437 var2, MiniMessageInstance var3);

        public int getBGColor(class_310 var1, class_437 var2);

        public float getScale(class_310 var1, class_437 var2);

        public int getWidth(class_310 var1, class_437 var2, MiniMessageInstance var3);

        public int getX(class_310 var1, class_437 var2, MiniMessageInstance var3);

        public int getLineTextOffset(class_310 var1, class_437 var2);

        public int getLineHeight(class_310 var1, class_437 var2);

        public int getY(class_310 var1, class_437 var2, MiniMessageInstance var3);

        public static class StandardPreviewOptions
        implements PreviewOptions {
            private final boolean doStandardPreview;

            private StandardPreviewOptions(boolean doStandardPreview) {
                this.doStandardPreview = doStandardPreview;
            }

            @Override
            public boolean doStandardPreview(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return this.doStandardPreview && Config.instance().minimessage_messagePreview;
            }

            @Override
            public int getBGColor(class_310 mc, class_437 screen) {
                return -1610612736;
            }

            @Override
            public float getScale(class_310 mc, class_437 screen) {
                return 1.0f;
            }

            @Override
            public int getWidth(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return screen.field_22789;
            }

            @Override
            public int getX(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return 0;
            }

            @Override
            public int getLineTextOffset(class_310 mc, class_437 screen) {
                return -8;
            }

            @Override
            public int getLineHeight(class_310 mc, class_437 screen) {
                return 9;
            }

            @Override
            public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return widget.input.getY() + widget.input.getHeight() + 2 + class_3532.method_15375((float)widget.getScaledLineHeight());
            }
        }

        public static class ChatPreviewOptions
        implements PreviewOptions {
            private ChatPreviewOptions() {
            }

            @Override
            public boolean doStandardPreview(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return Config.instance().minimessage_messagePreview;
            }

            @Override
            public int getBGColor(class_310 mc, class_437 screen) {
                return (int)(255.0 * (Double)mc.field_1690.method_42550().method_41753()) << 24;
            }

            @Override
            public float getScale(class_310 mc, class_437 screen) {
                return (float)mc.field_1705.method_1743().method_1814();
            }

            @Override
            public int getWidth(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return mc.field_1705.method_1743().method_1811();
            }

            @Override
            public int getX(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return 0;
            }

            @Override
            public int getLineTextOffset(class_310 mc, class_437 screen) {
                return (int)Math.round(-8.0 * ((Double)mc.field_1690.method_42546().method_41753() + 1.0) + 4.0 * (Double)mc.field_1690.method_42546().method_41753());
            }

            @Override
            public int getLineHeight(class_310 mc, class_437 screen) {
                return MiniMessageUtil.getLineHeight(mc.field_1705.method_1743());
            }

            @Override
            public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget) {
                return screen.field_22790 - 14 - Config.instance().minimessage_chatPreviewHeight;
            }
        }
    }

    private class SuggestionsDisplay {
        private final SuggestionOptions suggestionOptions;
        public boolean visible = false;
        public List<String> suggestion = List.of();
        public int start = 0;
        private int end = 0;
        private boolean atEnd = false;
        private int x = 0;
        private int y = 0;
        private int width = 0;
        private int height = 0;
        public int lastMouseX = 0;
        public int lastMouseY = 0;
        public int offset = 0;
        public int selected = 0;
        private boolean tabCycles = false;

        public SuggestionsDisplay(SuggestionOptions suggestionOptions) {
            this.suggestionOptions = suggestionOptions;
        }

        public void clear() {
            this.hide();
            this.suggestion = null;
            MiniMessageInstance.this.input.setSuggestion(null);
        }

        private void hide() {
            this.visible = false;
            this.tabCycles = false;
        }

        public void set(SuggestionList list, int start, int cursor, boolean atEnd) {
            this.clear();
            if (list == null || !list.valid) {
                return;
            }
            this.visible = true;
            this.suggestion = list.strs;
            this.start = start;
            this.end = cursor;
            this.atEnd = atEnd;
            int widthScan = 0;
            for (String str : this.suggestion) {
                widthScan = Math.max(widthScan, MiniMessageInstance.this.font.method_1727(str));
            }
            this.width = widthScan + 1;
            this.height = Math.min(list.size, this.suggestionOptions.getLimit()) * 12;
            this.reposition();
            this.offset = 0;
            this.select(0);
        }

        public void reposition() {
            WrappedTextField input = MiniMessageInstance.this.input;
            this.x = class_3532.method_15340((int)input.getScreenX(this.start), (int)1, (int)(MiniMessageInstance.this.screen.field_22789 - this.width)) - 1;
            this.y = this.suggestionOptions.getY(MiniMessageInstance.this.minecraft, MiniMessageInstance.this.screen, MiniMessageInstance.this, this.x, this.height);
        }

        public boolean render(class_332 gui, int mouseX, int mouseY) {
            boolean mouseMoved;
            if (!this.visible) {
                return false;
            }
            int size = Math.min(this.suggestion.size(), this.suggestionOptions.getLimit());
            boolean topCut = this.offset > 0;
            boolean bottomCut = this.suggestion.size() > this.offset + size;
            int bgColor = this.suggestionOptions.getColor();
            if (topCut || bottomCut) {
                int i;
                gui.method_25294(this.x, this.y - 1, this.x + this.width, this.y, bgColor);
                gui.method_25294(this.x, this.y + this.height, this.x + this.width, this.y + this.height + 1, bgColor);
                if (topCut) {
                    for (i = 0; i < this.width; ++i) {
                        if (i % 2 != 0) continue;
                        gui.method_25294(this.x + i, this.y - 1, this.x + i + 1, this.y, -1);
                    }
                }
                if (bottomCut) {
                    for (i = 0; i < this.width; ++i) {
                        if (i % 2 != 0) continue;
                        gui.method_25294(this.x + i, this.y + this.height, this.x + i + 1, this.y + this.height + 1, -1);
                    }
                }
            }
            boolean bl = mouseMoved = mouseX != this.lastMouseX || mouseY != this.lastMouseY;
            if (mouseMoved) {
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
            gui.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, bgColor);
            for (int i = 0; i < size; ++i) {
                int index = i + this.offset;
                if (mouseMoved && mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y + i * 12 && mouseY < this.y + i * 12 + 12) {
                    this.select(index);
                }
                String s = this.suggestion.get(index);
                gui.method_25303(MiniMessageInstance.this.font, s, this.x + 1, this.y + 2 + 12 * i, index == this.selected ? -256 : -5592406);
            }
            return true;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.cycle(-1);
                this.tabCycles = false;
                return true;
            }
            if (keyCode == 264) {
                this.cycle(1);
                this.tabCycles = false;
                return true;
            }
            if (keyCode == 258) {
                if (this.tabCycles) {
                    this.cycle(class_437.method_25442() ? -1 : 1);
                }
                this.useSuggestion();
                return true;
            }
            if (keyCode == 256) {
                this.hide();
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(int mouseX, int mouseY, double delta) {
            if (mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height) {
                this.offset = class_3532.method_15340((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.suggestion.size() - this.suggestionOptions.getLimit(), 0));
                return true;
            }
            return false;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height) {
                int ind = (mouseY - this.y) / 12 + this.offset;
                if (ind >= 0 && ind < this.suggestion.size()) {
                    this.select(ind);
                    this.useSuggestion();
                }
                return true;
            }
            return false;
        }

        private void cycle(int amt) {
            this.select(this.selected + amt);
            if (this.selected < this.offset) {
                this.offset = class_3532.method_15340((int)this.selected, (int)0, (int)Math.max(this.suggestion.size() - this.suggestionOptions.getLimit(), 0));
            } else if (this.selected > this.offset + this.suggestionOptions.getLimit() - 1) {
                this.offset = class_3532.method_15340((int)(this.selected + 9), (int)0, (int)Math.max(this.suggestion.size() - this.suggestionOptions.getLimit(), 0));
            }
        }

        private void select(int i) {
            if (i < 0) {
                i += this.suggestion.size();
            }
            if (i >= this.suggestion.size()) {
                i -= this.suggestion.size();
            }
            this.selected = i;
            String sel = this.suggestion.get(i);
            String hint = SuggestionsDisplay.substr(sel, this.end - this.start);
            if (hint == null) {
                MiniMessageInstance.this.input.setSuggestion(null);
            } else if (this.atEnd && sel.startsWith(MiniMessageInstance.this.input.getValue().substring(this.start, this.end))) {
                MiniMessageInstance.this.input.setSuggestion(hint);
            }
        }

        @Nullable
        private static String substr(String s, int begin) {
            return begin >= s.length() ? null : s.substring(begin);
        }

        private void useSuggestion() {
            String str = this.suggestion.get(this.selected);
            MiniMessageInstance.this.suppressSuggestionUpdate = true;
            WrappedTextField input = MiniMessageInstance.this.input;
            String original = input.getValue();
            input.setValue(original.substring(0, this.start) + str + (this.atEnd ? "" : input.getValue().substring(this.end)));
            input.setSuggestion(null);
            int cursor = this.start + str.length();
            input.setCursorPosition(cursor);
            input.setHighlightPos(cursor);
            this.end = cursor;
            MiniMessageInstance.this.suppressSuggestionUpdate = false;
            this.tabCycles = true;
        }
    }

    public static interface SuggestionOptions {
        public static final int BG_MID = Integer.MIN_VALUE;
        public static final int BG_DARK = -805306368;

        public static SuggestionOptions standard(int suggestionLimit) {
            return new StandardSuggestionOptions(suggestionLimit);
        }

        public static SuggestionOptions chat(Supplier<class_4717> commandSuggestions) {
            return new ChatSuggestionOptions(commandSuggestions);
        }

        public int getY(class_310 var1, class_437 var2, MiniMessageInstance var3, int var4, int var5);

        public int getColor();

        public int getLimit();

        public void claimSuggestions();

        public static class StandardSuggestionOptions
        implements SuggestionOptions {
            private final int suggestionLimit;

            private StandardSuggestionOptions(int suggestionLimit) {
                this.suggestionLimit = suggestionLimit;
            }

            @Override
            public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget, int x, int suggestionHeight) {
                return widget.previewLines.isEmpty() ? widget.input.getY() + widget.input.getHeight() : widget._previewYMin + 1;
            }

            @Override
            public int getColor() {
                return Integer.MIN_VALUE;
            }

            @Override
            public int getLimit() {
                return this.suggestionLimit;
            }

            @Override
            public void claimSuggestions() {
            }
        }

        public static class ChatSuggestionOptions
        implements SuggestionOptions {
            private final Supplier<class_4717> commandSuggestions;

            private ChatSuggestionOptions(Supplier<class_4717> commandSuggestions) {
                this.commandSuggestions = commandSuggestions;
            }

            @Override
            public int getY(class_310 mc, class_437 screen, MiniMessageInstance widget, int x, int suggestionHeight) {
                class_338 chatc = mc.field_1705.method_1743();
                return screen.field_22790 - 12 - 3 - suggestionHeight - (x >= chatc.method_1811() + 12 ? 0 : (widget.previewLines.isEmpty() ? 0 : class_3532.method_15386((float)widget.getScaledLineHeight()) + Config.instance().minimessage_chatPreviewHeight));
            }

            @Override
            public int getColor() {
                return -805306368;
            }

            @Override
            public int getLimit() {
                return 10;
            }

            @Override
            public void claimSuggestions() {
                this.commandSuggestions.get().method_23933(false);
            }
        }
    }

    private static class SuggestionList {
        public final List<String> strs;
        public final int start;
        public final int size;
        public final boolean valid;

        public SuggestionList(List<String> strs, int start) {
            this.strs = strs;
            this.start = start;
            this.size = strs.size();
            this.valid = !strs.isEmpty();
        }
    }
}

