/*
 * Decompiled with CFR 0.152.
 */
package _3650.builders_inventory.feature.minimessage.chat;

import _3650.builders_inventory.BuildersInventory;
import _3650.builders_inventory.api.minimessage.validator.ChatMiniMessageValidatorRegistry;
import _3650.builders_inventory.config.Config;
import _3650.builders_inventory.feature.minimessage.MiniMessageFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_634;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ChatMiniMessageContext {
    private static List<ServerCommandEntry> serverList = List.of();
    @Nullable
    private static Pattern currentServer = null;
    @Nullable
    public static String currentServerIP = null;
    public static boolean forceChatMinimessage = false;

    public static void loadServerCommandMap() {
        BuildersInventory.LOGGER.info("Reloading per-server commands");
        List<String> lines = Config.instance().minimessage_perServerCommands;
        ArrayList<ServerCommandEntry> servers = new ArrayList<ServerCommandEntry>(lines.size());
        for (String line : lines) {
            ServerCommandEntry.fromString(line).ifPresent(servers::add);
        }
        serverList = servers;
        ChatMiniMessageContext.refreshCurrentServer();
    }

    public static void onJoinWorld(class_634 handler, PacketSender sender, class_310 mc) {
        forceChatMinimessage = Config.instance().minimessage_chatForceDefault;
        currentServerIP = ChatMiniMessageContext.getServerIP(mc);
        MiniMessageFeature.reloadTagAutocomplete(currentServerIP);
        ChatMiniMessageContext.refreshCurrentServer();
    }

    private static void refreshCurrentServer() {
        String ip = currentServerIP;
        currentServer = null;
        for (ServerCommandEntry entry : serverList) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)ip, (CharSequence)entry.server)) continue;
            currentServer = entry.pattern;
            break;
        }
    }

    private static String getServerIP(class_310 mc) {
        return mc.method_1558() == null || mc.method_1558().field_3761 == null ? "localhost" : mc.method_1558().field_3761;
    }

    public static void onQuitWorld(class_634 handler, class_310 mc) {
        currentServer = null;
        currentServerIP = null;
    }

    public static Optional<String> isValid(class_310 minecraft, String value) {
        Matcher matcher;
        value = class_3544.method_43681((String)StringUtils.normalizeSpace((String)value.trim()));
        if (currentServer != null && (matcher = currentServer.matcher(value)).find()) {
            return Optional.of(value.substring(matcher.end()));
        }
        Optional<String> genericValid = ChatMiniMessageValidatorRegistry.isValid(minecraft, value);
        if (genericValid.isPresent()) {
            return genericValid;
        }
        if (forceChatMinimessage) {
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    private static class ServerCommandEntry {
        public final String server;
        public final Pattern pattern;

        public ServerCommandEntry(String server, String pattern) {
            this.server = server;
            this.pattern = Pattern.compile("^/(?:" + pattern + ")\\s+");
        }

        public static Optional<ServerCommandEntry> fromString(String str) {
            int i = str.indexOf(61);
            if (i < 0) {
                BuildersInventory.LOGGER.error("Expected = in server=pattern format but got {}", (Object)str);
                return Optional.empty();
            }
            String server = str.substring(0, i);
            String pattern = str.substring(i + 1);
            return Optional.ofNullable(new ServerCommandEntry(server, pattern));
        }
    }
}

