package opekope2.optigui.mixin;

import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import opekope2.optigui.internal.TextureReplacer;
import opekope2.optigui.internal.interaction.InteractionHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_310.class)
abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_746 player;

    @Shadow
    @Nullable
    public class_437 currentScreen;

    @Inject(method = "setScreen(Lnet/minecraft/client/gui/screen/Screen;)V", at = @At("TAIL"))
    private void setScreenMixin(class_437 screen, CallbackInfo ci) {
        if (player != null && player.method_5770() != null && currentScreen != null) {
            InteractionHandler.interact(player, player.method_5770(), currentScreen);
        }

        TextureReplacer.handleScreenChange(currentScreen);
    }
}
