/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.util;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import opekope2.optigui.filter.EqualityFilter;
import opekope2.optigui.filter.IFilter;
import opekope2.optigui.filter.RangeFilter;
import opekope2.optigui.internal.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\b\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lopekope2/optigui/util/NumberOrRange;", "", "<init>", "()V", "Lopekope2/optigui/filter/IFilter;", "", "", "toFilter", "()Lopekope2/optigui/filter/IFilter;", "Companion", "Number", "Range", "Lopekope2/optigui/util/NumberOrRange$Number;", "Lopekope2/optigui/util/NumberOrRange$Range;", "optigui"})
public abstract class NumberOrRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex regex = new Regex("^(?:(?<start>\\d+|\\(-?\\d+\\))-(?<end>\\d+|\\(-?\\d+\\))?|(?<value>-?\\d+))$");

    private NumberOrRange() {
    }

    @NotNull
    public abstract IFilter<Integer, Unit> toFilter();

    @JvmStatic
    @Nullable
    public static final NumberOrRange tryParse(@NotNull String numberRange) {
        return Companion.tryParse(numberRange);
    }

    public /* synthetic */ NumberOrRange(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u0012\u0004\b\f\u0010\u0003\u00a8\u0006\r"}, d2={"Lopekope2/optigui/util/NumberOrRange$Companion;", "", "<init>", "()V", "", "numberRange", "Lopekope2/optigui/util/NumberOrRange;", "tryParse", "(Ljava/lang/String;)Lopekope2/optigui/util/NumberOrRange;", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "getRegex$annotations", "optigui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getRegex$annotations() {
        }

        @JvmStatic
        @Nullable
        public final NumberOrRange tryParse(@NotNull String numberRange) {
            NumberOrRange numberOrRange;
            Integer value;
            Intrinsics.checkNotNullParameter((Object)numberRange, (String)"numberRange");
            MatchResult matchResult = regex.matchEntire((CharSequence)numberRange);
            if (matchResult == null) {
                return null;
            }
            MatchResult result = matchResult;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"start");
            Integer start = object != null && (object = object.getValue()) != null && (object = UtilKt.trimParentheses((String)object)) != null ? StringsKt.toIntOrNull((String)object) : null;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"end");
            Integer end = object2 != null && (object2 = object2.getValue()) != null && (object2 = UtilKt.trimParentheses((String)object2)) != null ? StringsKt.toIntOrNull((String)object2) : null;
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"value");
            Integer n = object3 != null && (object3 = object3.getValue()) != null ? StringsKt.toIntOrNull((String)object3) : (value = null);
            if (value == null) {
                Integer n2 = start;
                Intrinsics.checkNotNull((Object)n2);
                numberOrRange = new Range(n2, end);
            } else {
                numberOrRange = new Number(value);
            }
            return numberOrRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lopekope2/optigui/util/NumberOrRange$Number;", "Lopekope2/optigui/util/NumberOrRange;", "", "value", "<init>", "(I)V", "Lopekope2/optigui/filter/IFilter;", "", "toFilter", "()Lopekope2/optigui/filter/IFilter;", "", "toString", "()Ljava/lang/String;", "I", "getValue", "()I", "optigui"})
    public static final class Number
    extends NumberOrRange {
        private final int value;

        public Number(int value) {
            super(null);
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public IFilter<Integer, Unit> toFilter() {
            return new EqualityFilter<Integer>(this.value);
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lopekope2/optigui/util/NumberOrRange$Range;", "Lopekope2/optigui/util/NumberOrRange;", "", "start", "end", "<init>", "(ILjava/lang/Integer;)V", "Lopekope2/optigui/filter/IFilter;", "", "toFilter", "()Lopekope2/optigui/filter/IFilter;", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Integer;", "getEnd", "()Ljava/lang/Integer;", "I", "getStart", "()I", "optigui"})
    public static final class Range
    extends NumberOrRange {
        private final int start;
        @Nullable
        private final Integer end;

        public Range(int start, @Nullable Integer end) {
            super(null);
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        @Nullable
        public final Integer getEnd() {
            return this.end;
        }

        @Override
        @NotNull
        public IFilter<Integer, Unit> toFilter() {
            return this.end == null ? (IFilter)RangeFilter.Companion.atLeast(this.start) : (IFilter)RangeFilter.Companion.between(this.start, this.end);
        }

        @NotNull
        public String toString() {
            Object startString = this.start < 0 ? "(" + this.start + ")" : String.valueOf(this.start);
            String endString = this.end == null ? "" : (this.end < 0 ? "(" + this.end + ")" : String.valueOf(this.end));
            return (String)startString + "-" + endString;
        }
    }
}

