@file: JvmName("InteractionUtil")

package opekope2.optigui.util

import net.minecraft.nbt.NbtCompound
import opekope2.optigui.interaction.Interaction
import opekope2.optigui.internal.TextureReplacer
import opekope2.optigui.registry.SelectorRegistry

/**
 * Returns the current interaction data.
 */
val interactionData: Interaction.Data?
    get() = TextureReplacer.interactionData

/**
 * Forces the texture replacer to re-evaluate the filters. Call this after modifying [Interaction.Data.extra] if the
 * current screen pauses the game in single player.
 */
fun invalidateCachedReplacement() = TextureReplacer.clearReplacementCache()

/**
 * Creates an OptiGUI INI from the current interaction data.
 */
fun inspectInteraction(): String? {
    val interaction = TextureReplacer.inspectableInteraction ?: return null
    val (container, _, _, data) = interaction

    return buildString {
        appendLine("# Generated by OptiGUI Inspector")
        appendLine()

        appendLine("# You may not need all selectors")
        appendLine("[$container]")
        for ((selectorKey, selector) in SelectorRegistry) {
            val selectorValue = selector.getRawSelector(interaction) ?: continue
            appendLine("$selectorKey=$selectorValue")
        }
        appendLine()

        when {
            data.blockEntity != null -> {
                appendLine("# NBT (for more detailed inspection purposes, as there is no selector for NBT):")
                appendLine("# ${data.blockEntity.createNbt()}")
                appendLine()
            }

            data.entity != null -> {
                appendLine("# NBT (for more detailed inspection purposes, as there is no selector for NBT):")
                appendLine("# ${data.entity.writeNbt(NbtCompound())}")
                appendLine()
            }

            else -> {
                appendLine("# NBT is not available")
                appendLine()
            }
        }

        appendLine("# If you have an idea or feedback about the inspector, feel free to share it at")
        appendLine("# https://github.com/opekope2/OptiGUI/issues/72")
    }
}
