package opekope2.optigui.mixin;

import net.minecraft.class_310;
import net.minecraft.class_437;
import opekope2.optigui.internal.InitializerKt;
import opekope2.optigui.registry.RetexturableScreenRegistry;
import opekope2.optigui.toast.InspectorToast;
import opekope2.optigui.util.InteractionUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_437.class)
public abstract class ScreenMixin {
    @Shadow
    protected class_310 client;

    @Inject(method = "keyPressed", at = @At("TAIL"))
    void handleKeyPress(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        class_437 thiz = (class_437) (Object) this;
        if (!RetexturableScreenRegistry.contains(thiz)) return;

        if (!InitializerKt.INSPECTOR_KEY_BINDING.matchesKey(keyCode, scanCode)) return;

        String inspection = InteractionUtil.inspectInteraction();
        if (inspection == null) return;

        client.field_1774.method_1455(inspection);
        client.method_1566().method_1999(new InspectorToast());
    }
}
