package com.farestr06.api.block;

import com.farestr06.api.item.ItemHelper;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class BlockHelper {

    /**
     * Makes a block without a corresponding item.
     * @param key The resource/registry key, which is used to help with models and loot
     * @param factory The function used to create the block
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_2248 register(class_5321<class_2248> key, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = factory.apply(settings.method_63500(key));
        return class_2378.method_39197(class_7923.field_41175, key, block);
    }

    /**
     * Makes a block without a corresponding item.
     * @param id The block's resource location/identifier
     * @param factory The function used to create the block
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    public static class_2248 makeBlock(class_2960 id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return register(keyOf(id), factory, settings);
    }

    /**
     * Makes a basic block without a corresponding item.
     * @param id The block's resource location/identifier
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    public static class_2248 makeSimpleBlock(class_2960 id, class_4970.class_2251 settings) {
        return makeBlock(id, class_2248::new, settings);
    }

    /**
     * Makes a resource/registry key from a resource location/identifier.
     * @param id The location/id used to create the key
     * @return A resource/registry key created from the given id
     */
    private static class_5321<class_2248> keyOf(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41254, id);
    }


    /**
     * Makes a block and a corresponding item with default properties/settings.
     * @param key The resource/registry key, which is used to help with item names, models and loot
     * @param factory The function used to create the block
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_2248 registerWithSimpleItem(class_5321<class_2248> key, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, factory.apply(settings.method_63500(key)));
        ItemHelper.makeSimpleBlockItem(block);
        return block;
    }

    public static class_2248 registerWithSimpleAliasedItem(class_5321<class_2248> key, class_2960 itemId, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, factory.apply(settings.method_63500(key)));
        ItemHelper.makeSimpleAliasedBlockItem(block, itemId);
        return block;
    }

    /**
     * Makes a block and a corresponding item with default properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param factory The function used to create the block
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    public static class_2248 makeBlockAndSimpleItem(class_2960 id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return registerWithSimpleItem(keyOf(id), factory, settings);
    }

    public static class_2248 makeBlockAndSimpleAliasedItem(class_2960 blockId, class_2960 itemId, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return registerWithSimpleAliasedItem(keyOf(blockId), itemId, factory, settings);
    }

    /**
     * Makes a basic block and a corresponding item with default properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    public static class_2248 makeSimpleBlockAndSimpleItem(class_2960 id, class_4970.class_2251 settings) {
        return makeBlockAndSimpleItem(id, class_2248::new, settings);
    }

    public static class_2248 makeSimpleBlockAndSimpleAliasedItem(class_2960 blockId, class_2960 itemId, class_4970.class_2251 settings) {
        return makeBlockAndSimpleAliasedItem(blockId, itemId, class_2248::new, settings);
    }

    /**
     * Makes a block and a corresponding item with custom properties/settings.
     * @param key The resource/registry key, which is used to help with item names, models and loot
     * @param factory The function used to create the block
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_2248 registerWithItem(class_5321<class_2248> key, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, factory.apply(blockSettings.method_63500(key)));
        ItemHelper.makeBlockItem(block, itemSettings);
        return block;
    }
    /**
     * Makes a block and a corresponding item with custom properties/settings.
     * @param key The resource/registry key, which is used to help with item names, models and loot
     * @param factory The function used to create the block
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_2248 registerWithAliasedItem(class_5321<class_2248> key, class_2960 itemId, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, factory.apply(blockSettings.method_63500(key)));
        ItemHelper.makeAliasedBlockItem(block, itemId, itemSettings);
        return block;
    }

    /**
     * Makes a block and a corresponding item with custom properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param factory The function used to create the block
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     */
    public static class_2248 makeBlockAndItem(class_2960 id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        return registerWithItem(keyOf(id), factory, blockSettings, itemSettings);
    }

    public static class_2248 makeBlockAndAliasedItem(
            class_2960 blockId, class_2960 itemId, Function<class_4970.class_2251, class_2248> factory,
            class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings
    ) {
        return registerWithAliasedItem(keyOf(blockId), itemId, factory, blockSettings, itemSettings);
    }

    /**
     * Makes a basic block and a corresponding item with custom properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     */
    public static class_2248 makeSimpleBlockAndItem(class_2960 id, class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        return registerWithItem(keyOf(id), class_2248::new, blockSettings, itemSettings);
    }

    /**
     * Makes a block and an advanced corresponding item with custom properties/settings.
     * @param key The resource/registry key, which is used to help with item names, models and loot
     * @param blockFactory The function used to create the block
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemFactory The function used to create the block's item
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_2248 registerWithAdvancedItem(
            class_5321<class_2248> key, Function<class_4970.class_2251, class_2248> blockFactory,
            class_4970.class_2251 blockSettings, BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory,
            class_1792.class_1793 itemSettings
    ) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, blockFactory.apply(blockSettings.method_63500(key)));
        ItemHelper.makeAdvancedBlockItem(block, itemFactory, itemSettings);
        return block;
    }
    public static class_2248 registerWithAdvancedAliasedItem(
            class_5321<class_2248> key, class_2960 itemId, Function<class_4970.class_2251, class_2248> blockFactory,
            class_4970.class_2251 blockSettings, BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory,
            class_1792.class_1793 itemSettings
    ) {
        class_2248 block = class_2378.method_39197(class_7923.field_41175, key, blockFactory.apply(blockSettings.method_63500(key)));
        ItemHelper.makeAdvancedBlockItemWithUniqueName(block, itemId, itemFactory, itemSettings);
        return block;
    }

    /**
     * Makes a block and an advanced corresponding item with custom properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param blockFactory The function used to create the block
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemFactory The function used to create the block's item
     * @param itemSettings The properties/settings to be applied to the item
     * @return The registered block
     */
    public static class_2248 makeBlockAndAdvancedItem(
            class_2960 id, Function<class_4970.class_2251, class_2248> blockFactory,
            class_4970.class_2251 blockSettings, BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory,
            class_1792.class_1793 itemSettings
    ) {
        return registerWithAdvancedItem(keyOf(id), blockFactory, blockSettings, itemFactory, itemSettings);
    }

    public static class_2248 makeBlockAndAdvancedAliasedItem(
            class_2960 blockId, class_2960 itemId, Function<class_4970.class_2251, class_2248> blockFactory,
            class_4970.class_2251 blockSettings, BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory,
            class_1792.class_1793 itemSettings
    ) {
        return registerWithAdvancedAliasedItem(keyOf(blockId), itemId, blockFactory, blockSettings, itemFactory, itemSettings);
    }

    /**
     * Makes a basic block and an advanced corresponding item with custom properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param blockSettings The properties/settings to be applied to the block
     * @param factory The function used to create the block's item
     * @param settings The properties/settings to be applied to the item
     * @return The registered block
     */
    public static class_2248 makeSimpleBlockAndAdvancedItem(
            class_2960 id, class_4970.class_2251 blockSettings,
            BiFunction<class_2248, class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings
    ) {
        return makeBlockAndAdvancedItem(id, class_2248::new, blockSettings, factory, settings);
    }

    public static class_2248 makeSimpleBlockAndAdvancedAliasedItem(
            class_2960 blockId, class_2960 itemId, class_4970.class_2251 blockSettings,
            BiFunction<class_2248, class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings
    ) {
        return makeBlockAndAdvancedAliasedItem(blockId, itemId, class_2248::new, blockSettings, factory, settings);
    }

    /**
     * Makes a block and an advanced corresponding item with default properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param blockFactory The function used to create the block
     * @param settings The properties/settings to be applied to the block
     * @param itemFactory The function used to create the block's item
     * @return The registered block
     */
    public static class_2248 makeBlockAndAdvancedItemWithDefaultSettings(
            class_2960 id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings,
            BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory
    ) {
        return registerWithAdvancedItem(keyOf(id), blockFactory, settings, itemFactory, new class_1792.class_1793());
    }
    public static class_2248 makeBlockAndAdvancedAliasedItemWithDefaultSettings(
            class_2960 blockId, class_2960 itemId, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings,
            BiFunction<class_2248, class_1792.class_1793, class_1792> itemFactory
    ) {
        return registerWithAdvancedAliasedItem(
                keyOf(blockId), itemId, blockFactory, settings, itemFactory, new class_1792.class_1793()
        );
    }

    /**
     * Makes a basic block and an advanced corresponding item with default properties/settings.
     * @param id The block's and item's resource location/identifier
     * @param settings The properties/settings to be applied to the block
     * @param factory The function used to create the block's item
     * @return The registered block
     */
    public static class_2248 makeSimpleBlockAndAdvancedItemWithDefaultSettings(
            class_2960 id, class_4970.class_2251 settings, BiFunction<class_2248, class_1792.class_1793, class_1792> factory
    ) {
        return makeBlockAndAdvancedItemWithDefaultSettings(id, class_2248::new, settings, factory);
    }

    public static class_2248 makeSimpleBlockAndAdvancedAliasedItemWithDefaultSettings(
            class_2960 blockId, class_2960 itemId, class_4970.class_2251 settings, BiFunction<class_2248, class_1792.class_1793, class_1792> factory
    ) {
        return makeBlockAndAdvancedAliasedItemWithDefaultSettings(blockId, itemId, class_2248::new, settings, factory);
    }


    /**
     * Makes a basic block without a corresponding item.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's resource location/identifier
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldBlock(class_2960 id, class_4970.class_2251 settings) {
        return class_2378.method_10230(class_7923.field_41175, id, new class_2248(settings.method_63500(class_5321.method_29179(class_7924.field_41254, id))));
    }

    /**
     * Makes a basic block and a corresponding item with default properties/settings
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's and item's resource location/identifier
     * @param settings The properties/settings to be applied to the block
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldBlockAndItem(class_2960 id, class_4970.class_2251 settings) {
        return makeOldBlockAndItem(id, settings, new class_1792.class_1793());
    }

    /**
     * Makes a basic block and a corresponding item with custom properties/settings.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's and item's resource location/identifier
     * @param blockSettings The properties/settings to be applied to the block
     * @param itemSettings The properties/settings to be applied to the block's item
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldBlockAndItem(class_2960 id, class_4970.class_2251 blockSettings, class_1792.class_1793 itemSettings) {
        class_2248 block = makeOldBlock(id, blockSettings);
        makeOldBlockItem(id, block, itemSettings);
        return block;
    }

    /**
     * Makes an advanced block without a corresponding item.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's resource location/identifier
     * @param advancedBlock The block to be registered
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldAdvancedBlock(class_2960 id, class_2248 advancedBlock) {
        return class_2378.method_10230(class_7923.field_41175, id, advancedBlock);
    }

    /**
     * Makes an advanced block and a corresponding item with default properties/settings.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's resource location/identifier
     * @param advancedBlock The block to be registered
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldAdvancedBlockAndItem(class_2960 id, class_2248 advancedBlock) {
        return makeOldAdvancedBlockAndItem(id, advancedBlock, new class_1792.class_1793());
    }

    /**
     * Makes an advanced block and a corresponding item with custom properties/settings.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The block's and item's resource location/identifier
     * @param advancedBlock The block to be registered
     * @param settings The properties/settings to be applied to the block's item
     * @return The registered block
     */
    @Deprecated
    public static class_2248 makeOldAdvancedBlockAndItem(class_2960 id, class_2248 advancedBlock, class_1792.class_1793 settings) {
        makeOldBlockItem(id, advancedBlock, settings);
        return makeOldAdvancedBlock(id, advancedBlock);
    }

    /**
     * Makes a block item with default properties/settings.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The item's resource location/identifier
     * @param block The block that the item should place
     * @return The registered block item
     */
    @Deprecated
    public static class_1792 makeOldBlockItem(class_2960 id, class_2248 block) {
        return makeOldBlockItem(id, block, new class_1792.class_1793());
    }

    /**
     * Makes a block item with custom properties/settings.
     * @deprecated Block creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param id The item's resource location/identifier
     * @param block The block that the item should place
     * @param settings The properties/settings to be applied to the block's item
     * @return The registered block item
     */
    @Deprecated
    public static class_1792 makeOldBlockItem(class_2960 id, class_2248 block, class_1792.class_1793 settings) {
        class_1792 blockItem = new class_1747(block, settings.method_63686(class_5321.method_29179(class_7924.field_41197, id)));
        return class_2378.method_10230(class_7923.field_41178, id, blockItem);
    }

}
