package com.farestr06.api.block.custom;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2384;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7923;
import net.minecraft.class_9636;

/**
 * An extension of {@link class_2384} that can summon any mob, rather than just Silverfish.
 */
public class MobSpawningBlock extends class_2384 {

    public static final MapCodec<MobSpawningBlock> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    (class_7923.field_41175.method_39673().fieldOf("host")).forGetter(MobSpawningBlock::method_10271),
                    MobSpawningBlock.method_54096(),
                    class_7923.field_41177.method_39673().fieldOf("mob").forGetter(MobSpawningBlock::getSpawnedEntity)
            ).apply(instance, MobSpawningBlock::new));

    protected final class_1299<?> entity;

    /**
     * Creates a block based on an existing block that spawns an entity of your choosing when it is broken.
     * @param regularBlock The block that this one should resemble
     * @param properties The block properties
     * @param entityType The type of entity this block should spawn when broken
     */
    public MobSpawningBlock(class_2248 regularBlock, class_2251 properties, class_1299<?> entityType) {
        super(regularBlock, properties);
        this.entity = entityType;
    }

    @Override
    public MapCodec<? extends class_2384> method_53969() {
        return field_46373;
    }

    public class_1299<?> getSpawnedEntity() {
        return entity;
    }

    protected void spawnMob(class_3218 level, class_2338 pos) {
        class_1297 mob = entity.method_5883(level, class_3730.field_16461);
        if (mob != null) {
            mob.method_5808((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            level.method_8649(mob);
        }
    }

    @Override
    public void method_9565(class_2680 state, class_3218 level, class_2338 pos, class_1799 tool, boolean dropExperience) {
        if (level.method_64395().method_8355(class_1928.field_19392) && !class_1890.method_60138(tool, class_9636.field_51556)){
            this.spawnMob(level, pos);
        }
    }
}
