package com.farestr06.api.effect;

import net.minecraft.class_1291;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class EffectHelper {
    /**
     * Registers and returns a custom status effect
     * @param location The effect's resource location/identifier
     * @param effect The effect to be registered
     * @return The registered effect
     */
    public static class_6880<class_1291> makeEffect(class_2960 location, class_1291 effect) {
        return class_2378.method_47985(class_7923.field_41174, location, effect);
    }

    /**
     * Creates a simple status effect.
     * @param location The effect's resource location/identifier
     * @param category Whether the effect is beneficial, neutral or harmful
     * @param color The color of the effect's potions and particles
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffect(class_2960 location, class_4081 category, int color) {
        return makeEffect(location, new SimpleMobEffect(category, color));
    }

    /**
     * Creates a simple status effect with special particle effects.
     * @param location The effect's resource location/identifier
     * @param category Whether the effect is beneficial, neutral or harmful
     * @param color The color of the effect's potions
     * @param particles The particles emitted by entities with the effect
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectWithSpecialParticles(class_2960 location, class_4081 category, int color, class_2394 particles) {
        return makeEffect(location, new SimpleMobEffect(category, color, particles));
    }

    /**
     * Creates a simple, beneficial status effect.
     * @param location The effect's The effect's resource location/identifier
     * @param color The color of the effect's potions and particles
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectBeneficial(class_2960 location, int color) {
        return makeSimpleEffect(location, class_4081.field_18271, color);
    }
    /**
     * Creates a simple, beneficial status effect with special particle effects.
     * @param location The effect's resource location/identifier
     * @param color The color of the effect's potions
     * @param particles The particles emitted by entities with the effect
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectBeneficialWithSpecialParticles(class_2960 location, int color, class_2394 particles) {
        return makeSimpleEffectWithSpecialParticles(location, class_4081.field_18271, color, particles);
    }

    /**
     * Creates a simple, neutral status effect.
     * @param location The effect's resource location/identifier
     * @param color The color of the effect's potions and particles
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectNeutral(class_2960 location, int color) {
        return makeSimpleEffect(location, class_4081.field_18273, color);
    }
    /**
     * Creates a simple, neutral status effect with special particle effects.
     * @param location The effect's resource location/identifier
     * @param color The color of the effect's potions
     * @param particles The particles emitted by entities with the effect
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectNeutralWithSpecialParticles(class_2960 location, int color, class_2394 particles) {
        return makeSimpleEffectWithSpecialParticles(location, class_4081.field_18273, color, particles);
    }

    /**
     * Creates a simple, harmful status effect.
     * @param location The effect's resource location/identifier
     * @param color The color of the effect's potions and particles
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectHarmful(class_2960 location, int color) {
        return makeSimpleEffect(location, class_4081.field_18272, color);
    }
    /**
     * Creates a simple, harmful status effect with special particle effects.
     * @param location The effect's resource location/identifier
     * @param color The color of the effect's potions
     * @param particles The particles emitted by entities with the effect
     * @return The registered effect
     */
    public static class_6880<class_1291> makeSimpleEffectHarmfulWithSpecialParticles(class_2960 location, int color, class_2394 particles) {
        return makeSimpleEffectWithSpecialParticles(location, class_4081.field_18272, color, particles);
    }
}
