package com.farestr06.api.effect;

import net.minecraft.class_1291;
import net.minecraft.class_2394;
import net.minecraft.class_4081;

/**
 * This class contains easy access to constructors for a bare-bones status effect, usually to modify entity attributes.
 * @apiNote The class is exclusively for basic effects, and cannot be extended. If you want to make a more advanced status effect, consider extending the vanilla {@link class_1291}.
 * @since 2.5.0
 * @author Jacob D. (FarestR06)
 */
public final class SimpleMobEffect extends class_1291 {

    /**
     * Creates a status effect with generic particles
     * @param category Whether this effect has beneficial, harmful or neutral effects
     * @param color The color of the effect's particles and potions
     */
    public SimpleMobEffect(class_4081 category, int color) {
        super(category, color);
    }

    /**
     * Creates a status effect with unique particles
     * @param category Whether this effect has beneficial, harmful or neutral effects
     * @param color The color of any potions containing this effect
     * @param particleEffect The particle effect that affected entities emit
     */
    public SimpleMobEffect(class_4081 category, int color, class_2394 particleEffect) {
        super(category, color, particleEffect);
    }
}
