package com.farestr06.api.item;

import net.minecraft.class_10134;
import net.minecraft.class_10216;
import net.minecraft.class_10707;
import net.minecraft.class_1792;
import net.minecraft.class_6862;
import net.minecraft.class_8110;

public interface FarestsItemProperties {
    default class_1792.class_1793 copy(class_1792 item) {
        return new class_1792.class_1793();
    }

    /**
     * Sets an item's maximum stack count to 1, making it unable to stack.
     * @apiNote This is unnecessary for items with durability, as they are already unable to stack.
     */
    default class_1792.class_1793 noStack() {
        return new class_1792.class_1793();
    }

    /**
     * Sets an item's maximum stack count to 16, like Signs or Snowballs.
     */
    default class_1792.class_1793 stack16() {
        return new class_1792.class_1793();
    }

    /**
     * Gives an item an enchantment glint, like the Enchanted Golden Apple or Bottle o' Enchanting.
     */
    default class_1792.class_1793 glint() {
        return new class_1792.class_1793();
    }

    /**
     * <body style="color:rgb(255, 255, 85);">Makes an Item have a rarity of UNCOMMON, such as Chainmail Armor or Netherite Upgrade Smithing Template.</body>
     */
    default class_1792.class_1793 uncommon() {
        return new class_1792.class_1793();
    }
    /**
     * <body style="color:rgb(85, 255, 255);">Makes an Item have a rarity of RARE, such as the Enchanted Golden Apple or Trident.</body>
     */
    default class_1792.class_1793 rare() {
        return new class_1792.class_1793();
    }
    /**
     * <body style="color:rgb(255, 85, 255);">Makes an Item have a rarity of EPIC, such as the Mace or Dragon Egg.</body>
     */
    default class_1792.class_1793 epic() {
        return new class_1792.class_1793();
    }

    /**
     * Makes an item immune to certain types of damage, like Netherite and fire damage or Nether Stars and explosions.
     * @param damageTag Damage types that should not destroy the item
     */
    default class_1792.class_1793 damageResistant(class_6862<class_8110> damageTag) {
        return new class_1792.class_1793();
    }

    /**
     * Makes an item prevent death when held, like a Totem of Undying.
     * @param onDeathEffects A series of consumeEffects to apply when the item "pops"
     */
    default class_1792.class_1793 deathProtection(class_10134... onDeathEffects) {
        return new class_1792.class_1793();
    }

    /**
     * Makes an item prevent death when held, like a Totem of Undying.
     * @param component A deathProtectionComponent to apply to the item
     */
    default class_1792.class_1793 deathProtection(class_10216 component) {
        return new class_1792.class_1793();
    }

    /**
     * Makes an item block damage when the player holds the Use key, like a shield.
     * @param component A blocksAttacksComponent, which determines how blocking behaves for the item.
     */
    default class_1792.class_1793 blockAttacks(class_10707 component) {
        return new class_1792.class_1793();
    }

    /**
     * Grants the player the ability to glide when the item is in the correct slot, like an Elytra.
     */
    default class_1792.class_1793 glider() {
        return new class_1792.class_1793();
    }
}
