package com.farestr06.api.item;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class ItemHelper {
    /**
     * Makes a basic block with default properties/settings.
     * @param block The block that the block item should place
     * @return The registered item
     */
    public static class_1792 makeSimpleBlockItem(class_2248 block) {
        return makeAdvancedBlockItemWithDefaultSettings(block, class_1747::new);
    }

    public static class_1792 makeSimpleAliasedBlockItem(class_2248 block, class_2960 location) {
        return makeAdvancedAliasedBlockItemWithDefaultSettings(block, location, class_1747::new);
    }

    /**
     * Makes a basic block with custom properties/settings.
     * @param block The block that the block item should place
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     */
    public static class_1792 makeBlockItem(class_2248 block, class_1792.class_1793 settings) {
        return makeAdvancedBlockItem(block, class_1747::new, settings);
    }

    public static class_1792 makeAliasedBlockItem(class_2248 block, class_2960 location, class_1792.class_1793 settings) {
        return makeAdvancedBlockItemWithUniqueName(block, location, class_1747::new, settings);
    }

    /**
     * Makes an advanced block item with default properties/settings.
     * @param block The block that the block item should place
     * @param factory The bi-function used to create the block item
     * @return The registered item
     */
    public static class_1792 makeAdvancedBlockItemWithDefaultSettings(class_2248 block, BiFunction<class_2248, class_1792.class_1793, class_1792> factory) {
        return makeAdvancedBlockItem(block, factory, new class_1792.class_1793());
    }
    public static class_1792 makeAdvancedAliasedBlockItemWithDefaultSettings(class_2248 block, class_2960 location, BiFunction<class_2248, class_1792.class_1793, class_1792> factory) {
        return makeAdvancedBlockItemWithUniqueName(block, location, factory, new class_1792.class_1793());
    }

    /**
     * Makes an advanced block item.
     * @param block The block that the block item should place
     * @param factory The bi-function used to create the block item
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     */
    @SuppressWarnings("deprecation")
    public static class_1792 makeAdvancedBlockItem(class_2248 block, BiFunction<class_2248, class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return register(
                keyFromBlock(class_7923.field_41175.method_29113(block).orElseThrow()), itemSettings -> factory.apply(block, itemSettings), settings.method_63687()
        );
    }
    @SuppressWarnings("deprecation")
    public static class_1792 makeAdvancedBlockItemWithUniqueName(class_2248 block, class_2960 location, BiFunction<class_2248, class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return register(
                keyOf(location), itemSettings -> factory.apply(block, itemSettings.method_63687()), settings.method_63685()
        );
    }

    /**
     * Makes an advanced item with default properties/settings.
     * @param location The item's resource location/ResourceLocation
     * @param factory The function used to create the item
     * @return The registered item
     */
    public static class_1792 makeAdvancedItemWithDefaultSettings(class_2960 location, Function<class_1792.class_1793, class_1792> factory) {
        return register(keyOf(location), factory);
    }

    /**
     * Makes an advanced item.
     * @param location The item's resource location/ResourceLocation
     * @param factory The function used to create the item
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     */
    public static class_1792 makeAdvancedItem(class_2960 location, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return register(keyOf(location), factory, settings);
    }

    /**
     * Makes a basic item with custom properties/settings
     * @param location The item's resource location/ResourceLocation
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     */
    public static class_1792 makeItem(class_2960 location, class_1792.class_1793 settings) {
        return register(keyOf(location), class_1792::new, settings);
    }

    /**
     * Makes a basic item with default properties/settings.
     * @param location The item's resource location/ResourceLocation
     * @return The registered item
     */
    public static class_1792 makeSimpleItem(class_2960 location) {
        return register(keyOf(location), class_1792::new, new class_1792.class_1793());
    }

    /**
     * Creates an advanced item with default properties/settings.
     * @param key The resource/registry key, which is used to help with names and models
     * @param factory The function used to create the advanced item
     * @return The registered item
     * @apiNote This method requires a resource/registry key. Ideally, you should use {@link ItemHelper#makeAdvancedItemWithDefaultSettings(class_2960, Function)}, which creates
     * the necessary keys automatically.
     */
    public static class_1792 register(class_5321<class_1792> key, Function<class_1792.class_1793, class_1792> factory) {
        return register(key, factory, new class_1792.class_1793());
    }

    /**
     * Creates an advanced item with custom properties/settings.
     * @param key The resource/registry key, which is used to help with names and models
     * @param factory The function used to create the item
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     * @apiNote This method requires a resource/registry key. Ideally, you should use the other methods, which create
     * the necessary keys automatically.
     */
    public static class_1792 register(class_5321<class_1792> key, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        class_1792 item = factory.apply(settings.method_63686(key));
        if (item instanceof class_1747 blockItem) {
            blockItem.method_7713(class_1792.field_8003, item);
        }

        return class_2378.method_39197(class_7923.field_41178, key, item);
    }

    /**
     * Creates a resource/registry key from a block's resource location/ResourceLocation.
     * @param blockKey The block whose id will be used to creeate the key
     * @return A resource/registry key created from the given block's id
     */
    private static class_5321<class_1792> keyFromBlock(class_5321<class_2248> blockKey) {
        return class_5321.method_29179(class_7924.field_41197, blockKey.method_41185());
    }

    /**
     * Creates a resource/registry key from a resource location/ResourceLocation.
     * @param location The location/id used to create the key
     * @return A resource/registry key created from the given id
     */
    private static class_5321<class_1792> keyOf(class_2960 location) {
        return class_5321.method_29179(class_7924.field_41197, location);
    }

    public static Function<class_1792.class_1793, class_1792> createBlockItemWithUniqueName(class_2248 block) {
        return settings -> new class_1747(block, settings.method_63687());
    }

    /**
     * Makes a basic item with default properties/settings.
     * @param location The item's resource location/ResourceLocation
     * @return The registered item
     * @deprecated Item creation has changed significantly since MC 1.21.2, making this method outdated.
     */
    @Deprecated(forRemoval = true)
    public static class_1792 makeOldSimpleItem(class_2960 location) {
        return makeOldItem(location, new class_1792.class_1793());
    }

    /**
     * Makes a basic item with custom properties/settings.
     * @param location The item's resource location/ResourceLocation
     * @param settings The properties/settings to be applied to the item
     * @return The registered item
     * @deprecated Item creation has changed significantly since MC 1.21.2, making this method outdated.
     */
    @Deprecated(forRemoval = true)
    public static class_1792 makeOldItem(class_2960 location, class_1792.class_1793 settings) {
        return makeOldAdvancedItem(location, new class_1792(settings.method_63686(class_5321.method_29179(class_7924.field_41197, location))));
    }

    /**
     * Makes an advanced item.
     * @deprecated Item creation has changed significantly since MC 1.21.2, making this method outdated.
     * @param location The item's resource location/ResourceLocation
     * @param advancedItem The item to be registered
     * @return The registered item
     * @apiNote Settings are specified in the Item's constructor.
     */
    @Deprecated(forRemoval = true)
    public static class_1792 makeOldAdvancedItem(class_2960 location, class_1792 advancedItem) {
        return class_2378.method_10230(class_7923.field_41178, location, advancedItem);
    }
}