package com.farestr06.api.util;

import java.net.URI;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5819;

public final class FarestsUtils {
    /**
     * Tells a game screen to open a URL.
     * @param screen The screen to open the URL in
     * @param url The URL to open
     */
    public static void openUrl(class_437 screen, String url) {
        screen.method_25430(class_2583.field_24360.method_10958(new class_2558.class_10608(URI.create(url))));
    }

    /**
     * Creates a cuboid shape that is centered on all axes.
     * @param width The width (X axis) of the cuboid shape
     * @param height The height (Y axis) of the cuboid shape
     * @param depth The depth (Z axis) of the cuboid shape
     * @return The cuboid shape with a shape calculated using the three parameters
     */
    public static class_265 centeredBox(double width, double height, double depth) {
        double widthStart = (16d - width) / 2d;
        double heightStart = (16d - height) / 2d;
        double depthStart = (16d - depth) / 2d;
        double widthEnd = width - widthStart;
        double heightEnd = height - heightStart;
        double depthEnd = depth - depthStart;
        return class_2248.method_9541(widthStart, heightStart, depthStart, widthEnd, heightEnd, depthEnd);
    }

    /**
     * Creates a cuboid shape that is centered on the X and Z axes and is aligned with the floor along the Y axis.
     * @param width The width (X axis) of the cuboid shape
     * @param height The height (Y axis) of the cuboid shape
     * @param depth The depth (Z axis) of the cuboid shape
     * @return The cuboid shape with a shape calculated using the three parameters
     */
    public static class_265 centeredFlooredCuboid(double width, double height, double depth) {
        double widthStart = (16d - width) / 2d;
        double depthStart = (16d - depth) / 2d;
        double widthEnd = width - widthStart;
        double depthEnd = depth - depthStart;
        return class_2248.method_9541(widthStart, 0, depthStart, widthEnd, height, depthEnd);
    }

    public static final class Math {
        /**
         * Rounds a value to a fraction with the specified denominator
         * @param value The value to be rounded
         * @param denominator The denominator of the fraction to round to
         * @return The rounded value
         */
        public static double roundToFraction(double value, int denominator) {
            return java.lang.Math.round(value * denominator) / ((double) denominator);
        }


        /**
         * Rounds a value to a multiple of 0.5
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static double roundToHalf(double value) {
            return java.lang.Math.round(value * 2) / 2d;
        }

        /**
         * Rounds a value to a multiple of 0.5f
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static float roundToHalf(float value) {
            return java.lang.Math.round(value * 2) / 2f;
        }


        /**
         * Rounds a value to a multiple of 0.25
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static double roundToQuarter(double value) {
            return java.lang.Math.round(value * 4) / 4d;
        }

        /**
         * Rounds a value to a multiple of 0.25f
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static float roundToQuarter(float value) {
            return java.lang.Math.round(value * 4) / 4f;
        }


        /**
         * Rounds a value to a multiple of 0.1
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static double roundToTenth(double value) {
            return java.lang.Math.round(value * 10) / 10d;
        }

        /**
         * Rounds a value to a multiple of 0.1f
         * @param value The value to be rounded
         * @return The rounded value
         */
        public static float roundToTenth(float value) {
            return java.lang.Math.round(value * 10) / 10f;
        }


        /**
         * Linearly maps a value and rounds it to a multiple of 0.1
         * @param value The input value
         * @param oldStart The starting value of the original range
         * @param oldEnd The end value of the original range
         * @param newStart The starting value of the new range
         * @param newEnd The end value of the new range
         * @return The mapped and rounded value
         */
        public static double mapWithOneDecimalPlace(double value, double oldStart, double oldEnd, double newStart, double newEnd) {
            double mapped = class_3532.method_33722(value, oldStart, oldEnd, newStart, newEnd);
            return roundToTenth(mapped);
        }

        /**
         * Linearly maps a value and rounds it to a multiple of 0.1f
         * @param value The input value
         * @param oldStart The starting value of the original range
         * @param oldEnd The end value of the original range
         * @param newStart The starting value of the new range
         * @param newEnd The end value of the new range
         * @return The mapped and rounded value
         */
        public static float mapWithOneDecimalPlace(float value, float oldStart, float oldEnd, float newStart, float newEnd) {
            float mapped = class_3532.method_37959(value, oldStart, oldEnd, newStart, newEnd);
            return roundToTenth(mapped);
        }

        /**
         * Creates a large float between zero and the specified bound
         * @param rand A Random object, which is used to generate the float
         * @param bound The upper bound of the generated float
         * @return A randomly generated float between 0 and the upper bound
         */
        public static float randomBigFloat(class_5819 rand, int bound) {
            return randomBigFloat(rand, 0, bound);
        }

        /**
         * Creates a large float between the specified minimum and maximum values
         * @param rand A Random object, which is used to generate the float
         * @param min The lower bound of the generated float
         * @param max The upper bound of the generated float
         * @return A randomly generated float between the min and max
         */
        public static float randomBigFloat(class_5819 rand, int min, int max) {
            int i = rand.method_39332(min, max);
            return i * rand.method_43057();
        }
    }
}
