package com.farestr06.api.util.datagen;

import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import java.util.HashMap;
import java.util.Map;

/**
 * A class that maps strings to game objects, so translation can be automated.
 * To use the translator, instantiate it in an easy location, like the mod's entrypoint or language provider.
 * <p>
 * Once all objects are added, use the {@link Translator#translate(FabricLanguageProvider.TranslationBuilder)} method to generate the translations.
 */
public class Translator {
    private final Map<String, String> keyTranslations = new HashMap<>();
    private final Map<class_2960, String> resourceLocationTranslations = new HashMap<>();
    private final Map<class_2248, String> blockTranslations = new HashMap<>();
    private final Map<class_1792, String> itemTranslations = new HashMap<>();
    private final Map<class_5321<class_1761>, String> creativeTabTranslations = new HashMap<>();
    private final Map<class_1299<?>, String> entityTranslations = new HashMap<>();
    private final Map<class_5321<class_1887>, String> enchantmentTranslations = new HashMap<>();
    private final Map<class_6880<class_1320>, String> attributeTranslations = new HashMap<>();
    private final Map<class_3448<?>, String> statTypeTranslations = new HashMap<>();
    private final Map<class_1291, String> mobEffectTranslations = new HashMap<>();
    private final Map<class_6862<?>, String> tagTranslations = new HashMap<>();
    private final Map<class_3414, String> subtitleTranslations = new HashMap<>();

    public void addTranslationKey(String key, String value) {
        keyTranslations.put(key, value);
    }
    public void addResourceLocation(class_2960 location, String value) {
        resourceLocationTranslations.put(location, value);
    }
    public void addBlock(class_2248 block, String translation) {
        blockTranslations.put(block, translation);
    }
    public void addItem(class_1792 item, String value) {
        itemTranslations.put(item, value);
    }
    public void addCreativeTab(class_5321<class_1761> tab, String value) {
        creativeTabTranslations.put(tab, value);
    }
    public void addEntity(class_1299<?> entity, String value) {
        entityTranslations.put(entity, value);
    }
    public void addEnchantment(class_5321<class_1887> enchantment, String value) {
        enchantmentTranslations.put(enchantment, value);
    }
    public void addAttribute(class_6880<class_1320> attribute, String value) {
        attributeTranslations.put(attribute, value);
    }
    public void addStatType(class_3448<?> statType, String value) {
        statTypeTranslations.put(statType, value);
    }
    public void addMobEffect(class_1291 effect, String value) {
        mobEffectTranslations.put(effect, value);
    }
    public void addTag(class_6862<?> tag, String value) {
        tagTranslations.put(tag, value);
    }
    public void addSubtitle(class_3414 sound, String value) {
        subtitleTranslations.put(sound, value);
    }

    /**
     * Once all objects and translations are added, this method is used to send them to a translation builder.
     * @param builder A translation builder from your mod's language provider
     */
    public void translate(FabricLanguageProvider.TranslationBuilder builder) {
        for (String key : keyTranslations.keySet()) {
            builder.add(key, keyTranslations.get(key));
        }
        for (class_2960 location : resourceLocationTranslations.keySet()) {
            builder.add(location, resourceLocationTranslations.get(location));
        }
        for (class_2248 key : blockTranslations.keySet()) {
            builder.add(key, blockTranslations.get(key));
        }
        for (class_1792 key : itemTranslations.keySet()) {
            builder.add(key, itemTranslations.get(key));
        }
        for (class_5321<class_1761> key : creativeTabTranslations.keySet()) {
            builder.add(key, creativeTabTranslations.get(key));
        }
        for (class_1299<?> key : entityTranslations.keySet()) {
            builder.add(key, entityTranslations.get(key));
        }
        for (class_5321<class_1887> key : enchantmentTranslations.keySet()) {
            builder.addEnchantment(key, enchantmentTranslations.get(key));
        }
        for (class_6880<class_1320> key : attributeTranslations.keySet()) {
            builder.add(key, attributeTranslations.get(key));
        }
        for (class_3448<?> key : statTypeTranslations.keySet()) {
            builder.add(key, statTypeTranslations.get(key));
        }
        for (class_1291 key : mobEffectTranslations.keySet()) {
            builder.add(key, mobEffectTranslations.get(key));
        }
        for (class_6862<?> key : tagTranslations.keySet()) {
            builder.add(key, tagTranslations.get(key));
        }
        for (class_3414 key : subtitleTranslations.keySet()) {
            builder.add(key, subtitleTranslations.get(key));
        }
    }
}
