package com.farestr06.api.util.registry;

import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class NoteblockInstrumentRegistryImpl implements NoteblockInstrumentRegistry {
    private final Map<class_2248, class_6880.class_6883<class_3414>> instrumentsByBlock = new HashMap<>();
    private final Map<class_6862<class_2248>, class_6880.class_6883<class_3414>> instrumentsByTag = new HashMap<>();
    private volatile Map<class_2248, class_6880.class_6883<class_3414>> computedInstruments = null;

    private Map<class_2248, class_6880.class_6883<class_3414>> getEntryMap() {
        Map<class_2248, class_6880.class_6883<class_3414>> ret = computedInstruments;

        if (ret == null) {
            ret = new IdentityHashMap<>();

            // tags take precedence over blocks
            for (class_6862<class_2248> tag : instrumentsByTag.keySet()) {
                class_6880.class_6883<class_3414> entry = instrumentsByTag.get(tag);

                for (class_6880<class_2248> block : class_7923.field_41175.method_40286(tag)) {
                    ret.put(block.comp_349(), entry);
                }
            }

            ret.putAll(instrumentsByBlock);

            computedInstruments = ret;
        }

        return ret;
    }

    @Nullable
    @Override
    public class_6880.class_6883<class_3414> get(class_2248 block) {
        return getEntryMap().get(block);
    }

    @Override
    public void add(class_2248 block, class_6880.class_6883<class_3414> event) {
        instrumentsByBlock.put(block, event);
        computedInstruments = null;
    }

    @Override
    public void add(class_6862<class_2248> tag, class_6880.class_6883<class_3414> event) {
        instrumentsByTag.put(tag, event);
    }

    @Override
    public void remove(class_2248 block) {
        add(block, class_3417.field_15114);
    }

    @Override
    public void remove(class_6862<class_2248> tag) {
        add(tag, class_3417.field_15114);
    }

    @Override
    public void clear(class_2248 block) {
        instrumentsByBlock.remove(block);

        computedInstruments = null;
    }

    @Override
    public void clear(class_6862<class_2248> tag) {
        instrumentsByTag.remove(tag);

        computedInstruments = null;
    }
}
