/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.network;

import java.util.function.Supplier;
import net.imasillylittleguy.cnc.CncMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CncModVariables {
    public static boolean signed_contract = false;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CncMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CncMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.whistles_cooldown = message.data.whistles_cooldown;
                    variables.whistles = message.data.whistles;
                    variables.never_show_again_beta = message.data.never_show_again_beta;
                    variables.encountered_elk = message.data.encountered_elk;
                    variables.encountered_beaver = message.data.encountered_beaver;
                    variables.encountered_black_bear = message.data.encountered_black_bear;
                    variables.encountered_cougar = message.data.encountered_cougar;
                    variables.encountered_coyote = message.data.encountered_coyote;
                    variables.encountered_giant_boar = message.data.encountered_giant_boar;
                    variables.encountered_goose = message.data.encountered_goose;
                    variables.encountered_greywolf = message.data.encountered_greywolf;
                    variables.encountered_mouse = message.data.encountered_mouse;
                    variables.encountered_pit_viper = message.data.encountered_pit_viper;
                    variables.encountered_rattlesnake = message.data.encountered_rattlesnake;
                    variables.encountered_ringtail = message.data.encountered_ringtail;
                    variables.encountered_snake = message.data.encountered_snake;
                    variables.encountered_whitetail = message.data.encountered_whitetail;
                    variables.encountered_wolverine = message.data.encountered_wolverine;
                    variables.encountered_wendigo = message.data.encountered_wendigo;
                    variables.encountered_skinwalker = message.data.encountered_skinwalker;
                    variables.encountered_chupacabra = message.data.encountered_chupacabra;
                    variables.encountered_squonk = message.data.encountered_squonk;
                    variables.encountered_howler = message.data.encountered_howler;
                    variables.encountered_sasquatch = message.data.encountered_sasquatch;
                    variables.recieved_field_guide = message.data.recieved_field_guide;
                    variables.cipher_secret = message.data.cipher_secret;
                    variables.encountered_wechuge = message.data.encountered_wechuge;
                    variables.encountered_caribou = message.data.encountered_caribou;
                    variables.encountered_turkey = message.data.encountered_turkey;
                    variables.encountered_marmot = message.data.encountered_marmot;
                    variables.encountered_skunk = message.data.encountered_skunk;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean whistles_cooldown = false;
        public double whistles = 0.0;
        public boolean never_show_again_beta = false;
        public boolean encountered_elk = false;
        public boolean encountered_beaver = false;
        public boolean encountered_black_bear = false;
        public boolean encountered_cougar = false;
        public boolean encountered_coyote = false;
        public boolean encountered_giant_boar = false;
        public boolean encountered_goose = false;
        public boolean encountered_greywolf = false;
        public boolean encountered_mouse = false;
        public boolean encountered_pit_viper = false;
        public boolean encountered_rattlesnake = false;
        public boolean encountered_ringtail = false;
        public boolean encountered_snake = false;
        public boolean encountered_whitetail = false;
        public boolean encountered_wolverine = false;
        public boolean encountered_wendigo = false;
        public boolean encountered_skinwalker = false;
        public boolean encountered_chupacabra = false;
        public boolean encountered_squonk = false;
        public boolean encountered_howler = false;
        public boolean encountered_sasquatch = false;
        public boolean recieved_field_guide = false;
        public boolean cipher_secret = false;
        public boolean encountered_wechuge = false;
        public boolean encountered_caribou = false;
        public boolean encountered_turkey = false;
        public boolean encountered_marmot = false;
        public boolean encountered_skunk = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CncMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("whistles_cooldown", this.whistles_cooldown);
            nbt.m_128347_("whistles", this.whistles);
            nbt.m_128379_("never_show_again_beta", this.never_show_again_beta);
            nbt.m_128379_("encountered_elk", this.encountered_elk);
            nbt.m_128379_("encountered_beaver", this.encountered_beaver);
            nbt.m_128379_("encountered_black_bear", this.encountered_black_bear);
            nbt.m_128379_("encountered_cougar", this.encountered_cougar);
            nbt.m_128379_("encountered_coyote", this.encountered_coyote);
            nbt.m_128379_("encountered_giant_boar", this.encountered_giant_boar);
            nbt.m_128379_("encountered_goose", this.encountered_goose);
            nbt.m_128379_("encountered_greywolf", this.encountered_greywolf);
            nbt.m_128379_("encountered_mouse", this.encountered_mouse);
            nbt.m_128379_("encountered_pit_viper", this.encountered_pit_viper);
            nbt.m_128379_("encountered_rattlesnake", this.encountered_rattlesnake);
            nbt.m_128379_("encountered_ringtail", this.encountered_ringtail);
            nbt.m_128379_("encountered_snake", this.encountered_snake);
            nbt.m_128379_("encountered_whitetail", this.encountered_whitetail);
            nbt.m_128379_("encountered_wolverine", this.encountered_wolverine);
            nbt.m_128379_("encountered_wendigo", this.encountered_wendigo);
            nbt.m_128379_("encountered_skinwalker", this.encountered_skinwalker);
            nbt.m_128379_("encountered_chupacabra", this.encountered_chupacabra);
            nbt.m_128379_("encountered_squonk", this.encountered_squonk);
            nbt.m_128379_("encountered_howler", this.encountered_howler);
            nbt.m_128379_("encountered_sasquatch", this.encountered_sasquatch);
            nbt.m_128379_("recieved_field_guide", this.recieved_field_guide);
            nbt.m_128379_("cipher_secret", this.cipher_secret);
            nbt.m_128379_("encountered_wechuge", this.encountered_wechuge);
            nbt.m_128379_("encountered_caribou", this.encountered_caribou);
            nbt.m_128379_("encountered_turkey", this.encountered_turkey);
            nbt.m_128379_("encountered_marmot", this.encountered_marmot);
            nbt.m_128379_("encountered_skunk", this.encountered_skunk);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.whistles_cooldown = nbt.m_128471_("whistles_cooldown");
            this.whistles = nbt.m_128459_("whistles");
            this.never_show_again_beta = nbt.m_128471_("never_show_again_beta");
            this.encountered_elk = nbt.m_128471_("encountered_elk");
            this.encountered_beaver = nbt.m_128471_("encountered_beaver");
            this.encountered_black_bear = nbt.m_128471_("encountered_black_bear");
            this.encountered_cougar = nbt.m_128471_("encountered_cougar");
            this.encountered_coyote = nbt.m_128471_("encountered_coyote");
            this.encountered_giant_boar = nbt.m_128471_("encountered_giant_boar");
            this.encountered_goose = nbt.m_128471_("encountered_goose");
            this.encountered_greywolf = nbt.m_128471_("encountered_greywolf");
            this.encountered_mouse = nbt.m_128471_("encountered_mouse");
            this.encountered_pit_viper = nbt.m_128471_("encountered_pit_viper");
            this.encountered_rattlesnake = nbt.m_128471_("encountered_rattlesnake");
            this.encountered_ringtail = nbt.m_128471_("encountered_ringtail");
            this.encountered_snake = nbt.m_128471_("encountered_snake");
            this.encountered_whitetail = nbt.m_128471_("encountered_whitetail");
            this.encountered_wolverine = nbt.m_128471_("encountered_wolverine");
            this.encountered_wendigo = nbt.m_128471_("encountered_wendigo");
            this.encountered_skinwalker = nbt.m_128471_("encountered_skinwalker");
            this.encountered_chupacabra = nbt.m_128471_("encountered_chupacabra");
            this.encountered_squonk = nbt.m_128471_("encountered_squonk");
            this.encountered_howler = nbt.m_128471_("encountered_howler");
            this.encountered_sasquatch = nbt.m_128471_("encountered_sasquatch");
            this.recieved_field_guide = nbt.m_128471_("recieved_field_guide");
            this.cipher_secret = nbt.m_128471_("cipher_secret");
            this.encountered_wechuge = nbt.m_128471_("encountered_wechuge");
            this.encountered_caribou = nbt.m_128471_("encountered_caribou");
            this.encountered_turkey = nbt.m_128471_("encountered_turkey");
            this.encountered_marmot = nbt.m_128471_("encountered_marmot");
            this.encountered_skunk = nbt.m_128471_("encountered_skunk");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cnc", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "cnc_mapvars";
        public boolean whistling_enabled = false;
        public boolean is_beta = false;
        public boolean effigy_data = false;
        public boolean is_private_beta = false;
        public boolean crawler_spawn_checker = false;
        public boolean critter_spawn_checker = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.whistling_enabled = nbt.m_128471_("whistling_enabled");
            this.is_beta = nbt.m_128471_("is_beta");
            this.effigy_data = nbt.m_128471_("effigy_data");
            this.is_private_beta = nbt.m_128471_("is_private_beta");
            this.crawler_spawn_checker = nbt.m_128471_("crawler_spawn_checker");
            this.critter_spawn_checker = nbt.m_128471_("critter_spawn_checker");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("whistling_enabled", this.whistling_enabled);
            nbt.m_128379_("is_beta", this.is_beta);
            nbt.m_128379_("effigy_data", this.effigy_data);
            nbt.m_128379_("is_private_beta", this.is_private_beta);
            nbt.m_128379_("crawler_spawn_checker", this.crawler_spawn_checker);
            nbt.m_128379_("critter_spawn_checker", this.critter_spawn_checker);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CncMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "cnc_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CncMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.whistles_cooldown = original.whistles_cooldown;
            clone.never_show_again_beta = original.never_show_again_beta;
            clone.encountered_elk = original.encountered_elk;
            clone.encountered_beaver = original.encountered_beaver;
            clone.encountered_black_bear = original.encountered_black_bear;
            clone.encountered_cougar = original.encountered_cougar;
            clone.encountered_coyote = original.encountered_coyote;
            clone.encountered_giant_boar = original.encountered_giant_boar;
            clone.encountered_goose = original.encountered_goose;
            clone.encountered_greywolf = original.encountered_greywolf;
            clone.encountered_mouse = original.encountered_mouse;
            clone.encountered_pit_viper = original.encountered_pit_viper;
            clone.encountered_rattlesnake = original.encountered_rattlesnake;
            clone.encountered_ringtail = original.encountered_ringtail;
            clone.encountered_snake = original.encountered_snake;
            clone.encountered_whitetail = original.encountered_whitetail;
            clone.encountered_wolverine = original.encountered_wolverine;
            clone.encountered_wendigo = original.encountered_wendigo;
            clone.encountered_skinwalker = original.encountered_skinwalker;
            clone.encountered_chupacabra = original.encountered_chupacabra;
            clone.encountered_squonk = original.encountered_squonk;
            clone.encountered_howler = original.encountered_howler;
            clone.encountered_sasquatch = original.encountered_sasquatch;
            clone.recieved_field_guide = original.recieved_field_guide;
            clone.cipher_secret = original.cipher_secret;
            clone.encountered_wechuge = original.encountered_wechuge;
            clone.encountered_caribou = original.encountered_caribou;
            clone.encountered_turkey = original.encountered_turkey;
            clone.encountered_marmot = original.encountered_marmot;
            clone.encountered_skunk = original.encountered_skunk;
            if (!event.isWasDeath()) {
                clone.whistles = original.whistles;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CncMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CncMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CncMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

