/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.xordev.stopAndCheck.Utils;

public class CheckerCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;

    public CheckerCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        Player sender = commandSender instanceof Player ? (Player)commandSender : null;
        if (sender != null && !sender.hasPermission("sac.command")) {
            sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.no-permission")));
            return true;
        }
        if (strings.length == 0 || strings[0].equalsIgnoreCase("help")) {
            this.send_help(sender);
            return true;
        }
        if (strings[0].equalsIgnoreCase("check")) {
            if (!(commandSender instanceof Player)) {
                this.plugin.getServer().getLogger().log(Level.INFO, "Console can't check player!");
                return true;
            }
            if (!sender.hasPermission("sac.moder.check")) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.no-permission")));
                return true;
            }
            if (strings.length < 2) {
                sender.sendMessage(Utils.color("&c/sac check <player>"));
                return true;
            }
            String playername = strings[1];
            Player player = this.plugin.getServer().getPlayer(playername);
            if (player == null) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.player-offline")));
                return true;
            }
            if (player == sender) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.self-check")));
                return true;
            }
            if (player.hasMetadata("sac_check_player")) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.is-checking")));
                return true;
            }
            if (this.isPlayerOnCheck(player)) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.already-check")));
                return true;
            }
            player.setMetadata("sac_oncheck", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            player.setMetadata("sac_check_moderator", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)sender.getUniqueId().toString()));
            player.setMetadata("sac_beforecheck_pos", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getLocation()));
            sender.setMetadata("sac_check_player", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getUniqueId().toString()));
            String title = Utils.color(this.plugin.getConfig().getString("messages.player.check-title", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430 \u0447\u0438\u0442\u044b"));
            String subtitle = Utils.color(this.plugin.getConfig().getString("messages.player.check-subtitle", "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u0432 \u0447\u0430\u0442\u0435"));
            player.teleport(sender.getLocation());
            player.sendTitle(title, subtitle, 10, 999999, 0);
            List instructions = this.plugin.getConfig().getStringList("messages.player.check-chatmsg");
            instructions.forEach(line -> {
                String formatted = line.replace("{moderator}", sender.getName());
                player.sendMessage(Utils.color(formatted));
            });
            sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.successful-called").replace("{player}", playername)));
        } else if (strings[0].equalsIgnoreCase("free")) {
            if (sender != null && !sender.hasPermission("sac.moder.free")) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.no-permission")));
                return true;
            }
            if (strings.length < 2) {
                if (!(commandSender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(Utils.color("&c/sac free <player>"));
                }
                return true;
            }
            String playername = strings[1];
            Player player = this.plugin.getServer().getPlayer(playername);
            if (player == null) {
                if (!(commandSender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.player-offline")));
                }
                return true;
            }
            if (player == sender) {
                if (!(commandSender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.self-free")));
                }
                return true;
            }
            if (!this.isPlayerOnCheck(player)) {
                if (!(commandSender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.already-free").replace("{player}", player.getName())));
                }
                return true;
            }
            player.removeMetadata("sac_oncheck", (Plugin)this.plugin);
            player.removeMetadata("sac_check_moderator", (Plugin)this.plugin);
            if (!(commandSender instanceof ConsoleCommandSender)) {
                sender.removeMetadata("sac_check_player", (Plugin)this.plugin);
            }
            Location oldPos = (Location)((MetadataValue)player.getMetadata("sac_beforecheck_pos").get(0)).value();
            player.removeMetadata("sac_beforecheck_pos", (Plugin)this.plugin);
            player.teleport(oldPos);
            player.sendTitle("", "", 0, 0, 10);
            player.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.player.free-msg").replace("{moderator}", sender.getName())));
            if (!(commandSender instanceof ConsoleCommandSender)) {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.successful-free").replace("{player}", playername)));
            }
        } else if (strings[0].equalsIgnoreCase("reload")) {
            if (commandSender instanceof ConsoleCommandSender || sender.hasPermission("sac.moder.reload")) {
                try {
                    this.plugin.reloadConfig();
                    if (commandSender instanceof ConsoleCommandSender) {
                        this.plugin.getLogger().log(Level.INFO, "[StopAndCheck] Successful config reload");
                    }
                    sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.cfg-reload")));
                }
                catch (Exception err) {
                    if (commandSender instanceof ConsoleCommandSender) {
                        this.plugin.getLogger().log(Level.SEVERE, "[StopAndCheck] Error when reloading plugin!");
                        this.plugin.getLogger().log(Level.SEVERE, err.getMessage());
                    } else {
                        sender.sendMessage(Utils.color("&c&lError when reloading plugin: &7" + err.getMessage()));
                    }
                    return true;
                }
            } else {
                sender.sendMessage(Utils.color(this.plugin.getConfig().getString("messages.moderator.no-permission")));
                return true;
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            return Arrays.asList("check", "free", "info", "reload", "help").stream().filter(action -> action.startsWith(strings[0].toLowerCase())).collect(Collectors.toList());
        }
        if (strings.length == 2) {
            Set<String> commands_with_players = Set.of("check", "free", "info");
            if (commands_with_players.contains(strings[0].toLowerCase())) {
                return null;
            }
            return List.of();
        }
        return List.of();
    }

    private void send_help(Player ply) {
        List help_text = this.plugin.getConfig().getStringList("messages.player.help");
        help_text.forEach(line -> ply.sendMessage(Utils.color(line)));
    }

    private boolean isPlayerOnCheck(Player player) {
        if (!player.hasMetadata("sac_oncheck")) {
            return false;
        }
        try {
            List metadata = player.getMetadata("sac_oncheck");
            if (metadata.isEmpty()) {
                return false;
            }
            return ((MetadataValue)metadata.get(0)).asBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }
}

